/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
//test
#include "mbed.h"
#include "HIH6130.h"
#include "BLEDevice.h"

BLEDevice  ble;
DigitalOut led1(LED1);

#define PIN_SDA P0_22
#define PIN_SCL P0_20


#define NEED_CONSOLE_OUTPUT 1 /* Set this if you need debug messages on the console;
                               * it will have an impact on code-size and power consumption. */
#if NEED_CONSOLE_OUTPUT
Serial  pc(USBTX, USBRX);
#define DEBUG(...) { pc.printf(__VA_ARGS__); }
#else
#define DEBUG(...) /* nothing */
#endif /* #if NEED_CONSOLE_OUTPUT */

/* Heart Rate Service */
/* Service:  https://developer.bluetooth.org/gatt/services/Pages/ServiceViewer.aspx?u=org.bluetooth.service.heart_rate.xml */
/* HRM Char: https://developer.bluetooth.org/gatt/characteristics/Pages/CharacteristicViewer.aspx?u=org.bluetooth.characteristic.heart_rate_measurement.xml */
/* Location: https://developer.bluetooth.org/gatt/characteristics/Pages/CharacteristicViewer.aspx?u=org.bluetooth.characteristic.body_sensor_location.xml */

uint8_t theCurrTemp = 0xFF;
uint8_t theMaxTemp = 0xCC;
uint8_t theMinTemp = 0x00;
uint8_t theAlarmTemp = 0x11;

static uint8_t theCurrTempArr[20] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, theCurrTemp};
static uint8_t theMaxTempArr[2] = {0x00, theMaxTemp};
static uint8_t theMinTempArr[2] = {0x00, theMinTemp};
static uint8_t theAlarmTempArr[2] = {0x00, theAlarmTemp};

//GattCharacteristic hrmRate(GattCharacteristic::UUID_HEART_RATE_MEASUREMENT_CHAR, bpm, sizeof(bpm), sizeof(bpm),
//                           GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
//static const uint8_t location = 0x03; /* Finger */
//GattCharacteristic hrmLocation(GattCharacteristic::UUID_BODY_SENSOR_LOCATION_CHAR,
//                               (uint8_t *)&location, sizeof(location), sizeof(location),
//                               GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);
//GattCharacteristic *hrmChars[] = {&hrmRate, &hrmLocation, };
//GattService        hrmService(GattService::UUID_HEART_RATE_SERVICE, hrmChars, sizeof(hrmChars) / sizeof(GattCharacteristic *));
const LongUUID_t service =
{
    // DEADF154-0000-0000-0000-0000DEADF154
    0x54, 0xF1, 0xAD, 0xDE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xf1, 0xAD, 0xDE
};

const LongUUID_t currTemp =
{
    // CCCCFFFF-DEAD-F154-1319-740381000000
    0x00, 0x00, 0x00, 0x81, 0x03, 0x74, 0x19, 0x13, 0x54, 0xf1, 0xAD, 0xDE, 0xff, 0xff, 0xCC, 0xCC
};
const LongUUID_t minTemp =
{
    // C0C0C0C0-DEAD-F154-1319-740381000000
    0x00, 0x00, 0x00, 0x81, 0x03, 0x74, 0x19, 0x13, 0x54, 0xf1, 0xAD, 0xDE, 0xC0, 0xC0, 0xC0, 0xC0
};
const LongUUID_t maxTemp =
{
    // EDEDEDED-DEAD-F154-1319-740381000000
    0x00, 0x00, 0x00, 0x81, 0x03, 0x74, 0x19, 0x13, 0x54, 0xf1, 0xAD, 0xDE, 0xED, 0xED, 0xED, 0xED
};
const LongUUID_t alarmTemp =
{
    // AAAAAAAA-DEAD-F154-1319-740381000000
    0x00, 0x00, 0x00, 0x81, 0x03, 0x74, 0x19, 0x13, 0x54, 0xf1, 0xAD, 0xDE, 0xAA, 0xAA, 0xAA, 0xAA
};


GattCharacteristic gattCurrTemp(currTemp, theCurrTempArr, sizeof(theCurrTempArr), sizeof(theCurrTempArr), GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
GattCharacteristic gattMaxTemp(maxTemp, theMaxTempArr, sizeof(theMaxTempArr), sizeof(theMaxTempArr), GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
GattCharacteristic gattMinTemp(minTemp, theMinTempArr, sizeof(theMinTempArr), sizeof(theMinTempArr), GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
GattCharacteristic gattAlarm(alarmTemp, theAlarmTempArr, sizeof(theAlarmTempArr), sizeof(theAlarmTempArr), GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
GattCharacteristic *tempChars[] = {&gattCurrTemp, &gattMaxTemp, &gattMinTemp, &gattAlarm };
GattService deadFishService(service, tempChars, sizeof(tempChars)/sizeof(GattCharacteristic *));
//hrmService(GattService::UUID_HEART_RATE_SERVICE, hrmChars, sizeof(hrmChars) / sizeof(GattCharacteristic *));

HIH6130 hih6130(PIN_SDA, PIN_SCL);

void disconnectionCallback(void)
{
    DEBUG("Disconnected!\n\r");
    DEBUG("Restarting the advertising process\n\r");
    ble.startAdvertising();
}

/**
 * Triggered periodically by the 'ticker' interrupt; updates hrmCounter.
 */
void periodicCallback(void)
{
    led1 = !led1; /* Do blinky on LED1 while we're waiting for BLE events */

    float humidity, temperature;
    hih6130.ReadData(&humidity, &temperature);
    
    if (ble.getGapState().connected) {
        /* Update the HRM measurement */
        /* First byte = 8-bit values, no extra info, Second byte = uint8_t HRM value */
        /* See --> https://developer.bluetooth.org/gatt/characteristics/Pages/CharacteristicViewer.aspx?u=org.bluetooth.characteristic.heart_rate_measurement.xml */
        //hrmCounter++;
//        if (hrmCounter == 175) {
//            hrmCounter = 100;
//        }
//        bpm[1] = hrmCounter;
//        bpm[1] = 0xCC;
//        bpm[1] = (uint8_t)temperature;
//        DEBUG("cast temp to %d", bpm[1]);
//        ble.updateCharacteristicValue(hrmRate.getHandle(), bpm, sizeof(bpm));
        theCurrTempArr[1]++;
        ble.updateCharacteristicValue(gattCurrTemp.getHandle(), theCurrTempArr, sizeof(theCurrTempArr));
    }
}

int main(void)
{
    led1 = 1;
    Ticker ticker;
    ticker.attach(periodicCallback, 0.2);

    DEBUG("Initialising the nRF51822\n\r");
    ble.init();
    ble.onDisconnection(disconnectionCallback);

    /* setup advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::HEART_RATE_SENSOR_HEART_RATE_BELT);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.setAdvertisingInterval(160); /* 100ms; in multiples of 0.625ms. */
    ble.startAdvertising();
    DEBUG("Started Advertising\n\r");

    ble.addService(deadFishService);
    DEBUG("Added service");

    while (true) {
        ble.waitForEvent();
    }
}
