/**
 * Notebook page https://os.mbed.com/users/JohnnyK/notebook/how-start-with-the-littlevgl/
 */

#include "mbed.h"
#include "lvgl/lvgl.h"
#include "hal_stm_lvgl/tft/tft.h"
#include "hal_stm_lvgl/touchpad/touchpad.h" 
#include "lv_demo.h"    /*Comment/uncomment will switch between LVGL demo and Hello word example*/

#define LVGL_TICK   10                               //Time tick value for lvgl in ms (1-10msa)
#define TICKER_TIME 10ms                             //modified to miliseconds

PwmOut servo1(D9);
PwmOut servo2(D10); 
InterruptIn echo(A1);       //echo
DigitalOut trigger(A2);     // trigger
DigitalOut myled(D8);
Ticker ticker;                                       //Ticker for lvgl                    
Timer timer;
int distance = 0;
int correction = 0;

 
void startTimer() { // fonction pour commence mesurer echo
    timer.start();
}
void stopTimer() { // fonction pour arrete mesurer echo
    timer.stop();
}
const int positionMin = 700;
const int positionMax = 1500;
const int positionMin1 = 700;
const int positionMax1  = 1500;


/*
 * Callback function for lvgl timing.
 * Call lv_tick_inc(x) every x milliseconds in a Timer or Task (x should be between 1 and 10). 
 * It is required for the internal timing of LittlevGL.
 */
void lv_ticker_func(){
    lv_tick_inc(LVGL_TICK); 
}

static void event_handler(lv_event_t* event)
{
    lv_event_code_t code = lv_event_get_code(event);
    if(code == LV_EVENT_CLICKED) {
        printf("Clicked\n");
        printf("Clicked\n");
        
            servo1.period_ms(20);
            servo2.period_ms(20);
             for(int i=positionMin1; i<positionMax1; i += 10) {
            servo1.pulsewidth_us(i);
            servo2.pulsewidth_us(i);

            wait_us(3000); }
        }
    else if(code == LV_EVENT_VALUE_CHANGED) {
        printf("Toggled\n");
    }
}

static void my_event_cb(lv_event_t* event)
{

    lv_event_code_t code = lv_event_get_code(event);
    if(code == LV_EVENT_CLICKED) {
        printf("Clicked\n");
            servo1.period_ms(20);
            servo2.period_ms(20);
             //for(int i=positionMin; i<positionMax; i += 10) {
            servo1.pulsewidth_us(2500);
            wait_us(40000);
            servo2.pulsewidth_us(500);
            wait_us(6000);
            //lv_label_set_text(label3, "Ouvert");
 
            }

    else if(code == LV_EVENT_VALUE_CHANGED) {
        printf("Toggled\n");
    }
}

// main() runs in its own thread in the OS
int main()
{
//    echo.rise(&startTimer); //On commence compter le temps quand on a un niveau montant 
//    echo.fall(&stopTimer); //On arrete compter le temps quand on a un niveau decendant 
        
    printf("LVGL-"); 
    lv_init();                                              //Initialize the LVGL
    tft_init();                                             //Initialize diplay 
    touchpad_init();                                        //Initialize touchpad
    ticker.attach(callback(&lv_ticker_func),TICKER_TIME);   //Attach callback to ticker


    lv_obj_t * label1 = lv_label_create(lv_scr_act());
    lv_label_set_long_mode(label1, LV_LABEL_LONG_WRAP);     /*Break the long lines*/
    lv_label_set_recolor(label1, true);                      /*Enable re-coloring by commands in the text*/
    lv_label_set_text(label1, "Projet portail");
    lv_obj_set_width(label1, 150);
    lv_obj_align(label1, LV_ALIGN_TOP_MID, 25, 0);
    
    lv_obj_t * label;
    lv_obj_t * btn1 = lv_btn_create(lv_scr_act());
    
    lv_obj_add_event_cb(btn1, my_event_cb, LV_EVENT_ALL, NULL);
    lv_obj_align(btn1, LV_ALIGN_CENTER, -50, 50);
    label = lv_label_create(btn1);
    lv_label_set_text(label, "Fermer");

    
    lv_obj_t * btn2 = lv_btn_create(lv_scr_act());
    lv_obj_add_event_cb(btn2, event_handler,LV_EVENT_ALL, NULL);
    lv_obj_align(btn2, LV_ALIGN_CENTER, -50, -25);
    label = lv_label_create(btn2);
    lv_label_set_text(label, "Ouvrir");

//continue ici//

    static lv_style_t style;
    lv_style_init(&style);
    lv_style_set_radius(&style, 5);

    /*Make a gradient*/
    lv_style_set_width(&style, 150);
    lv_style_set_height(&style, LV_SIZE_CONTENT);

    lv_style_set_pad_ver(&style, 20);
    lv_style_set_pad_left(&style, 5);

    lv_style_set_x(&style, lv_pct(50));
    lv_style_set_y(&style, 80);

    /*Create an object with the new style*/
    lv_obj_t * obj = lv_obj_create(lv_scr_act());
    lv_obj_add_style(obj, &style, 0);

    lv_obj_t * label3 = lv_label_create(obj);

    lv_obj_align(label3, LV_ALIGN_TOP_MID, 0, 50);
    lv_obj_t * label4 = lv_label_create(obj);


    while (true){
        float Tar;
        lv_task_handler(); 
        //Call lv_task_handler() periodically every few milliseconds. 
        //It will redraw the screen if required, handle input devices etc.
        thread_sleep_for(LVGL_TICK); 
        /** On commence le trigger et arrete avec un period de 10us */
        trigger = 1; //Mettre trigger en niveau haut
        wait_us(10);//Period 1 trigger
        
        Tar = timer.read()*1e6; //Temps aller retour on a recu s=>u                                                        s donc il faut multiplier par 1e6
        float distance = Tar*343/2*1e-3/10; //Formule calculer la distance en cm (On divise par 10 pour mm>cm) 
        timer.reset(); // reset le temp aller retour a 0
        wait_us(1000);
        lv_label_set_text_fmt(label3, "distance: %0.2f cm \r\n",distance);
        
        if(abs(distance>2))
        { //Valeur absolute si superieur a 2cm
        lv_label_set_text(label4,"Obstacle");
        //lv_btn_set_checkable(btn1, true)
        myled = 0;

    }
    else
    {
        lv_label_set_text(label4,"Aucun obstacle");

        myled = 1;
        }
}
}