#ifndef CONFIGS_h
#define CONFIGS_h
///////////////////////////////////  HARDWARE SELECTION ///////////////////////////////////

// Board select, if none selected - LPC1768 assumed
#define NORDIC         // nRF51822         (highest priority)
#define NUCLEO          // Nucleo-F411RE    (lesser priority)
#define HARD_V2         // version 2 hardware for nRF51822

// Frequency select 
//#define FREQUENCY     RF69_868MHZ
#define FREQUENCY     RF69_915MHZ

#define HIGH_POWER      // High power radio

// Output select
#define NO_DISP        // No display?
#define NO_SERIAL       // Send info over serial? 
#define TEXT_LCD        // Text LCD display
#define _I2C_DISP       // I2C display (SPI assumed)
#define ENABLE_SOUND    // Turns on sound in the beep() function
#define ENABLE_PIN      // is there a pin to enable radio via MOSFET?
#define BLE_ENABLE      // enable BlueTooth FOTA

///////////////////////////////////  CONSTANTS   ///////////////////////////////////

#define EVERY_NODE 255  // Abstract address we are sending the packets to (doesn't matter)
#define NETWORKID 102   // The same on all nodes that talk to each other

#define CYCLE_MS 2400
#define SEND_RATE_MS 400L       // 0.33 s
//#define SEND_DESYNC 0.20        // 0.20 -> send rate +/-10%
#define MAX_RECORDS 6
#define NAME_LEN 5
#define SIGNALS_VALID_MS 4000  
#define MAX_HISTORY_MS 30000    // 30 seconds

#define NOTE_A3 0.004545454
#define NOTE_A4 0.002272727
#define NOTE_A5 0.001136363

const uint8_t SPACE[] = {1, 50, 60, 100};      // 5, 10, 15, 20 meters

// P-MOSFET
#define LOW_ON 0
#define LOW_OFF 1

#ifdef HARD_V2

// N-MOSFETS
#define MED_ON 1
#define MED_OFF 0
#define HIGH_ON 1
#define HIGH_OFF 0

#else // HARD_V2

// P-MOSFETS
#define MED_ON 0
#define MED_OFF 1
#define HIGH_ON 0
#define HIGH_OFF 1

#endif // HARD_V2

///////////////////////////////////  LOGIC  ///////////////////////////////////
#ifdef NORDIC

#ifndef NO_DISP
#define NO_DISP     // NORDIC --> no display (use Serial)
#endif

#ifdef NUCLEO
#undef NUCLEO     // NORDIC --> not NUCLEO
#endif


#define PRESSED 1
#define RELEASED 0

#else // not NORDIC

#ifdef BLE_ENABLE 
#undef BLE_ENABLE   // not NORDIC -> no BLE
#endif

#define PRESSED 0
#define RELEASED 1

#endif // NORDIC

#ifdef ENABLE_SOUND
#ifdef NORDIC
#ifdef HARD_V2
#define _TEST_LED_SOUND
#endif 
#endif
#endif

///////////////////////  PINS  ///////////////////////
#ifdef NORDIC

#ifdef HARD_V2 

#define LED_SPACE5      P0_21
#define LED_SPACE10     P0_22
#define LED_SPACE15     P0_0
#define LED_SPACE20     P0_29
#define LED_TEAM_A      P0_11
#define LED_TEAM_B      P0_9
#define LED_BUZZER_ON   P0_8

#define BUZZER          P0_5
#define BUZZ_HIGH       P0_4
#define BUZZ_MED        P0_1

#define BUT_VOL_MORE    P0_28
#define BUT_VOL_LESS    P0_10
#define BUT_SPACE       P0_15
#define BUT_TEAM        P0_13

#else // HARD_V2

#define LED_SPACE5      P0_7
#define LED_SPACE10     P0_8
#define LED_SPACE15     P0_9
#define LED_SPACE20     P0_11
#define LED_TEAM_A      P0_22
#define LED_TEAM_B      P0_0
#define LED_BUZZER_ON   P0_3

#define BUZZER          P0_5
#define BUZZ_HIGH       P0_4
#define BUZZ_MED        P0_1
#define BUZZ_LOW        P0_2

#define BUT_VOL_MORE    P0_28
#define BUT_VOL_LESS    P0_10
#define BUT_SPACE       P0_21
#define BUT_TEAM        P0_15

#endif // HARD_V2

#define RFM_MOSI        P0_19
#define RFM_MISO        P0_18
#define RFM_SCK         P0_17
#define RFM_SS          P0_20
#define RFM_IRQ         P0_12
#ifdef ENABLE_PIN
#define RFM_ISM_EN      P0_16
#endif // ENABLE_PIN

#define CHARGE          P0_6
#define V_MEAS
#define VBAT
#define PWR_BTN

#define ANALOG_IN       CHARGE

#else 
#ifdef NUCLEO

#define LED_SPACE5      PC_3
#define LED_SPACE10     D1
#define LED_SPACE15     PA_14
#define LED_SPACE20     PA_15
#define LED_TEAM_A      PC_11
#define LED_TEAM_B      PB_2
#define LED_BUZZER_ON   PD_2

#define BUZZER          PB_8
#define BUZZ_HIGH       
#define BUZZ_MED        
#define BUZZ_LOW        

#define BUT_VOL_MORE    PC_12
#define BUT_VOL_LESS    PC_10
#define BUT_SPACE       PH_1
#define BUT_TEAM        USER_BUTTON

#define RFM_MOSI        D11
#define RFM_MISO        D12
#define RFM_SCK         D13
#define RFM_SS          D10
#define RFM_IRQ         D9
#ifdef ENABLE_PIN
#define RFM_ISM_EN      PA_13
#endif // ENABLE_PIN
#define CHARGE
#define V_MEAS
#define VBAT
#define PWR_BTN

#define ANALOG_IN       A5


#else // it's LPC

#define LED_SPACE5      
#define LED_SPACE10     
#define LED_SPACE15     
#define LED_SPACE20     
#define LED_TEAM_A      
#define LED_TEAM_B      
#define LED_BUZZER_ON   

#define BUZZER          p21
#define BUZZ_HIGH       
#define BUZZ_MED        
#define BUZZ_LOW        

#define BUT_VOL_MORE    
#define BUT_VOL_LESS    
#define BUT_SPACE       
#define BUT_TEAM        p5

#define RFM_MOSI        p11
#define RFM_MISO        p12
#define RFM_SCK         p13
#define RFM_SS          p10
#define RFM_IRQ         p9
#ifdef ENABLE_PIN
#define RFM_ISM_EN      
#endif // ENABLE_PIN

#define CHARGE
#define V_MEAS
#define VBAT
#define PWR_BTN

#define ANALOG_IN       p15

#endif // NUCLEO
#endif // NORDIC 


////////////////////////////////////////////////////////////
#endif // CONFIGS_h