#include    "mbed.h"
#include    "GpioDigitalInOut.h"

GpioDigitalInOut::GpioDigitalInOut( CompGpioExp &gpiop, GpioPinName pin_name )
    : gpio_p( &gpiop ), pin( pin_name ), output_state( 1 ), config_state( 1 )
{
    this->input();
}

GpioDigitalInOut::~GpioDigitalInOut()
{
}

void GpioDigitalInOut::write( int v )
{
    output_state   = v;
    gpio_p->write( pin, output_state );
}

void GpioDigitalInOut::configure( int pin, int v )
{
    config_state    = v;
    gpio_p->configure( pin, config_state );
}

int GpioDigitalInOut::read( void )
{
    if ( config_state )
        return ( gpio_p->read( pin ) );
    else
        return ( output_state );
}

void GpioDigitalInOut::input( void )
{
    config_state    = 1;
    gpio_p->configure( pin, config_state );
}

void GpioDigitalInOut::output( void )
{
    config_state    = 0;
    gpio_p->configure( pin, config_state );
}

GpioDigitalInOut& GpioDigitalInOut::operator=( int rhs )
{
    write( rhs );
    return ( *this );
}

GpioDigitalInOut& GpioDigitalInOut::operator=( GpioDigitalInOut& rhs )
{
    write( rhs.read() );
    return *this;
}

GpioDigitalInOut::operator int( void )
{
    return( read() );
}
