/** GPIO expander abstraction class 
 *
 *  No instance can be made from this class
 *
 *  @class   CompGpioExp
 *  @author  Akifumi (Tedd) OKANO, NXP Semiconductors
 *  @version 0.6
 *  @date    19-Mar-2015
 *
 *  Released under the Apache 2 license
 */

#ifndef     MBED_CompGpioExp
#define     MBED_CompGpioExp

#include    "mbed.h"

typedef enum {
    // GPIO Expander pin names
    X0_0,           /**< P0_0 pin                                   */
    X0_1,           /**< P0_1 pin                                   */
    X0_2,           /**< P0_2 pin                                   */
    X0_3,           /**< P0_3 pin                                   */
    X0_4,           /**< P0_4 pin                                   */
    X0_5,           /**< P0_5 pin                                   */
    X0_6,           /**< P0_6 pin                                   */
    X0_7,           /**< P0_7 pin                                   */
    X1_0,           /**< P1_0 pin (for 16-bit GPIO device only)     */
    X1_1,           /**< P1_1 pin (for 16-bit GPIO device only)     */
    X1_2,           /**< P1_2 pin (for 16-bit GPIO device only)     */
    X1_3,           /**< P1_3 pin (for 16-bit GPIO device only)     */
    X1_4,           /**< P1_4 pin (for 16-bit GPIO device only)     */
    X1_5,           /**< P1_5 pin (for 16-bit GPIO device only)     */
    X1_6,           /**< P1_6 pin (for 16-bit GPIO device only)     */
    X1_7,           /**< P1_7 pin (for 16-bit GPIO device only)     */
    X0  = X0_0,     /**< P0_0 pin                                   */
    X1  = X0_1,     /**< P0_1 pin                                   */
    X2  = X0_2,     /**< P0_2 pin                                   */
    X3  = X0_3,     /**< P0_3 pin                                   */
    X4  = X0_4,     /**< P0_4 pin                                   */
    X5  = X0_5,     /**< P0_5 pin                                   */
    X6  = X0_6,     /**< P0_6 pin                                   */
    X7  = X0_7,     /**< P0_7 pin                                   */
    X8  = X1_0,     /**< P1_0 pin (for 16-bit GPIO device only)     */
    X9  = X1_1,     /**< P1_1 pin (for 16-bit GPIO device only)     */
    X10 = X1_2,     /**< P1_2 pin (for 16-bit GPIO device only)     */
    X11 = X1_3,     /**< P1_3 pin (for 16-bit GPIO device only)     */
    X12 = X1_4,     /**< P1_4 pin (for 16-bit GPIO device only)     */
    X13 = X1_5,     /**< P1_5 pin (for 16-bit GPIO device only)     */
    X14 = X1_6,     /**< P1_6 pin (for 16-bit GPIO device only)     */
    X15 = X1_7,     /**< P1_7 pin (for 16-bit GPIO device only)     */
    X_NC = ~0x0L    /**< for when the pin is left no-connection     */
} GpioPinName;

/** Abstract class for GPIO expander devices
 *  
 *  No instance can be made from this class
 */
class CompGpioExp
{
public:
    CompGpioExp();
    virtual ~CompGpioExp();

    virtual void    write( int pin, int value )     = 0;
    virtual int     read( int pin )                 = 0;
    virtual void    configure( int pin, int value ) = 0;
    virtual int     read( void )                    = 0;
    virtual void    write_with_mask( int bitpattern, int mask_bits )        = 0;
    virtual void    configure_with_mask( int bitpattern, int mask_bits )    = 0;
}
;

#endif  //  MBED_CompGpioExp


