/** PCAL955x GPIO with Agile I/O, interrupt and weak pull-up family
 *
 *  Abstract class for PCAL955x/PCAL6416 family
 *  No instance can be made from this class
 *
 *  @class    PCAL955x
 *  @author   Akifumi (Tedd) OKANO, NXP Semiconductors
 *  @version  0.5.1
 *  @date     07-Mar-2015
 *  @modified 15-Feb-2017, by Andriy Makukha, Shenzhen MZJ Technology Co.
 *
 *  Released under the Apache 2 license
 */

#ifndef     MBED_PCAL955x
#define     MBED_PCAL955x

#include    "mbed.h"
#include    "CompGpioExp.h"

/** Abstract class for PCAL955x/PCAL6416 family
 *  
 *  No instance can be made from this class
 */
class PCAL955x : public CompGpioExp
{
public:
    enum register_index {
        INPUT,
        OUTPUT,
        POLARITY,
        CONFIG,
        ODS0,
        ODS1,
        IN_LATCH,
        PULL_EN,
        PULL_SEL,
        INT_MASK,
        INT_STAT,
        OPC
    };

    PCAL955x( PinName i2c_sda, PinName i2c_scl, char i2c_address = DEFAULT_I2C_ADDR );
    PCAL955x( I2C &i2c_obj, char i2c_address = DEFAULT_I2C_ADDR );
    virtual ~PCAL955x();

    virtual void    write( int pin, int value );
    virtual int     read( int pin );
    virtual void    configure( int pin, int value );
    virtual int     read( void );   
    virtual void    write_with_mask( int bitpattern, int mask_bits );
    virtual void    configure_with_mask( int bitpattern, int mask_bits );
    
    void            write( int bit_pattern );
    void            polarity( int bit_pattern );
    void            configure( int bit_pattern );

    void            interrupt_mask( int bit_pattern );
    int             interrupt_status( void );

    virtual int     number_of_pins( void )                     = 0;
    virtual void    reg_index_write( char reg_addr, int data )  = 0;
    virtual int     reg_index_read( char reg_addr )             = 0;
                    operator int( void );

protected:
    enum {
        DEFAULT_I2C_ADDR    = 0x40,
    };

    void bus_write( char *dp, int length );
    void bus_read( char reg_addr, char *dp, int length );

private:
    I2C             *i2c_p;
    I2C             &i2c;
    char            address;    //  I2C slave address
    int             pin_state;
    int             pin_direction;
}
;

#endif  //  MBED_PCAL955x