#include    "mbed.h"
#include    "PCAL6416.h"


PCAL6416::PCAL6416( PinName i2c_sda, PinName i2c_scl, char i2c_address )
    : PCAL955x( i2c_sda, i2c_scl, i2c_address ), n_of_pins( 16 )
{
}

PCAL6416::PCAL6416( I2C &i2c_obj, char i2c_address )
    : PCAL955x( i2c_obj, i2c_address ), n_of_pins( 16 )
{
}

PCAL6416::~PCAL6416()
{
}

int PCAL6416::number_of_pins( void )
{
    return ( n_of_pins );
}

void PCAL6416::reg_index_write( char reg_index, int data )
{
    char    a[ 3 ];

    a[ 0 ]  = regmap[ reg_index ];
    a[ 1 ]  = data;
    a[ 2 ]  = data >> 8;

    bus_write( a, sizeof( a ) );
}

int PCAL6416::reg_index_read( char reg_index )
{
    char    a[ 2 ];

    bus_read( regmap[ reg_index ], a, sizeof( a ) );

    return ( ((int)(a[ 1 ]) << 8) | a[ 0 ] );
}

PCAL6416& PCAL6416::operator= ( int bit_pattern )
{
    write( bit_pattern );
    return ( *this );
}

PCAL6416& PCAL6416::operator= ( PCAL6416& rhs )
{
    write( rhs.read() );
    return *this;
}

const char PCAL6416::regmap[]   = {
    InputPort,
    OutoutPort,
    PolarityInversionPort,
    ConfigurationPort,
    OutputDriveStrength0,
    OutputDriveStrength1,
    InputLatch,
    PullUpPullDowmEnable,
    PullUpPullDowmSelection,
    InterruptMask,
    InterruptStatus,
    OutputPortConfiguration
};
