/** 
@file TMP102.h

@brief Header file containing member functions and variables

*/

// header guard
#ifndef TMP102_H
#define TMP102_H

// addresses
#define TMP102_ADD      0x48
#define TMP102_R_ADD    0x91
#define TMP102_W_ADD    0x90

// registers
#define TEMP_REG    0x00
#define CONFIG_REG  0x01
#define TLOW_REG   0x02
#define THIGH_REG    0x03

#include "mbed.h"

/**
@brief Library for interfacing with TMP102 sensor in I2C

@brief v 1.0 - initial release

@author Craig A. Evans

@date January 2016

*/

class TMP102
{

public:
    
    /** Create a TMP102 object connected to the specified I2C pins
    *
    * @param sda - mbed SDA pin 
    * @param scl - mbed SCL pin
    * 
    */
    
    TMP102(PinName sda, PinName scl);
    
    /** Initialise the object
    */
    void init();
    
    /** Retrieve the temperature
    *
    * @returns temperature in degrees Celsius (°C)
    *
    */
    float get_temperature();
    
private:

    /** Called in event of error - flashes LED and hangs
    */
    void error();
    /** Reads temperature from the sensor
    */
    void read_temperature();
    
    
public:
    
    
private:

    /**Class data member names often have a trailing underscore to make them easily identifiable
    */
    I2C* i2c_;
    DigitalOut* led_;
    float temperature_;

};

#endif