#include "Servo.h"
#include "mbed.h"

/**
 * Servo constructor
 *
 * Initialize variables, attach to a PWM-enabled pin.
 */
Servo::Servo(PinName pwm32) : _pwm(pwm32) {
    _period = 0;
    _min = 0;
    _max = 0;
    _pos = 0;
    invert = 0;
}

/**
 * float read
 *
 * Read the value shat should be at the servo.
 */
float Servo::read(void) {
    return _pos;
}

/**
 * void write
 *
 * Write a value to the servo
 *
 * @param float to Positional data taking values of 0.0 to 1.0.
 */
void Servo::write(float to) {
    if(to < 0 || to > 1) return;
    _pos = to;
    float dest_pw;
    if(invert == 0) {
        dest_pw = to * _slope + _min;
    }
    else if(invert == 1) {
        dest_pw = to * -_slope + _max;
    }
    else { return; }
    _pwm.pulsewidth(dest_pw);
}

/**
 * void calibrate
 *
 * Set the limits of the PWM.
 *
 * @param float period Pulse period in seconds
 * @param float max Maximum pulse width in seconds
 * @param float min Minimum pulse width in seconds
 */
void Servo::calibrate(float period, float min, float max) {
    _period = period;
    _min = min;
    _max = max;
    _slope = max - min;
    
    _pwm.period(_period);
}