#ifndef __TEMP_CONTROLLER_H
#define __TEMP_CONTROLLER_H

#include "stm32f103c8t6.h"
#include "mbed.h"
#include "mbed_events.h"
//#include <stdio.h>
#include "DS1820.h"
#include "PinDetect.h"
#include "Watchdog.h"
#include "eeprom_flash.h"
#include <string>


void start_temp();                              // start temp conversion
void check_temp();                              // check temp sensor state and read temp
void process_temp();                            // process heating algorithm
unsigned int get_temp_config_value();           // get config value from EEPROM
unsigned int get_mode_config_value();           // get mode value from EEPROM 
void save_new_config();                         // save new config to EEPROM
void set_pomp_and_heater_by(float * work_temp, 
                            unsigned char min_mebel_temp,
                            unsigned char min_litos_temp,
                            unsigned char min_back_water_temp,
                            unsigned char max_hot_water_temp) ;     // sets state of pomp and heater depends on input temp

#endif