#include "stm32f103c8t6.h"
#include "mbed.h"
#include "mbed_events.h"
#include "DS1820.h"
#include "PinDetect.h"
#include "Watchdog.h"
#include "eeprom_flash.h"
#include <string> 
#include "temp_controller.h"

// Create a queue that can hold a maximum of 32 events
EventQueue queue(32 * EVENTS_EVENT_SIZE);
// Create a thread that'll run the event queue's dispatch function
//Thread t;

Watchdog wd;
unsigned int eeprom_config_value;
extern char working_mode;
extern int temp_error[];
extern float temp[];
extern float simulated_temp[];
extern int error_count;

Serial  pc(PA_2, PA_3); // (TX, RX) Pin definition
char a[128] = "";       // RX command buffer
char i = 0;             // RX char pointer
static char recieved = 0;


DigitalOut  myled(LED1);

DigitalOut  pomp_OFF(PA_12);          // pomp off
DigitalOut  heater_OFF(PA_15);        // heater off

DigitalOut  reset_wifi(PA_4);        // reset WIFI

// This function is called when a character goes into the RX buffer.
void rxCallback() {
    char c;
    c = pc.getc();
    if (recieved == 0){ // skip if command was already received
        if ( c  == 0x0d || c  == 0x0a ) { 
             while ( pc.readable() ) c = pc.getc();
             recieved = 1;
        } else {
            if (i==127){     // max length of command from SERIAL
                a[0] = c;
                a[1] = '\0';
                i = 0;
            } else { 
                a[i] = c;
                i++;
                a[i] = '\0';
            };
       };
    };
};
 
void blink_myled(char amount) {
    while (amount > 0) {
        myled = 0;
        wait(0.1);
        myled = 1;
        wait(0.2);
        amount--;
    };
}; 
 
void pb_hit_interrupt (void) {
    
    //writeEEPROMWord(0, 666 );
    //epprom_config_value++;
    working_mode ++;
    blink_myled(working_mode);
    if (working_mode == 7) working_mode=0;
    
    //pc.printf("working_mode %d \r\n", working_mode); 
    //pc.printf("Button pressed \r\n"); 
}; 

void pb_out_interrupt (void) {
    //queue.call_in(2000, printf, "called in 2 seconds\n");
    //pc.printf("Button unpressed\r\n"); 
}; 


void at_command(){
        int x;
        int ii;
        int jj;
        
        char given_min_mebel;
        char given_min_litos;
        char given_min_back;
        char given_max_hot;
        
        char num[10];
        char config_string[20];
        
        
        if (recieved == 1) {
            
            __disable_irq();
            
            if (strcmp(a,"AT get all")==0) {
                // config_ram|config_rom|mode|status0|status1|status2|status3|status4|temp0|temp1|temp2|temp3|temp4|pomp_OFF|heater_OFF
                pc.printf("%u|%u|", eeprom_config_value, readEEPROMWord(0));
                if (working_mode==3 || working_mode==4) {
                    pc.printf("%d|%d|%d|%d|%d|%d|", working_mode, 0, 0, 0, 0, 0);
                    pc.printf("%3.1f|%3.1f|%3.1f|%3.1f|%3.1f|%d|%d\r\n", 
                                    simulated_temp[0], 
                                    simulated_temp[1], 
                                    simulated_temp[2], 
                                    simulated_temp[3], 
                                    simulated_temp[4],
                                    (uint8_t)pomp_OFF,
                                    (uint8_t)heater_OFF
                            );                
                } else {
                    pc.printf("%d|%d|%d|%d|%d|%d|", working_mode, temp_error[0], temp_error[1], temp_error[2], temp_error[3], temp_error[4]);
                    pc.printf("%3.1f|%3.1f|%3.1f|%3.1f|%3.1f|%d|%d\r\n", temp[0], temp[1], temp[2], temp[3], temp[4], (uint8_t)pomp_OFF , (uint8_t)heater_OFF);                                 
                };
            } else if (strcmp(a,"AT")==0) {
                pc.printf("OK\r\n");
            } else if (strcmp(a,"AT get config")==0) {
                pc.printf("%u|%u\r\n", eeprom_config_value, readEEPROMWord(0));
            } else if (strncmp(a,"AT set config ",14)==0) {
                ii = 14;
                jj= 0;
                //get rest of AT string for config value
                while (a[ii]!='\0') {           
                    config_string[jj] = a[ii];
                    ii++;
                    jj++;
                };                 
                config_string[jj] = '\0';
                
                // check if given temp in right range
                int config_int = atol(config_string);
                given_min_mebel = config_int >> 24;
                given_min_litos = (config_int >> 16) & 0x000000FF;
                given_min_back = (config_int >> 8) & 0x000000FF;
                given_max_hot = config_int & 0x000000FF;
                
                if ( given_min_mebel > 2 &&  given_min_mebel < 21
                        && given_min_litos > 2 &&  given_min_litos < 21
                        && given_min_back > 2 &&  given_min_back < 21
                        && given_max_hot > 15 &&  given_max_hot < 51) {
                            // all given temps are in right range
                        eeprom_config_value = config_int;
                        pc.printf("%u\r\n", eeprom_config_value);
                } else {
                        pc.printf("Out of range\r\n");
                };                
                
            } else if (strcmp(a,"AT get status")==0) {
                pc.printf("%d|%d|%d|%d|%d|%d|%d\r\n", temp_error[0], temp_error[1], temp_error[2], temp_error[3], temp_error[4], (uint8_t)pomp_OFF , (uint8_t)heater_OFF);
            } else if (strcmp(a,"AT get temp")==0) {
                pc.printf("%3.1f|%3.1f|%3.1f|%3.1f|%3.1f\r\n", temp[0], temp[1], temp[2], temp[3], temp[4]);
            } else if (strcmp(a,"AT get sim temp")==0) {
                pc.printf("%3.1f|%3.1f|%3.1f|%3.1f|%3.1f\r\n", simulated_temp[0], simulated_temp[1], simulated_temp[2], simulated_temp[3], simulated_temp[4]);
            } else if (strcmp(a,"AT get mode")==0) {
                pc.printf("%d\r\n", working_mode);
            } else if (strncmp(a,"AT set mode ",12) == 0) {            
                x= (int)a[12] - 48;                    
                working_mode = ( x >= 0 && x <=6 ) ? x : working_mode;
                error_count = 0;
                pc.printf("%d\r\n", working_mode);                
            } else if (strncmp(a,"AT set sim temp ", 16) == 0) {
                // from a[16] "t0|t1|t2|t3|t4\0"
                ii = 16;
                for (int j=0; j<6; j++) {
                    jj = 0;
                    while ( a[ii]!='|' && a[ii]!='\0') {
                        num[jj] = a[ii];
                        ii++;
                        jj++;
                    };
                    ii++;
                    num[jj] = '\0';
                    simulated_temp[j] = (float)atol(num);
                };
                pc.printf("%3.1f|%3.1f|%3.1f|%3.1f|%3.1f\r\n", 
                            simulated_temp[0], 
                            simulated_temp[1], 
                            simulated_temp[2], 
                            simulated_temp[3], 
                            simulated_temp[4]
                        );
            } else {
                pc.printf("Bad request\r\n");   
            };
            
            __enable_irq(); 

            // ready for new command
            recieved = 0;
            a[0] = '\0';
            i = 0;
        }; 
};

void flushSerialBuffer(void) { 
    char char1 = 0; 
    while (pc.readable()) { 
        char1 = pc.getc(); 
    }; 
    return; 
}; 

  
int main() {
        
    confSysClock();     //Configure system clock (72MHz HSE clock, 48MHz USB clock)
    
    heater_OFF = 1;
    pomp_OFF = 1;
    reset_wifi = 0;
    
    eeprom_config_value = get_temp_config_value();
    working_mode = (char)get_mode_config_value();
    
    wd.Configure(10.0);

    PinDetect   pb(PA_11);
    pb.mode(PullUp);
    
    // Delay for initial pullup to take effect
    wait(.15);
    
    reset_wifi = 1;    // starts esp8266
    
    pb.attach_deasserted(&pb_hit_interrupt);
    pb.attach_asserted(&pb_out_interrupt);
    //pb.rise(&pb_out_interrupt);
    pb.setSampleFrequency();
    
    
    pc.attach(&rxCallback, Serial::RxIrq);
    pc.baud(19200);  
    flushSerialBuffer();
    //pc.printf("\r\nNaumovich 2.0\r\n"); 
    
    blink_myled(3);
    
    
    
    queue.call( start_temp );
    queue.call_every(100, at_command);
    queue.call_every(1000, check_temp);
    queue.call_every(1000, process_temp);
    
    // Start queue 
    queue.dispatch();
};
 