#ifndef SWERVEDRIVE_H
#define SWERVEDRIVE_H

#include "mbed.h"
#include "SwerveModule.h"

#define ROTATION_GAIN 1
#define PI 3.1415

class SwerveDrive {
private:
    SwerveModule* _fl_module;
    SwerveModule* _fr_module;
    SwerveModule* _bl_module;
    SwerveModule* _br_module;
//    DigitalOut _en;
//    uint32_t _prev_time;

public:
    SwerveDrive(SwerveModule* fl_module, SwerveModule* fr_module, SwerveModule* bl_module, SwerveModule* br_module) : //, DigitalOut en) : 
        _fl_module(fl_module), 
        _fr_module(fr_module),
        _bl_module(bl_module),
        _br_module(br_module) {}
//        _en(en),
//        _prev_time(0) {}
    
    void begin() {
        _fl_module->begin();
        _fr_module->begin();
        _bl_module->begin();
        _br_module->begin();
    }
    
    void kill(){
        _fl_module->kill();
        _fr_module->kill();
        _bl_module->kill();
        _br_module->kill();
    }
    
    void update(uint32_t curr_time) {
        _fl_module->update(curr_time);
        _fr_module->update(curr_time);
        _bl_module->update(curr_time);
        _br_module->update(curr_time);
    }
    
    // forward from -1 to 1, strafe from -1 to 1, rotation from -1 to 1
    void drive(float fwd, float str, float rcw, uint32_t curr_time){
        rcw *= ROTATION_GAIN;
        float A = str - rcw*(1.0f/sqrt(2.0f));
        float B = str + rcw*(1.0f/sqrt(2.0f));
        float C = fwd - rcw*(1.0f/sqrt(2.0f));
        float D = fwd + rcw*(1.0f/sqrt(2.0f));
        float ws_fr = sqrt(pow(B, 2.0f) + pow(C, 2.0f));
        float ws_fl = sqrt(pow(B, 2.0f) + pow(D, 2.0f));
        float ws_bl = sqrt(pow(A, 2.0f) + pow(D, 2.0f));
        float ws_br = sqrt(pow(A, 2.0f) + pow(C, 2.0f));
        float wa_fr = -atan2(B, C) * 180 / PI;
        float wa_fl = -atan2(B, D) * 180 / PI;
        float wa_bl = -atan2(A, D) * 180 / PI;
        float wa_br = -atan2(A, C) * 180 / PI;
        float max_ws = max(max(max(ws_fr, ws_fl), ws_bl), ws_br);
        if (max_ws > 1) {
            ws_fr /= max_ws;
            ws_fl /= max_ws;
            ws_bl /= max_ws;
            ws_br /= max_ws;
        }
        if (wa_fr < 0.0f) wa_fr += 360.0f;
        if (wa_fl < 0.0f) wa_fl += 360.0f;
        if (wa_bl < 0.0f) wa_bl += 360.0f;
        if (wa_br < 0.0f) wa_br += 360.0f;
//        if (_en && max_ws > 0.01) {
//            _en = 0;
//            wait_ms(5);
//        }
        _fr_module->drive(ws_fr, wa_fr);
        _fl_module->drive(ws_fl, wa_fl);
        _bl_module->drive(ws_bl, wa_bl);
        _br_module->drive(ws_br, wa_br);
//        if (_fr_module->is_on_target() && 
//            _fl_module->is_on_target() &&  
//            _br_module->is_on_target() && 
//            _bl_module->is_on_target() &&
//            (max_ws < 0.01)){
//            if (curr_time - _prev_time > 1000000) _en = 1;
//        } else {
//            _prev_time = curr_time;
//        }
    }
    
};

#endif