#ifndef DRIVEMOTOR_H
#define DRIVEMOTOR_H

#include "mbed.h"

class DriveMotor {
private:
    DigitalOut _dir;
    PwmOut _speed;
    float _multiplier;

public:
    DriveMotor(DigitalOut dir, PwmOut speed) : _dir(dir), _speed(speed), _multiplier(1.0f) {}
    
    void set_multiplier(float multiplier) { _multiplier = multiplier; }
    void set_speed(float speed) { _speed = speed * _multiplier; }
    void set_dir(bool dir) {_dir = dir; }
    void kill() { _speed = 0; }
    
};

#endif