//------------Face Detection--------------//
//Scale and X-axis to corresponding Servos//
//--------Incl. Bluetooth Serial----------//
//--------Andrew Holden - 04/3/21---------//
//----------For all resolutions-----------//

#include "mbed.h"
#include "stdio.h"
#include "stdlib.h"
#include "iostream"
#include "Servo.h"

using namespace std;

Serial pc(USBTX, USBRX); // TX, RX

#if   defined(TARGET_LPC1768)
Serial blue(p9, p10);          // TX, RX           
#endif

Servo myservo1(p21);
Servo myservo2(p22);

float servo = 0.0;
float svscale;               //face scale between 0-1
float svpos;                 //x-axis pos. between 0-1 
float round(float svscale)   //round to 2 dec. places

{ 
    // EXAMPLE:
    // 37.66666 * 100 =3766.66 
    // 3766.66 + .5 =3767.16    for rounding off value 
    // then type cast to int so value is 3767 
    // then divided by 100 so the value converted into 37.67 
    float value = (int)(svscale * 100 + .5); 
    return (float)value / 100; 
} 

int main()
{
    while(1) 
    {
        //blue.baud(115200);
        //pc.baud(115200);
       
        if(cin >> svscale >> svpos)
        {
            servo = svscale;
            
            if(0.00 <= svscale && svscale < 1.00)
            {
                myservo2 = servo;
            }
            else 
            {
                myservo2 = 0.5;     //home position
            }
            
            servo = svpos;
            
            if(0.00 <= svpos && svpos < 1.00)
            {
                myservo1 = servo;
            }
            else 
            {
                myservo1 = 0.5;     //home position
            }
        }
    }
}