/*******************************************************************************************
  Font name: Calibri
  Font width: varialbe (proportional font)
  Font height: 45
  Data length: 8 bits
  Data format: Big Endian, Column based, Column preferred, Unpacked

  Create time: 22:57 03-22-2011  by BitFontCreator (e-mail: support@iseatech.com)
 *******************************************************************************************/

/*******************************************************************************************
  Data table provides the bitmap data of each character.

  To get the starting data offset of character 'A', you can use the following expression:

     const unsigned char index = index_table['A'];
     const unsigned int offset = offset_table[index];
     const unsigned char *pData = data_table[offset];

 *******************************************************************************************/
#include    "font_new.h"
const unsigned char c28_data_table[] = {

/* character 0x2B ('+'): (width=18, offset=0) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x03, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xC0, 
0x00, 0x00, 0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 
0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x00, 0x00, 
0x03, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xC0, 
0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0x80, 0x00, 
0x00, 0x01, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x01, 
0xFF, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xFF, 0xFF, 
0x80, 0x00, 0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 
0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x00, 0x00, 
0x03, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xC0, 
0x00, 0x00, 0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 
0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 

/* character 0x2C (','): (width=10, offset=108) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 
0x0F, 0x80, 0x00, 0x00, 0x00, 0x03, 0xFF, 0x80, 
0x00, 0x00, 0x00, 0x03, 0xFF, 0x00, 0x00, 0x00, 
0x00, 0x03, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x03, 
0xF8, 0x00, 0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 

/* character 0x2D ('-'): (width=11, offset=168) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 
0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 
0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 
0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 
0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 
0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 
0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 

/* character 0x2E ('.'): (width=10, offset=234) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 
0xC0, 0x00, 0x00, 0x00, 0x00, 0x07, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x07, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 

/* character 0x2F ('/'): (width=16, offset=294) */
0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xFF, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0x00, 
0x00, 0x00, 0x00, 0x1F, 0xFF, 0x00, 0x00, 0x00, 
0x00, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0x00, 0x00, 
0x00, 0x00, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x07, 
0xFF, 0xE0, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0x00, 
0x00, 0x00, 0x00, 0xFF, 0xF8, 0x00, 0x00, 0x00, 
0x00, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0xFF, 
0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 
0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 

/* character 0x30 ('0'): (width=19, offset=390) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x1F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 
0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0x80, 0x00, 
0x00, 0x03, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x07, 
0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x0F, 0xC0, 0x07, 
0xE0, 0x00, 0x00, 0x0F, 0x80, 0x03, 0xE0, 0x00, 
0x00, 0x0F, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x0F, 
0x00, 0x01, 0xE0, 0x00, 0x00, 0x0F, 0x00, 0x01, 
0xE0, 0x00, 0x00, 0x0F, 0x80, 0x03, 0xE0, 0x00, 
0x00, 0x0F, 0xC0, 0x07, 0xE0, 0x00, 0x00, 0x07, 
0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x07, 0xFF, 0xFF, 
0x80, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0x80, 0x00, 
0x00, 0x01, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 
0x3F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 

/* character 0x31 ('1'): (width=19, offset=504) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x01, 0xC0, 0x01, 0xE0, 0x00, 
0x00, 0x01, 0xC0, 0x01, 0xE0, 0x00, 0x00, 0x03, 
0x80, 0x01, 0xE0, 0x00, 0x00, 0x07, 0x80, 0x01, 
0xE0, 0x00, 0x00, 0x07, 0x00, 0x01, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x01, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 

/* character 0x32 ('2'): (width=19, offset=618) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xC0, 0x01, 
0xE0, 0x00, 0x00, 0x03, 0xC0, 0x03, 0xE0, 0x00, 
0x00, 0x07, 0x80, 0x07, 0xE0, 0x00, 0x00, 0x07, 
0x80, 0x0F, 0xE0, 0x00, 0x00, 0x0F, 0x00, 0x1F, 
0xE0, 0x00, 0x00, 0x0F, 0x00, 0x3F, 0xE0, 0x00, 
0x00, 0x0F, 0x00, 0x7D, 0xE0, 0x00, 0x00, 0x0F, 
0x00, 0xF9, 0xE0, 0x00, 0x00, 0x0F, 0x01, 0xF1, 
0xE0, 0x00, 0x00, 0x0F, 0x87, 0xE1, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xC1, 0xE0, 0x00, 0x00, 0x07, 
0xFF, 0x81, 0xE0, 0x00, 0x00, 0x07, 0xFF, 0x01, 
0xE0, 0x00, 0x00, 0x03, 0xFE, 0x01, 0xE0, 0x00, 
0x00, 0x01, 0xF8, 0x01, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 

/* character 0x33 ('3'): (width=19, offset=732) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 
0xC0, 0x00, 0x00, 0x03, 0xC0, 0x03, 0xC0, 0x00, 
0x00, 0x07, 0xC7, 0x83, 0xE0, 0x00, 0x00, 0x07, 
0x87, 0x81, 0xE0, 0x00, 0x00, 0x07, 0x07, 0x81, 
0xE0, 0x00, 0x00, 0x0F, 0x07, 0x81, 0xE0, 0x00, 
0x00, 0x0F, 0x07, 0x81, 0xE0, 0x00, 0x00, 0x0F, 
0x07, 0x81, 0xE0, 0x00, 0x00, 0x0F, 0x0F, 0x81, 
0xE0, 0x00, 0x00, 0x0F, 0x8F, 0xC3, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xE3, 0xE0, 0x00, 0x00, 0x07, 
0xFD, 0xFF, 0xC0, 0x00, 0x00, 0x07, 0xFD, 0xFF, 
0xC0, 0x00, 0x00, 0x03, 0xF8, 0xFF, 0x80, 0x00, 
0x00, 0x01, 0xF0, 0xFF, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 

/* character 0x34 ('4'): (width=19, offset=846) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, 
0x00, 0x00, 0x00, 0x00, 0x07, 0xFC, 0x00, 0x00, 
0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, 0x00, 
0x7F, 0xBC, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x3C, 
0x00, 0x00, 0x00, 0x03, 0xF8, 0x3C, 0x00, 0x00, 
0x00, 0x0F, 0xE0, 0x3C, 0x00, 0x00, 0x00, 0x0F, 
0x80, 0x3C, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 

/* character 0x35 ('5'): (width=19, offset=960) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 
0xC0, 0x00, 0x00, 0x0F, 0xFF, 0x03, 0xC0, 0x00, 
0x00, 0x0F, 0xFF, 0x01, 0xE0, 0x00, 0x00, 0x0F, 
0xFF, 0x01, 0xE0, 0x00, 0x00, 0x0F, 0xFF, 0x01, 
0xE0, 0x00, 0x00, 0x0F, 0x0F, 0x01, 0xE0, 0x00, 
0x00, 0x0F, 0x0F, 0x01, 0xE0, 0x00, 0x00, 0x0F, 
0x0F, 0x01, 0xE0, 0x00, 0x00, 0x0F, 0x0F, 0x83, 
0xE0, 0x00, 0x00, 0x0F, 0x0F, 0x87, 0xE0, 0x00, 
0x00, 0x0F, 0x0F, 0xFF, 0xC0, 0x00, 0x00, 0x0F, 
0x07, 0xFF, 0xC0, 0x00, 0x00, 0x0F, 0x07, 0xFF, 
0x80, 0x00, 0x00, 0x0F, 0x03, 0xFF, 0x00, 0x00, 
0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 

/* character 0x36 ('6'): (width=19, offset=1074) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, 
0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 
0x00, 0x01, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x03, 
0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x07, 0xFF, 0xFF, 
0xC0, 0x00, 0x00, 0x07, 0xE3, 0xC7, 0xE0, 0x00, 
0x00, 0x07, 0x83, 0x81, 0xE0, 0x00, 0x00, 0x0F, 
0x87, 0x81, 0xE0, 0x00, 0x00, 0x0F, 0x07, 0x81, 
0xE0, 0x00, 0x00, 0x0F, 0x07, 0x81, 0xE0, 0x00, 
0x00, 0x0F, 0x07, 0xC3, 0xE0, 0x00, 0x00, 0x0F, 
0x07, 0xFF, 0xC0, 0x00, 0x00, 0x0F, 0x07, 0xFF, 
0xC0, 0x00, 0x00, 0x0F, 0x83, 0xFF, 0x80, 0x00, 
0x00, 0x07, 0x81, 0xFF, 0x00, 0x00, 0x00, 0x00, 
0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 

/* character 0x37 ('7'): (width=19, offset=1188) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x0F, 0x00, 0x00, 0x60, 0x00, 0x00, 0x0F, 
0x00, 0x01, 0xE0, 0x00, 0x00, 0x0F, 0x00, 0x0F, 
0xE0, 0x00, 0x00, 0x0F, 0x00, 0x3F, 0xE0, 0x00, 
0x00, 0x0F, 0x00, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 
0x03, 0xFF, 0x80, 0x00, 0x00, 0x0F, 0x1F, 0xFE, 
0x00, 0x00, 0x00, 0x0F, 0x7F, 0xF0, 0x00, 0x00, 
0x00, 0x0F, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x0F, 
0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF8, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x0F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 

/* character 0x38 ('8'): (width=19, offset=1302) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 
0x80, 0x00, 0x00, 0x03, 0xFC, 0x7F, 0xC0, 0x00, 
0x00, 0x07, 0xFE, 0xFF, 0xC0, 0x00, 0x00, 0x07, 
0xFE, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xE3, 
0xE0, 0x00, 0x00, 0x0F, 0x8F, 0xC1, 0xE0, 0x00, 
0x00, 0x0F, 0x07, 0x81, 0xE0, 0x00, 0x00, 0x0F, 
0x07, 0x81, 0xE0, 0x00, 0x00, 0x0F, 0x07, 0xC1, 
0xE0, 0x00, 0x00, 0x0F, 0x8F, 0xC1, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xE3, 0xE0, 0x00, 0x00, 0x07, 
0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x07, 0xFC, 0xFF, 
0xC0, 0x00, 0x00, 0x03, 0xF8, 0xFF, 0xC0, 0x00, 
0x00, 0x01, 0xF0, 0x7F, 0x80, 0x00, 0x00, 0x00, 
0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 

/* character 0x39 ('9'): (width=19, offset=1416) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x7E, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0x03, 
0xC0, 0x00, 0x00, 0x03, 0xFF, 0x83, 0xC0, 0x00, 
0x00, 0x07, 0xFF, 0xC1, 0xE0, 0x00, 0x00, 0x07, 
0xFF, 0xC1, 0xE0, 0x00, 0x00, 0x0F, 0x87, 0xC1, 
0xE0, 0x00, 0x00, 0x0F, 0x03, 0xC1, 0xE0, 0x00, 
0x00, 0x0F, 0x03, 0xC1, 0xE0, 0x00, 0x00, 0x0F, 
0x03, 0xC3, 0xE0, 0x00, 0x00, 0x0F, 0x03, 0x83, 
0xE0, 0x00, 0x00, 0x0F, 0xC7, 0x8F, 0xC0, 0x00, 
0x00, 0x07, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x07, 
0xFF, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xFF, 0xFF, 
0x00, 0x00, 0x00, 0x01, 0xFF, 0xFC, 0x00, 0x00, 
0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 

/* character 0x3A (':'): (width=10, offset=1530) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x1C, 0x01, 0xC0, 0x00, 
0x00, 0x00, 0x3E, 0x03, 0xE0, 0x00, 0x00, 0x00, 
0x3E, 0x03, 0xE0, 0x00, 0x00, 0x00, 0x3E, 0x03, 
0xE0, 0x00, 0x00, 0x00, 0x1C, 0x01, 0xC0, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 

/* character 0x3B (';'): (width=10, offset=1590) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x0F, 0x00, 0x00, 0x00, 0x1C, 0x03, 0xFF, 0x00, 
0x00, 0x00, 0x3E, 0x03, 0xFE, 0x00, 0x00, 0x00, 
0x3E, 0x03, 0xFC, 0x00, 0x00, 0x00, 0x3E, 0x03, 
0xF0, 0x00, 0x00, 0x00, 0x1C, 0x03, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 

/* character 0x3C ('<'): (width=18, offset=1650) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x03, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x07, 0xE0, 
0x00, 0x00, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, 
0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 
0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x78, 
0x00, 0x00, 0x00, 0x00, 0x1E, 0x78, 0x00, 0x00, 
0x00, 0x00, 0x3C, 0x3C, 0x00, 0x00, 0x00, 0x00, 
0x3C, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x78, 0x1E, 
0x00, 0x00, 0x00, 0x00, 0x78, 0x1E, 0x00, 0x00, 
0x00, 0x00, 0xF0, 0x0F, 0x00, 0x00, 0x00, 0x00, 
0xF0, 0x0F, 0x00, 0x00, 0x00, 0x01, 0xE0, 0x07, 
0x80, 0x00, 0x00, 0x01, 0xE0, 0x07, 0x80, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 

/* character 0x3D ('='): (width=18, offset=1758) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x3C, 
0x00, 0x00, 0x00, 0x00, 0x3C, 0x3C, 0x00, 0x00, 
0x00, 0x00, 0x3C, 0x3C, 0x00, 0x00, 0x00, 0x00, 
0x3C, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x3C, 
0x00, 0x00, 0x00, 0x00, 0x3C, 0x3C, 0x00, 0x00, 
0x00, 0x00, 0x3C, 0x3C, 0x00, 0x00, 0x00, 0x00, 
0x3C, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x3C, 
0x00, 0x00, 0x00, 0x00, 0x3C, 0x3C, 0x00, 0x00, 
0x00, 0x00, 0x3C, 0x3C, 0x00, 0x00, 0x00, 0x00, 
0x3C, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x3C, 
0x00, 0x00, 0x00, 0x00, 0x3C, 0x3C, 0x00, 0x00, 
0x00, 0x00, 0x3C, 0x3C, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 

/* character 0x3E ('>'): (width=18, offset=1866) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xE0, 0x07, 
0x80, 0x00, 0x00, 0x01, 0xE0, 0x07, 0x80, 0x00, 
0x00, 0x00, 0xF0, 0x0F, 0x00, 0x00, 0x00, 0x00, 
0xF0, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x78, 0x1E, 
0x00, 0x00, 0x00, 0x00, 0x78, 0x1E, 0x00, 0x00, 
0x00, 0x00, 0x3C, 0x3C, 0x00, 0x00, 0x00, 0x00, 
0x3C, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x78, 
0x00, 0x00, 0x00, 0x00, 0x1E, 0x78, 0x00, 0x00, 
0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 
0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x07, 0xE0, 
0x00, 0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, 
0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 

/* character 0x3F ('?'): (width=17, offset=1974) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 
0x07, 0xF1, 0xC0, 0x00, 0x00, 0x3C, 0x07, 0xF3, 
0xE0, 0x00, 0x00, 0x3C, 0x07, 0xF3, 0xE0, 0x00, 
0x00, 0x3C, 0x07, 0xF3, 0xE0, 0x00, 0x00, 0x3E, 
0x0F, 0xF1, 0xC0, 0x00, 0x00, 0x3F, 0x1F, 0x00, 
0x00, 0x00, 0x00, 0x1F, 0xFF, 0x00, 0x00, 0x00, 
0x00, 0x1F, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x0F, 
0xFE, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFC, 0x00, 
0x00, 0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x40 ('@'): (width=33, offset=2076) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 
0x80, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xE0, 0x00, 
0x00, 0x00, 0x1F, 0xFF, 0xF0, 0x00, 0x00, 0x00, 
0x7F, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0xFF, 0x00, 
0xFC, 0x00, 0x00, 0x01, 0xF8, 0x00, 0x7E, 0x00, 
0x00, 0x03, 0xE0, 0x00, 0x3E, 0x00, 0x00, 0x07, 
0xC0, 0xFE, 0x1E, 0x00, 0x00, 0x07, 0x83, 0xFF, 
0x1F, 0x00, 0x00, 0x0F, 0x8F, 0xFF, 0x8F, 0x00, 
0x00, 0x0F, 0x1F, 0xFF, 0x8F, 0x00, 0x00, 0x0F, 
0x1F, 0x87, 0x8F, 0x00, 0x00, 0x1E, 0x3E, 0x07, 
0x8F, 0x00, 0x00, 0x1E, 0x3C, 0x07, 0x8F, 0x00, 
0x00, 0x1E, 0x3C, 0x07, 0x0F, 0x00, 0x00, 0x1E, 
0x3C, 0x0F, 0x0F, 0x00, 0x00, 0x1E, 0x3E, 0x0E, 
0x0F, 0x00, 0x00, 0x1E, 0x1F, 0xFF, 0x0F, 0x00, 
0x00, 0x1E, 0x0F, 0xFF, 0x1F, 0x00, 0x00, 0x1E, 
0x3F, 0xFF, 0x9E, 0x00, 0x00, 0x1F, 0x3F, 0xE7, 
0x9E, 0x00, 0x00, 0x0F, 0x38, 0x07, 0x80, 0x00, 
0x00, 0x0F, 0x00, 0x07, 0x80, 0x00, 0x00, 0x0F, 
0x80, 0x0F, 0x80, 0x00, 0x00, 0x07, 0xE0, 0x3F, 
0x00, 0x00, 0x00, 0x07, 0xFF, 0xFE, 0x00, 0x00, 
0x00, 0x03, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 
0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x41 ('A'): (width=22, offset=2274) */
0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
0x00, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x0F, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xE0, 0x00, 
0x00, 0x00, 0x03, 0xFF, 0xE0, 0x00, 0x00, 0x00, 
0x1F, 0xFF, 0x80, 0x00, 0x00, 0x00, 0xFF, 0xFC, 
0x00, 0x00, 0x00, 0x07, 0xFF, 0xFC, 0x00, 0x00, 
0x00, 0x0F, 0xFE, 0x3C, 0x00, 0x00, 0x00, 0x0F, 
0xE0, 0x3C, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x3C, 
0x00, 0x00, 0x00, 0x0F, 0xE0, 0x3C, 0x00, 0x00, 
0x00, 0x0F, 0xFC, 0x3C, 0x00, 0x00, 0x00, 0x0F, 
0xFF, 0xBC, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFC, 
0x00, 0x00, 0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, 
0x00, 0x00, 0x0F, 0xFF, 0xC0, 0x00, 0x00, 0x00, 
0x03, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x7F, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x60, 0x00, 

/* character 0x42 ('B'): (width=21, offset=2406) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0x07, 0x81, 0xE0, 0x00, 0x00, 0x0F, 
0x07, 0x81, 0xE0, 0x00, 0x00, 0x0F, 0x07, 0x81, 
0xE0, 0x00, 0x00, 0x0F, 0x07, 0x81, 0xE0, 0x00, 
0x00, 0x0F, 0x07, 0x81, 0xE0, 0x00, 0x00, 0x0F, 
0x8F, 0xC1, 0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xC3, 
0xE0, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xC0, 0x00, 
0x00, 0x07, 0xFD, 0xFF, 0xC0, 0x00, 0x00, 0x03, 
0xF9, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xF0, 0xFF, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x43 ('C'): (width=20, offset=2532) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFC, 
0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 
0x00, 0x01, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x03, 
0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x07, 0xF0, 0x1F, 
0xC0, 0x00, 0x00, 0x07, 0xC0, 0x07, 0xC0, 0x00, 
0x00, 0x0F, 0x80, 0x03, 0xE0, 0x00, 0x00, 0x0F, 
0x00, 0x01, 0xE0, 0x00, 0x00, 0x0F, 0x00, 0x01, 
0xE0, 0x00, 0x00, 0x0F, 0x00, 0x01, 0xE0, 0x00, 
0x00, 0x0F, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x0F, 
0x00, 0x01, 0xE0, 0x00, 0x00, 0x0F, 0x00, 0x01, 
0xE0, 0x00, 0x00, 0x07, 0x80, 0x03, 0xC0, 0x00, 
0x00, 0x07, 0xC0, 0x07, 0xC0, 0x00, 0x00, 0x03, 
0xC0, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x44 ('D'): (width=23, offset=2652) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x0F, 
0x00, 0x01, 0xE0, 0x00, 0x00, 0x0F, 0x00, 0x01, 
0xE0, 0x00, 0x00, 0x0F, 0x00, 0x01, 0xE0, 0x00, 
0x00, 0x0F, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x0F, 
0x80, 0x03, 0xE0, 0x00, 0x00, 0x0F, 0x80, 0x03, 
0xC0, 0x00, 0x00, 0x07, 0xC0, 0x07, 0xC0, 0x00, 
0x00, 0x07, 0xF0, 0x1F, 0xC0, 0x00, 0x00, 0x03, 
0xFF, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xFF, 0xFF, 
0x80, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x00, 
0x00, 0x00, 0x7F, 0xFC, 0x00, 0x00, 0x00, 0x00, 
0x1F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 

/* character 0x45 ('E'): (width=18, offset=2790) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0x07, 0x81, 0xE0, 0x00, 0x00, 0x0F, 
0x07, 0x81, 0xE0, 0x00, 0x00, 0x0F, 0x07, 0x81, 
0xE0, 0x00, 0x00, 0x0F, 0x07, 0x81, 0xE0, 0x00, 
0x00, 0x0F, 0x07, 0x81, 0xE0, 0x00, 0x00, 0x0F, 
0x07, 0x81, 0xE0, 0x00, 0x00, 0x0F, 0x07, 0x81, 
0xE0, 0x00, 0x00, 0x0F, 0x00, 0x01, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 

/* character 0x46 ('F'): (width=17, offset=2898) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0x03, 0xC0, 0x00, 0x00, 0x00, 0x0F, 
0x03, 0xC0, 0x00, 0x00, 0x00, 0x0F, 0x03, 0xC0, 
0x00, 0x00, 0x00, 0x0F, 0x03, 0xC0, 0x00, 0x00, 
0x00, 0x0F, 0x03, 0xC0, 0x00, 0x00, 0x00, 0x0F, 
0x03, 0xC0, 0x00, 0x00, 0x00, 0x0F, 0x03, 0xC0, 
0x00, 0x00, 0x00, 0x0F, 0x01, 0x80, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x47 ('G'): (width=24, offset=3000) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFC, 
0x00, 0x00, 0x00, 0x00, 0xFF, 0xFE, 0x00, 0x00, 
0x00, 0x01, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x03, 
0xFF, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xF8, 0x1F, 
0xC0, 0x00, 0x00, 0x07, 0xE0, 0x07, 0xC0, 0x00, 
0x00, 0x07, 0xC0, 0x03, 0xC0, 0x00, 0x00, 0x0F, 
0x80, 0x03, 0xE0, 0x00, 0x00, 0x0F, 0x00, 0x01, 
0xE0, 0x00, 0x00, 0x0F, 0x03, 0xC1, 0xE0, 0x00, 
0x00, 0x0F, 0x03, 0xC1, 0xE0, 0x00, 0x00, 0x0F, 
0x03, 0xC1, 0xE0, 0x00, 0x00, 0x0F, 0x03, 0xC1, 
0xE0, 0x00, 0x00, 0x0F, 0x03, 0xC1, 0xE0, 0x00, 
0x00, 0x0F, 0x03, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 
0x83, 0xFF, 0xE0, 0x00, 0x00, 0x07, 0x83, 0xFF, 
0xC0, 0x00, 0x00, 0x07, 0xC3, 0xFF, 0xC0, 0x00, 
0x00, 0x03, 0xC3, 0xFF, 0xC0, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x48 ('H'): (width=23, offset=3144) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 
0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 
0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 
0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 
0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 
0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 

/* character 0x49 ('I'): (width=10, offset=3282) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 

/* character 0x4A ('J'): (width=12, offset=3342) */
0x00, 0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x00, 
0x00, 0x03, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x01, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xC0, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x4B ('K'): (width=20, offset=3414) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x0F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0, 
0x00, 0x00, 0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, 
0x00, 0x00, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x01, 
0xFD, 0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, 0x7F, 
0x80, 0x00, 0x00, 0x0F, 0xE0, 0x1F, 0xE0, 0x00, 
0x00, 0x0F, 0xC0, 0x0F, 0xE0, 0x00, 0x00, 0x0F, 
0x80, 0x03, 0xE0, 0x00, 0x00, 0x0E, 0x00, 0x01, 
0xE0, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x60, 0x00, 

/* character 0x4C ('L'): (width=16, offset=3534) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x01, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x01, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xE0, 0x00, 

/* character 0x4D ('M'): (width=32, offset=3630) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 
0xF8, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 
0x00, 0x00, 0x00, 0x07, 0xFF, 0xE0, 0x00, 0x00, 
0x00, 0x00, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 
0x1F, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x03, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x3F, 0xE0, 0x00, 0x00, 0x00, 0x01, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 
0x00, 0x00, 0x7F, 0xF8, 0x00, 0x00, 0x00, 0x03, 
0xFF, 0xC0, 0x00, 0x00, 0x00, 0x07, 0xFE, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, 
0x00, 0x0F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x4E ('N'): (width=24, offset=3822) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, 0x00, 
0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x07, 
0xF8, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFE, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, 
0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, 
0x07, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFE, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, 
0x00, 0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, 0x00, 
0x00, 0x03, 0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x4F ('O'): (width=25, offset=3966) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFE, 
0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 
0x00, 0x01, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x03, 
0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x07, 0xF0, 0x1F, 
0xC0, 0x00, 0x00, 0x07, 0xC0, 0x07, 0xC0, 0x00, 
0x00, 0x0F, 0x80, 0x03, 0xE0, 0x00, 0x00, 0x0F, 
0x00, 0x01, 0xE0, 0x00, 0x00, 0x0F, 0x00, 0x01, 
0xE0, 0x00, 0x00, 0x0F, 0x00, 0x01, 0xE0, 0x00, 
0x00, 0x0F, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x0F, 
0x00, 0x01, 0xE0, 0x00, 0x00, 0x0F, 0x00, 0x01, 
0xE0, 0x00, 0x00, 0x0F, 0x80, 0x03, 0xE0, 0x00, 
0x00, 0x07, 0xC0, 0x07, 0xC0, 0x00, 0x00, 0x07, 
0xF0, 0x1F, 0xC0, 0x00, 0x00, 0x07, 0xFF, 0xFF, 
0x80, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0x00, 0x00, 
0x00, 0x01, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 
0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x50 ('P'): (width=20, offset=4116) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x0F, 
0x01, 0xE0, 0x00, 0x00, 0x00, 0x0F, 0x01, 0xE0, 
0x00, 0x00, 0x00, 0x0F, 0x01, 0xE0, 0x00, 0x00, 
0x00, 0x0F, 0x03, 0xE0, 0x00, 0x00, 0x00, 0x0F, 
0x87, 0xE0, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xC0, 
0x00, 0x00, 0x00, 0x07, 0xFF, 0xC0, 0x00, 0x00, 
0x00, 0x03, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x01, 
0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x51 ('Q'): (width=26, offset=4236) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x1F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFE, 
0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 
0x00, 0x03, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x03, 
0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x07, 0xF0, 0x1F, 
0xC0, 0x00, 0x00, 0x07, 0xC0, 0x07, 0xC0, 0x00, 
0x00, 0x0F, 0x80, 0x03, 0xE0, 0x00, 0x00, 0x0F, 
0x00, 0x01, 0xE0, 0x00, 0x00, 0x0F, 0x00, 0x01, 
0xE0, 0x00, 0x00, 0x0F, 0x00, 0x01, 0xE0, 0x00, 
0x00, 0x0F, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x0F, 
0x00, 0x01, 0xE0, 0x00, 0x00, 0x0F, 0x00, 0x01, 
0xE0, 0x00, 0x00, 0x0F, 0x80, 0x03, 0xC0, 0x00, 
0x00, 0x07, 0xC0, 0x07, 0xC0, 0x00, 0x00, 0x07, 
0xF0, 0x1F, 0xE0, 0x00, 0x00, 0x07, 0xFF, 0xFF, 
0xF0, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xF8, 0x00, 
0x00, 0x01, 0xFF, 0xFE, 0x7C, 0x00, 0x00, 0x00, 
0xFF, 0xFC, 0x7C, 0x00, 0x00, 0x00, 0x1F, 0xE0, 
0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 

/* character 0x52 ('R'): (width=21, offset=4392) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0x03, 0xC0, 0x00, 0x00, 0x00, 0x0F, 
0x03, 0xC0, 0x00, 0x00, 0x00, 0x0F, 0x03, 0xC0, 
0x00, 0x00, 0x00, 0x0F, 0x03, 0xE0, 0x00, 0x00, 
0x00, 0x0F, 0x03, 0xF0, 0x00, 0x00, 0x00, 0x0F, 
0x87, 0xFC, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0x80, 0x00, 0x00, 0x07, 0xFF, 0x7F, 0xE0, 0x00, 
0x00, 0x07, 0xFF, 0x3F, 0xE0, 0x00, 0x00, 0x03, 
0xFE, 0x0F, 0xE0, 0x00, 0x00, 0x00, 0xF8, 0x03, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x53 ('S'): (width=17, offset=4518) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xF8, 0x07, 0x80, 0x00, 0x00, 0x03, 0xFC, 0x07, 
0xC0, 0x00, 0x00, 0x03, 0xFE, 0x03, 0xC0, 0x00, 
0x00, 0x07, 0xFF, 0x03, 0xE0, 0x00, 0x00, 0x07, 
0xFF, 0x01, 0xE0, 0x00, 0x00, 0x0F, 0x9F, 0x81, 
0xE0, 0x00, 0x00, 0x0F, 0x0F, 0x81, 0xE0, 0x00, 
0x00, 0x0F, 0x07, 0xC1, 0xE0, 0x00, 0x00, 0x0F, 
0x07, 0xC1, 0xE0, 0x00, 0x00, 0x0F, 0x07, 0xE3, 
0xE0, 0x00, 0x00, 0x0F, 0x03, 0xFF, 0xC0, 0x00, 
0x00, 0x0F, 0x03, 0xFF, 0xC0, 0x00, 0x00, 0x07, 
0x81, 0xFF, 0x80, 0x00, 0x00, 0x07, 0x80, 0xFF, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x54 ('T'): (width=18, offset=4620) */
0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 
0x00, 0x00, 0x00, 0x00, 

/* character 0x55 ('U'): (width=24, offset=4728) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFC, 0x00, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0x80, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0xC0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xC0, 0x00, 
0x00, 0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, 0x00, 
0x00, 0x03, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x01, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x01, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, 0x0F, 
0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
0x80, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x80, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x0F, 
0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x56 ('V'): (width=22, offset=4872) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, 
0x00, 0x0F, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x0F, 
0xFF, 0xC0, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xF8, 
0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 
0x00, 0x00, 0x0F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 
0x01, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x1F, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, 0x00, 
0x01, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x0F, 0xFF, 
0xC0, 0x00, 0x00, 0x00, 0xFF, 0xFE, 0x00, 0x00, 
0x00, 0x07, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 
0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0xFE, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, 
0x00, 0x0F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0C, 
0x00, 0x00, 0x00, 0x00, 

/* character 0x57 ('W'): (width=34, offset=5004) */
0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 
0xC0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF8, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xFF, 0x80, 0x00, 0x00, 
0x00, 0x0F, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x07, 
0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x03, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x1F, 
0xE0, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xE0, 0x00, 
0x00, 0x00, 0x1F, 0xFF, 0xC0, 0x00, 0x00, 0x01, 
0xFF, 0xFE, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xE0, 
0x00, 0x00, 0x00, 0x0F, 0xFE, 0x00, 0x00, 0x00, 
0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x0F, 
0xFE, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xE0, 
0x00, 0x00, 0x00, 0x03, 0xFF, 0xFE, 0x00, 0x00, 
0x00, 0x00, 0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 
0x03, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x3F, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00, 0x00, 
0x03, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x7F, 0xFF, 
0xC0, 0x00, 0x00, 0x07, 0xFF, 0xFE, 0x00, 0x00, 
0x00, 0x0F, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 
0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF8, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, 0x00, 
0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 

/* character 0x58 ('X'): (width=20, offset=5208) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x60, 0x00, 0x00, 0x0E, 0x00, 0x01, 
0xE0, 0x00, 0x00, 0x0F, 0x80, 0x03, 0xE0, 0x00, 
0x00, 0x0F, 0xC0, 0x0F, 0xE0, 0x00, 0x00, 0x0F, 
0xF0, 0x3F, 0xE0, 0x00, 0x00, 0x0F, 0xFC, 0xFF, 
0xC0, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0x00, 0x00, 
0x00, 0x00, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 
0x3F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xC0, 
0x00, 0x00, 0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, 
0x00, 0x00, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x03, 
0xFF, 0xFF, 0x00, 0x00, 0x00, 0x0F, 0xFC, 0xFF, 
0xC0, 0x00, 0x00, 0x0F, 0xF0, 0x3F, 0xE0, 0x00, 
0x00, 0x0F, 0xC0, 0x0F, 0xE0, 0x00, 0x00, 0x0F, 
0x80, 0x03, 0xE0, 0x00, 0x00, 0x0E, 0x00, 0x01, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 

/* character 0x59 ('Y'): (width=19, offset=5328) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x0F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x0F, 
0xFE, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0x80, 
0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x00, 0x1F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 
0x03, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x1F, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xE0, 0x00, 
0x00, 0x03, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 
0xFE, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF8, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x0F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0E, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 

/* character 0x5A ('Z'): (width=18, offset=5442) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 
0x00, 0x01, 0xE0, 0x00, 0x00, 0x0F, 0x00, 0x07, 
0xE0, 0x00, 0x00, 0x0F, 0x00, 0x1F, 0xE0, 0x00, 
0x00, 0x0F, 0x00, 0x3F, 0xE0, 0x00, 0x00, 0x0F, 
0x00, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 0x01, 0xFD, 
0xE0, 0x00, 0x00, 0x0F, 0x07, 0xF9, 0xE0, 0x00, 
0x00, 0x0F, 0x0F, 0xE1, 0xE0, 0x00, 0x00, 0x0F, 
0x3F, 0xC1, 0xE0, 0x00, 0x00, 0x0F, 0x7F, 0x01, 
0xE0, 0x00, 0x00, 0x0F, 0xFE, 0x01, 0xE0, 0x00, 
0x00, 0x0F, 0xF8, 0x01, 0xE0, 0x00, 0x00, 0x0F, 
0xF0, 0x01, 0xE0, 0x00, 0x00, 0x0F, 0xC0, 0x01, 
0xE0, 0x00, 0x00, 0x0F, 0x80, 0x01, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 

/* character 0x5B ('['): (width=12, offset=5550) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x80, 
0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x7F, 
0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x7F, 0xFF, 0xFF, 
0xFF, 0x80, 0x00, 0x78, 0x00, 0x00, 0x07, 0x80, 
0x00, 0x78, 0x00, 0x00, 0x07, 0x80, 0x00, 0x78, 
0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x5C ('\'): (width=16, offset=5622) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 
0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 
0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 
0x00, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0xFF, 
0xFC, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0x00, 
0x00, 0x00, 0x00, 0x07, 0xFF, 0xE0, 0x00, 0x00, 
0x00, 0x01, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 
0x3F, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFC, 0x00, 
0x00, 0x00, 0x00, 0x3F, 0xFF, 0x00, 0x00, 0x00, 
0x00, 0x07, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 

/* character 0x5D (']'): (width=12, offset=5718) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 
0x07, 0x80, 0x00, 0x78, 0x00, 0x00, 0x07, 0x80, 
0x00, 0x78, 0x00, 0x00, 0x07, 0x80, 0x00, 0x7F, 
0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x7F, 0xFF, 0xFF, 
0xFF, 0x80, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x80, 
0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x5E ('^'): (width=18, offset=5790) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xC0, 
0x00, 0x00, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, 
0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, 0x01, 
0xFF, 0xC0, 0x00, 0x00, 0x00, 0x07, 0xFF, 0x80, 
0x00, 0x00, 0x00, 0x0F, 0xFC, 0x00, 0x00, 0x00, 
0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x0F, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0xFC, 0x00, 0x00, 0x00, 
0x00, 0x07, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x01, 
0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 
0x00, 0x00, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, 
0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x00, 0x00, 
0x00, 0xC0, 0x00, 0x00, 

/* character 0x5F ('_'): (width=21, offset=5898) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 
0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 
0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 
0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 
0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 
0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 
0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 
0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 
0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 
0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 
0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 
0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 
0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 
0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x60 ('`'): (width=11, offset=6024) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 

/* character 0x61 ('a'): (width=18, offset=6090) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x1F, 
0xC0, 0x00, 0x00, 0x00, 0x1E, 0x3F, 0xC0, 0x00, 
0x00, 0x00, 0x3E, 0x3F, 0xE0, 0x00, 0x00, 0x00, 
0x3C, 0x7F, 0xE0, 0x00, 0x00, 0x00, 0x3C, 0x79, 
0xE0, 0x00, 0x00, 0x00, 0x3C, 0x71, 0xE0, 0x00, 
0x00, 0x00, 0x3C, 0x71, 0xE0, 0x00, 0x00, 0x00, 
0x3C, 0x71, 0xE0, 0x00, 0x00, 0x00, 0x3E, 0x73, 
0xC0, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0x80, 0x00, 
0x00, 0x00, 0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 
0x1F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x0F, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 

/* character 0x62 ('b'): (width=20, offset=6198) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x3F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x3F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 
0x80, 0x00, 0x00, 0x00, 0x0E, 0x03, 0xC0, 0x00, 
0x00, 0x00, 0x1E, 0x03, 0xC0, 0x00, 0x00, 0x00, 
0x3C, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x3C, 0x01, 
0xE0, 0x00, 0x00, 0x00, 0x3C, 0x01, 0xE0, 0x00, 
0x00, 0x00, 0x3F, 0x07, 0xE0, 0x00, 0x00, 0x00, 
0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x1F, 0xFF, 
0xC0, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0x80, 0x00, 
0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00, 
0x01, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x63 ('c'): (width=15, offset=6318) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x01, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0x80, 0x00, 
0x00, 0x00, 0x1F, 0xFF, 0xC0, 0x00, 0x00, 0x00, 
0x1F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x3F, 0x07, 
0xE0, 0x00, 0x00, 0x00, 0x3E, 0x03, 0xE0, 0x00, 
0x00, 0x00, 0x3C, 0x01, 0xE0, 0x00, 0x00, 0x00, 
0x3C, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x3C, 0x01, 
0xE0, 0x00, 0x00, 0x00, 0x3E, 0x03, 0xC0, 0x00, 
0x00, 0x00, 0x1E, 0x03, 0xC0, 0x00, 0x00, 0x00, 
0x0F, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 

/* character 0x64 ('d'): (width=20, offset=6408) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x01, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0x80, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xC0, 0x00, 
0x00, 0x00, 0x1F, 0xFF, 0xC0, 0x00, 0x00, 0x00, 
0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x3F, 0x07, 
0xE0, 0x00, 0x00, 0x00, 0x3C, 0x01, 0xE0, 0x00, 
0x00, 0x00, 0x3C, 0x01, 0xE0, 0x00, 0x00, 0x00, 
0x3C, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x1E, 0x03, 
0xC0, 0x00, 0x00, 0x00, 0x0E, 0x03, 0x80, 0x00, 
0x00, 0x3F, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x3F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x3F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x65 ('e'): (width=19, offset=6528) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x01, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0x80, 0x00, 
0x00, 0x00, 0x1F, 0xFF, 0xC0, 0x00, 0x00, 0x00, 
0x1F, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x3E, 0x73, 
0xE0, 0x00, 0x00, 0x00, 0x3C, 0x71, 0xE0, 0x00, 
0x00, 0x00, 0x3C, 0x71, 0xE0, 0x00, 0x00, 0x00, 
0x3C, 0x71, 0xE0, 0x00, 0x00, 0x00, 0x3C, 0x71, 
0xE0, 0x00, 0x00, 0x00, 0x3E, 0x71, 0xE0, 0x00, 
0x00, 0x00, 0x3F, 0xF1, 0xE0, 0x00, 0x00, 0x00, 
0x1F, 0xF1, 0xE0, 0x00, 0x00, 0x00, 0x0F, 0xF3, 
0xC0, 0x00, 0x00, 0x00, 0x07, 0xF3, 0xC0, 0x00, 
0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 

/* character 0x66 ('f'): (width=13, offset=6642) */
0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 
0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x1F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x3C, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x3C, 
0x3C, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x3C, 0x00, 
0x00, 0x00, 0x00, 0x1C, 0x3C, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x67 ('g'): (width=18, offset=6720) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x07, 0x3E, 0x00, 0x00, 0x00, 0x0F, 0xFF, 
0xFF, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0x00, 
0x00, 0x00, 0x1F, 0xFF, 0xFF, 0x80, 0x00, 0x00, 
0x3F, 0xF9, 0xF3, 0x80, 0x00, 0x00, 0x38, 0x39, 
0xE3, 0x80, 0x00, 0x00, 0x38, 0x39, 0xE3, 0x80, 
0x00, 0x00, 0x38, 0x39, 0xE3, 0x80, 0x00, 0x00, 
0x38, 0x39, 0xE3, 0x80, 0x00, 0x00, 0x3C, 0x79, 
0xE3, 0x80, 0x00, 0x00, 0x3F, 0xF1, 0xE7, 0x80, 
0x00, 0x00, 0x3F, 0xF1, 0xFF, 0x00, 0x00, 0x00, 
0x3F, 0xE0, 0xFF, 0x00, 0x00, 0x00, 0x3F, 0xC0, 
0xFE, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x7E, 0x00, 
0x00, 0x00, 0x3C, 0x00, 0x10, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 

/* character 0x68 ('h'): (width=20, offset=6828) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x3F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x3F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 
0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x1F, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xE0, 0x00, 
0x00, 0x00, 0x07, 0xFF, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x69 ('i'): (width=9, offset=6948) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x3F, 0xFF, 
0xE0, 0x00, 0x00, 0x1F, 0x3F, 0xFF, 0xE0, 0x00, 
0x00, 0x1F, 0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x1F, 
0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x0E, 0x3F, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x6A ('j'): (width=11, offset=7002) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 
0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 
0x00, 0x0E, 0x3F, 0xFF, 0xFF, 0x80, 0x00, 0x1F, 
0x3F, 0xFF, 0xFF, 0x80, 0x00, 0x1F, 0x3F, 0xFF, 
0xFF, 0x00, 0x00, 0x1F, 0x3F, 0xFF, 0xFF, 0x00, 
0x00, 0x0E, 0x3F, 0xFF, 0xFC, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 

/* character 0x6B ('k'): (width=18, offset=7068) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x3F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x3F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, 
0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, 0x00, 0x00, 
0x07, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 
0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0x80, 0x00, 
0x00, 0x00, 0x3F, 0x3F, 0xE0, 0x00, 0x00, 0x00, 
0x3E, 0x0F, 0xE0, 0x00, 0x00, 0x00, 0x38, 0x07, 
0xE0, 0x00, 0x00, 0x00, 0x30, 0x01, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 

/* character 0x6C ('l'): (width=9, offset=7176) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x3F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x3F, 
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x6D ('m'): (width=30, offset=7230) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xE0, 0x00, 
0x00, 0x00, 0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 
0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x0F, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x3F, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xE0, 0x00, 
0x00, 0x00, 0x0F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 
0x0F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x1F, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xE0, 0x00, 
0x00, 0x00, 0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 
0x1F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x0F, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 

/* character 0x6E ('n'): (width=20, offset=7410) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xE0, 0x00, 
0x00, 0x00, 0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 
0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x0F, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 
0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x1F, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xE0, 0x00, 
0x00, 0x00, 0x07, 0xFF, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x6F ('o'): (width=20, offset=7530) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x01, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0x80, 0x00, 
0x00, 0x00, 0x1F, 0xFF, 0xC0, 0x00, 0x00, 0x00, 
0x1F, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x3F, 0x07, 
0xE0, 0x00, 0x00, 0x00, 0x3E, 0x03, 0xE0, 0x00, 
0x00, 0x00, 0x3C, 0x01, 0xE0, 0x00, 0x00, 0x00, 
0x3C, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x3C, 0x01, 
0xE0, 0x00, 0x00, 0x00, 0x3E, 0x03, 0xE0, 0x00, 
0x00, 0x00, 0x3F, 0x07, 0xE0, 0x00, 0x00, 0x00, 
0x1F, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x1F, 0xFF, 
0xC0, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0x80, 0x00, 
0x00, 0x00, 0x07, 0xFF, 0x00, 0x00, 0x00, 0x00, 
0x01, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x70 ('p'): (width=20, offset=7650) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 
0xFF, 0x80, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0x80, 
0x00, 0x00, 0x3F, 0xFF, 0xFF, 0x80, 0x00, 0x00, 
0x3F, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x0F, 0xFF, 
0xFF, 0x80, 0x00, 0x00, 0x0E, 0x03, 0x80, 0x00, 
0x00, 0x00, 0x1E, 0x03, 0xC0, 0x00, 0x00, 0x00, 
0x3C, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x3C, 0x01, 
0xE0, 0x00, 0x00, 0x00, 0x3C, 0x01, 0xE0, 0x00, 
0x00, 0x00, 0x3F, 0x07, 0xE0, 0x00, 0x00, 0x00, 
0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x1F, 0xFF, 
0xC0, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xC0, 0x00, 
0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00, 
0x03, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x71 ('q'): (width=20, offset=7770) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x01, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 
0x80, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xC0, 0x00, 
0x00, 0x00, 0x1F, 0xFF, 0xC0, 0x00, 0x00, 0x00, 
0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x3F, 0x07, 
0xE0, 0x00, 0x00, 0x00, 0x3C, 0x01, 0xE0, 0x00, 
0x00, 0x00, 0x3C, 0x01, 0xE0, 0x00, 0x00, 0x00, 
0x3C, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x1E, 0x03, 
0xC0, 0x00, 0x00, 0x00, 0x1E, 0x03, 0x80, 0x00, 
0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x80, 0x00, 0x00, 
0x3F, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0xFF, 
0xFF, 0x80, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0x80, 
0x00, 0x00, 0x3F, 0xFF, 0xFF, 0x80, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x72 ('r'): (width=13, offset=7890) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xE0, 0x00, 
0x00, 0x00, 0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 
0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x0F, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x73 ('s'): (width=15, offset=7968) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x07, 0x83, 0xC0, 0x00, 0x00, 0x00, 0x0F, 0xC3, 
0xE0, 0x00, 0x00, 0x00, 0x1F, 0xE1, 0xE0, 0x00, 
0x00, 0x00, 0x3F, 0xF1, 0xE0, 0x00, 0x00, 0x00, 
0x3C, 0xF1, 0xE0, 0x00, 0x00, 0x00, 0x3C, 0xF1, 
0xE0, 0x00, 0x00, 0x00, 0x3C, 0x79, 0xE0, 0x00, 
0x00, 0x00, 0x3C, 0x7F, 0xE0, 0x00, 0x00, 0x00, 
0x3C, 0x7F, 0xC0, 0x00, 0x00, 0x00, 0x3E, 0x3F, 
0xC0, 0x00, 0x00, 0x00, 0x1E, 0x3F, 0x80, 0x00, 
0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 

/* character 0x74 ('t'): (width=13, offset=8058) */
0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 
0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0x80, 0x00, 
0x00, 0x03, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x03, 
0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x03, 0xFF, 0xFF, 
0xE0, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xE0, 0x00, 
0x00, 0x00, 0x3C, 0x01, 0xE0, 0x00, 0x00, 0x00, 
0x3C, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x3C, 0x01, 
0xE0, 0x00, 0x00, 0x00, 0x3C, 0x01, 0xC0, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x75 ('u'): (width=20, offset=8136) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 
0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0x80, 0x00, 
0x00, 0x00, 0x3F, 0xFF, 0xC0, 0x00, 0x00, 0x00, 
0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x3F, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x01, 
0xC0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xC0, 0x00, 
0x00, 0x00, 0x3F, 0xFF, 0x80, 0x00, 0x00, 0x00, 
0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x3F, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xE0, 0x00, 
0x00, 0x00, 0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x76 ('v'): (width=18, offset=8256) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x80, 
0x00, 0x00, 0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, 
0x00, 0x00, 0x3F, 0xFF, 0x00, 0x00, 0x00, 0x00, 
0x1F, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x01, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x1F, 0xE0, 0x00, 0x00, 0x00, 0x01, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xC0, 0x00, 
0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x00, 0x00, 
0x3F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x80, 
0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 

/* character 0x77 ('w'): (width=28, offset=8364) */
0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 
0x00, 0x00, 0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, 
0x00, 0x00, 0x3F, 0xFF, 0x80, 0x00, 0x00, 0x00, 
0x1F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x01, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x3F, 0xE0, 0x00, 0x00, 0x00, 0x03, 0xFF, 
0xE0, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0x00, 0x00, 
0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, 0x00, 0x00, 
0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xF0, 
0x00, 0x00, 0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 
0x00, 0x00, 0x0F, 0xFF, 0xC0, 0x00, 0x00, 0x00, 
0x00, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x1F, 
0xE0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00, 0x00, 
0x01, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x1F, 0xFF, 
0xC0, 0x00, 0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 
0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00, 0x00, 0x00, 
0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 

/* character 0x78 ('x'): (width=17, offset=8532) */
0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
0x30, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x3C, 0x01, 
0xE0, 0x00, 0x00, 0x00, 0x3E, 0x07, 0xE0, 0x00, 
0x00, 0x00, 0x3F, 0x8F, 0xE0, 0x00, 0x00, 0x00, 
0x3F, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x1F, 0xFF, 
0x80, 0x00, 0x00, 0x00, 0x07, 0xFE, 0x00, 0x00, 
0x00, 0x00, 0x03, 0xF8, 0x00, 0x00, 0x00, 0x00, 
0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 
0x80, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xC0, 0x00, 
0x00, 0x00, 0x3F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 
0x3F, 0x0F, 0xE0, 0x00, 0x00, 0x00, 0x3C, 0x03, 
0xE0, 0x00, 0x00, 0x00, 0x30, 0x00, 0xE0, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 

/* character 0x79 ('y'): (width=18, offset=8634) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, 
0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, 0x00, 0x00, 
0x3F, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 
0xC3, 0x80, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0x80, 
0x00, 0x00, 0x00, 0x3F, 0xFF, 0x80, 0x00, 0x00, 
0x00, 0x03, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x3F, 
0xFF, 0x80, 0x00, 0x00, 0x03, 0xFF, 0xFC, 0x00, 
0x00, 0x00, 0x1F, 0xFF, 0xC0, 0x00, 0x00, 0x00, 
0x3F, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xF0, 
0x00, 0x00, 0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, 
0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x30, 0x00, 0x00, 0x00, 

/* character 0x7A ('z'): (width=15, offset=8742) */
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x3C, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x3C, 0x07, 
0xE0, 0x00, 0x00, 0x00, 0x3C, 0x0F, 0xE0, 0x00, 
0x00, 0x00, 0x3C, 0x1F, 0xE0, 0x00, 0x00, 0x00, 
0x3C, 0x7F, 0xE0, 0x00, 0x00, 0x00, 0x3C, 0xFD, 
0xE0, 0x00, 0x00, 0x00, 0x3D, 0xF9, 0xE0, 0x00, 
0x00, 0x00, 0x3F, 0xF1, 0xE0, 0x00, 0x00, 0x00, 
0x3F, 0xC1, 0xE0, 0x00, 0x00, 0x00, 0x3F, 0x81, 
0xE0, 0x00, 0x00, 0x00, 0x3F, 0x01, 0xE0, 0x00, 
0x00, 0x00, 0x3C, 0x01, 0xE0, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 

};

/*******************************************************************************************
  Offset table provides the starting offset of each character in the data table.

  To get the starting offset of character 'A', you can use the following expression:

     const unsigned char index = index_table['A'];
     const unsigned int offset = offset_table[index]

 *******************************************************************************************/
const unsigned int c28_offset_table[] = {
/*        offset    char    hexcode */
/*        ======    ====    ======= */
               0, /*   +      2B      */
             108, /*   ,      2C      */
             168, /*   -      2D      */
             234, /*   .      2E      */
             294, /*   /      2F      */
             390, /*   0      30      */
             504, /*   1      31      */
             618, /*   2      32      */
             732, /*   3      33      */
             846, /*   4      34      */
             960, /*   5      35      */
            1074, /*   6      36      */
            1188, /*   7      37      */
            1302, /*   8      38      */
            1416, /*   9      39      */
            1530, /*   :      3A      */
            1590, /*   ;      3B      */
            1650, /*   <      3C      */
            1758, /*   =      3D      */
            1866, /*   >      3E      */
            1974, /*   ?      3F      */
            2076, /*   @      40      */
            2274, /*   A      41      */
            2406, /*   B      42      */
            2532, /*   C      43      */
            2652, /*   D      44      */
            2790, /*   E      45      */
            2898, /*   F      46      */
            3000, /*   G      47      */
            3144, /*   H      48      */
            3282, /*   I      49      */
            3342, /*   J      4A      */
            3414, /*   K      4B      */
            3534, /*   L      4C      */
            3630, /*   M      4D      */
            3822, /*   N      4E      */
            3966, /*   O      4F      */
            4116, /*   P      50      */
            4236, /*   Q      51      */
            4392, /*   R      52      */
            4518, /*   S      53      */
            4620, /*   T      54      */
            4728, /*   U      55      */
            4872, /*   V      56      */
            5004, /*   W      57      */
            5208, /*   X      58      */
            5328, /*   Y      59      */
            5442, /*   Z      5A      */
            5550, /*   [      5B      */
            5622, /*   \      5C      */
            5718, /*   ]      5D      */
            5790, /*   ^      5E      */
            5898, /*   _      5F      */
            6024, /*   `      60      */
            6090, /*   a      61      */
            6198, /*   b      62      */
            6318, /*   c      63      */
            6408, /*   d      64      */
            6528, /*   e      65      */
            6642, /*   f      66      */
            6720, /*   g      67      */
            6828, /*   h      68      */
            6948, /*   i      69      */
            7002, /*   j      6A      */
            7068, /*   k      6B      */
            7176, /*   l      6C      */
            7230, /*   m      6D      */
            7410, /*   n      6E      */
            7530, /*   o      6F      */
            7650, /*   p      70      */
            7770, /*   q      71      */
            7890, /*   r      72      */
            7968, /*   s      73      */
            8058, /*   t      74      */
            8136, /*   u      75      */
            8256, /*   v      76      */
            8364, /*   w      77      */
            8532, /*   x      78      */
            8634, /*   y      79      */
            8742, /*   z      7A      */
};

/*******************************************************************************************
  Index table is used to find the mapping index of a character.

  If you can find a simple mathematical expression for index mapping, you can use that.
  If you do not have such a mathematical expression, this index table is just for you.

  To get the index of character 'A', you can use the following expression:

     const unsigned char index = index_table['A'];

 *******************************************************************************************/
const unsigned char c28_index_table[] = {
/*        index   hexcode   decimal  char */
/*        =====   =======   =======  ==== */
            0, /*   00          0     .   */
            0, /*   01          1     .   */
            0, /*   02          2     .   */
            0, /*   03          3     .   */
            0, /*   04          4     .   */
            0, /*   05          5     .   */
            0, /*   06          6     .   */
            0, /*   07          7     .   */
            0, /*   08          8     .   */
            0, /*   09          9     .   */
            0, /*   0A         10     .   */
            0, /*   0B         11     .   */
            0, /*   0C         12     .   */
            0, /*   0D         13     .   */
            0, /*   0E         14     .   */
            0, /*   0F         15     .   */
            0, /*   10         16     .   */
            0, /*   11         17     .   */
            0, /*   12         18     .   */
            0, /*   13         19     .   */
            0, /*   14         20     .   */
            0, /*   15         21     .   */
            0, /*   16         22     .   */
            0, /*   17         23     .   */
            0, /*   18         24     .   */
            0, /*   19         25     .   */
            0, /*   1A         26     .   */
            0, /*   1B         27     .   */
            0, /*   1C         28     .   */
            0, /*   1D         29     .   */
            0, /*   1E         30     .   */
            0, /*   1F         31     .   */
            0, /*   20         32         */
            0, /*   21         33     !   */
            0, /*   22         34     "   */
            0, /*   23         35     #   */
            0, /*   24         36     $   */
            0, /*   25         37     %   */
            0, /*   26         38     &   */
            0, /*   27         39     '   */
            0, /*   28         40     (   */
            0, /*   29         41     )   */
            0, /*   2A         42     *   */
            0, /*   2B         43     +   */
            1, /*   2C         44     ,   */
            2, /*   2D         45     -   */
            3, /*   2E         46     .   */
            4, /*   2F         47     /   */
            5, /*   30         48     0   */
            6, /*   31         49     1   */
            7, /*   32         50     2   */
            8, /*   33         51     3   */
            9, /*   34         52     4   */
           10, /*   35         53     5   */
           11, /*   36         54     6   */
           12, /*   37         55     7   */
           13, /*   38         56     8   */
           14, /*   39         57     9   */
           15, /*   3A         58     :   */
           16, /*   3B         59     ;   */
           17, /*   3C         60     <   */
           18, /*   3D         61     =   */
           19, /*   3E         62     >   */
           20, /*   3F         63     ?   */
           21, /*   40         64     @   */
           22, /*   41         65     A   */
           23, /*   42         66     B   */
           24, /*   43         67     C   */
           25, /*   44         68     D   */
           26, /*   45         69     E   */
           27, /*   46         70     F   */
           28, /*   47         71     G   */
           29, /*   48         72     H   */
           30, /*   49         73     I   */
           31, /*   4A         74     J   */
           32, /*   4B         75     K   */
           33, /*   4C         76     L   */
           34, /*   4D         77     M   */
           35, /*   4E         78     N   */
           36, /*   4F         79     O   */
           37, /*   50         80     P   */
           38, /*   51         81     Q   */
           39, /*   52         82     R   */
           40, /*   53         83     S   */
           41, /*   54         84     T   */
           42, /*   55         85     U   */
           43, /*   56         86     V   */
           44, /*   57         87     W   */
           45, /*   58         88     X   */
           46, /*   59         89     Y   */
           47, /*   5A         90     Z   */
           48, /*   5B         91     [   */
           49, /*   5C         92     \   */
           50, /*   5D         93     ]   */
           51, /*   5E         94     ^   */
           52, /*   5F         95     _   */
           53, /*   60         96     `   */
           54, /*   61         97     a   */
           55, /*   62         98     b   */
           56, /*   63         99     c   */
           57, /*   64        100     d   */
           58, /*   65        101     e   */
           59, /*   66        102     f   */
           60, /*   67        103     g   */
           61, /*   68        104     h   */
           62, /*   69        105     i   */
           63, /*   6A        106     j   */
           64, /*   6B        107     k   */
           65, /*   6C        108     l   */
           66, /*   6D        109     m   */
           67, /*   6E        110     n   */
           68, /*   6F        111     o   */
           69, /*   70        112     p   */
           70, /*   71        113     q   */
           71, /*   72        114     r   */
           72, /*   73        115     s   */
           73, /*   74        116     t   */
           74, /*   75        117     u   */
           75, /*   76        118     v   */
           76, /*   77        119     w   */
           77, /*   78        120     x   */
           78, /*   79        121     y   */
           79, /*   7A        122     z   */
            0, /*   7B        123   { */
            0, /*   7C        124   | */
            0, /*   7D        125   } */
            0, /*   7E        126   ~ */
            0, /*   7F        127    */
            0, /*   80        128   ? */
            0, /*   81        129   &#65533; */
            0, /*   82        130   ? */
            0, /*   83        131   ? */
            0, /*   84        132   ? */
            0, /*   85        133   ? */
            0, /*   86        134   ? */
            0, /*   87        135   ? */
            0, /*   88        136   ? */
            0, /*   89        137   ? */
            0, /*   8A        138   ? */
            0, /*   8B        139   ? */
            0, /*   8C        140   ? */
            0, /*   8D        141   &#65533; */
            0, /*   8E        142   ? */
            0, /*   8F        143   &#65533; */
            0, /*   90        144   &#65533; */
            0, /*   91        145   ? */
            0, /*   92        146   ? */
            0, /*   93        147   ? */
            0, /*   94        148   ? */
            0, /*   95        149   ? */
            0, /*   96        150   ? */
            0, /*   97        151   ? */
            0, /*   98        152   ? */
            0, /*   99        153   ? */
            0, /*   9A        154   ? */
            0, /*   9B        155   ? */
            0, /*   9C        156   ? */
            0, /*   9D        157   &#65533; */
            0, /*   9E        158   ? */
            0, /*   9F        159   ? */
            0, /*   A0        160   &#65533; */
            0, /*   A1        161   &#65533; */
            0, /*   A2        162   &#65533; */
            0, /*   A3        163   &#65533; */
            0, /*   A4        164   &#65533; */
            0, /*   A5        165   &#65533; */
            0, /*   A6        166   &#65533; */
            0, /*   A7        167   &#65533; */
            0, /*   A8        168   &#65533; */
            0, /*   A9        169   &#65533; */
            0, /*   AA        170   &#65533; */
            0, /*   AB        171   &#65533; */
            0, /*   AC        172   &#65533; */
            0, /*   AD        173   &#65533; */
            0, /*   AE        174   &#65533; */
            0, /*   AF        175   &#65533; */
            0, /*   B0        176   &#65533; */
            0, /*   B1        177   &#65533; */
            0, /*   B2        178   &#65533; */
            0, /*   B3        179   &#65533; */
            0, /*   B4        180   &#65533; */
            0, /*   B5        181   &#65533; */
            0, /*   B6        182   &#65533; */
            0, /*   B7        183   &#65533; */
            0, /*   B8        184   &#65533; */
            0, /*   B9        185   &#65533; */
            0, /*   BA        186   &#65533; */
            0, /*   BB        187   &#65533; */
            0, /*   BC        188   &#65533; */
            0, /*   BD        189   &#65533; */
            0, /*   BE        190   &#65533; */
            0, /*   BF        191   &#65533; */
            0, /*   C0        192   &#65533; */
            0, /*   C1        193   &#65533; */
            0, /*   C2        194   &#65533; */
            0, /*   C3        195   &#65533; */
            0, /*   C4        196   &#65533; */
            0, /*   C5        197   &#65533; */
            0, /*   C6        198   &#65533; */
            0, /*   C7        199   &#65533; */
            0, /*   C8        200   &#65533; */
            0, /*   C9        201   &#65533; */
            0, /*   CA        202   &#65533; */
            0, /*   CB        203   &#65533; */
            0, /*   CC        204   &#65533; */
            0, /*   CD        205   &#65533; */
            0, /*   CE        206   &#65533; */
            0, /*   CF        207   &#65533; */
            0, /*   D0        208   &#65533; */
            0, /*   D1        209   &#65533; */
            0, /*   D2        210   &#65533; */
            0, /*   D3        211   &#65533; */
            0, /*   D4        212   &#65533; */
            0, /*   D5        213   &#65533; */
            0, /*   D6        214   &#65533; */
            0, /*   D7        215   &#65533; */
            0, /*   D8        216   &#65533; */
            0, /*   D9        217   &#65533; */
            0, /*   DA        218   &#65533; */
            0, /*   DB        219   &#65533; */
            0, /*   DC        220   &#65533; */
            0, /*   DD        221   &#65533; */
            0, /*   DE        222   &#65533; */
            0, /*   DF        223   &#65533; */
            0, /*   E0        224   &#65533; */
            0, /*   E1        225   &#65533; */
            0, /*   E2        226   &#65533; */
            0, /*   E3        227   &#65533; */
            0, /*   E4        228   &#65533; */
            0, /*   E5        229   &#65533; */
            0, /*   E6        230   &#65533; */
            0, /*   E7        231   &#65533; */
            0, /*   E8        232   &#65533; */
            0, /*   E9        233   &#65533; */
            0, /*   EA        234   &#65533; */
            0, /*   EB        235   &#65533; */
            0, /*   EC        236   &#65533; */
            0, /*   ED        237   &#65533; */
            0, /*   EE        238   &#65533; */
            0, /*   EF        239   &#65533; */
            0, /*   F0        240   &#65533; */
            0, /*   F1        241   &#65533; */
            0, /*   F2        242   &#65533; */
            0, /*   F3        243   &#65533; */
            0, /*   F4        244   &#65533; */
            0, /*   F5        245   &#65533; */
            0, /*   F6        246   &#65533; */
            0, /*   F7        247   &#65533; */
            0, /*   F8        248   &#65533; */
            0, /*   F9        249   &#65533; */
            0, /*   FA        250   &#65533; */
            0, /*   FB        251   &#65533; */
            0, /*   FC        252   &#65533; */
            0, /*   FD        253   &#65533; */
            0, /*   FE        254   &#65533; */
            0, /*   FF        255   &#65533; */
};

/*******************************************************************************************
  Width table provides the width of each character. It's useful for proportional font only.
  For monospaced font, the width of each character is the same.

  To get the width of character 'A', you can use the following expression:

     const unsigned char index = index_table['A'];
     const unsigned char width = width_table[index];

 *******************************************************************************************/
const unsigned char c28_width_table[] = {
/*        width    char    hexcode */
/*        =====    ====    ======= */
           18, /*   +      2B      */
           10, /*   ,      2C      */
           11, /*   -      2D      */
           10, /*   .      2E      */
           16, /*   /      2F      */
           19, /*   0      30      */
           19, /*   1      31      */
           19, /*   2      32      */
           19, /*   3      33      */
           19, /*   4      34      */
           19, /*   5      35      */
           19, /*   6      36      */
           19, /*   7      37      */
           19, /*   8      38      */
           19, /*   9      39      */
           10, /*   :      3A      */
           10, /*   ;      3B      */
           18, /*   <      3C      */
           18, /*   =      3D      */
           18, /*   >      3E      */
           17, /*   ?      3F      */
           33, /*   @      40      */
           22, /*   A      41      */
           21, /*   B      42      */
           20, /*   C      43      */
           23, /*   D      44      */
           18, /*   E      45      */
           17, /*   F      46      */
           24, /*   G      47      */
           23, /*   H      48      */
           10, /*   I      49      */
           12, /*   J      4A      */
           20, /*   K      4B      */
           16, /*   L      4C      */
           32, /*   M      4D      */
           24, /*   N      4E      */
           25, /*   O      4F      */
           20, /*   P      50      */
           26, /*   Q      51      */
           21, /*   R      52      */
           17, /*   S      53      */
           18, /*   T      54      */
           24, /*   U      55      */
           22, /*   V      56      */
           34, /*   W      57      */
           20, /*   X      58      */
           19, /*   Y      59      */
           18, /*   Z      5A      */
           12, /*   [      5B      */
           16, /*   \      5C      */
           12, /*   ]      5D      */
           18, /*   ^      5E      */
           21, /*   _      5F      */
           11, /*   `      60      */
           18, /*   a      61      */
           20, /*   b      62      */
           15, /*   c      63      */
           20, /*   d      64      */
           19, /*   e      65      */
           13, /*   f      66      */
           18, /*   g      67      */
           20, /*   h      68      */
            9, /*   i      69      */
           11, /*   j      6A      */
           18, /*   k      6B      */
            9, /*   l      6C      */
           30, /*   m      6D      */
           20, /*   n      6E      */
           20, /*   o      6F      */
           20, /*   p      70      */
           20, /*   q      71      */
           13, /*   r      72      */
           15, /*   s      73      */
           13, /*   t      74      */
           20, /*   u      75      */
           18, /*   v      76      */
           28, /*   w      77      */
           17, /*   x      78      */
           18, /*   y      79      */
           15, /*   z      7A      */
};
