/*******************************************************************************************
 Font name: Calibri
 Font width: varialbe (proportional font)
 Font height: 23
 Data length: 8 bits
 Data format: Big Endian, Column based, Column preferred, Unpacked
 
 Create time: 23:00 03-22-2011  by BitFontCreator (e-mail: support@iseatech.com)
 *******************************************************************************************/

/*******************************************************************************************
 Data table provides the bitmap data of each character.
 
 To get the starting data offset of character 'A', you can use the following expression:
 
 const unsigned char index = index_table['A'];
 const unsigned int offset = offset_table[index];
 const unsigned char *pData = data_table[offset];
 
 *******************************************************************************************/
#include    "font_new.h"
const unsigned char c14_data_table[] = {
    
    /* character 0x2B ('+'): (width=9, offset=0) */
    0x00, 0x0C, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 
    0x00, 0x00, 0x7F, 0x80, 0x00, 0x7F, 0x80, 0x00, 
    0x0C, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 0x00, 
    0x00, 0x00, 0x00, 
    
    /* character 0x2C (','): (width=5, offset=27) */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 
    0xF8, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 
    
    /* character 0x2D ('-'): (width=6, offset=42) */
    0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 
    0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 0x00, 0x00, 
    0x00, 0x00, 
    
    /* character 0x2E ('.'): (width=5, offset=60) */
    0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 
    0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x2F ('/'): (width=8, offset=75) */
    0x00, 0x00, 0x18, 0x00, 0x00, 0xF8, 0x00, 0x03, 
    0xE0, 0x00, 0x1F, 0x00, 0x00, 0x7C, 0x00, 0x03, 
    0xE0, 0x00, 0x0F, 0x80, 0x00, 0x0C, 0x00, 0x00, 
    
    /* character 0x30 ('0'): (width=10, offset=99) */
    0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x01, 0xFF, 
    0x80, 0x03, 0x81, 0xC0, 0x03, 0x00, 0xC0, 0x03, 
    0x00, 0xC0, 0x03, 0x81, 0xC0, 0x01, 0xFF, 0x80, 
    0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x31 ('1'): (width=10, offset=129) */
    0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0x01, 0x80, 
    0xC0, 0x01, 0x80, 0xC0, 0x03, 0xFF, 0xC0, 0x03, 
    0xFF, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 0xC0, 
    0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 
    
    /* character 0x32 ('2'): (width=10, offset=159) */
    0x00, 0x00, 0x00, 0x01, 0x80, 0xC0, 0x03, 0x01, 
    0xC0, 0x03, 0x03, 0xC0, 0x03, 0x06, 0xC0, 0x03, 
    0x1C, 0xC0, 0x03, 0xF8, 0xC0, 0x01, 0xE0, 0xC0, 
    0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 
    
    /* character 0x33 ('3'): (width=10, offset=189) */
    0x00, 0x00, 0x00, 0x01, 0x81, 0x80, 0x03, 0x18, 
    0xC0, 0x03, 0x18, 0xC0, 0x03, 0x18, 0xC0, 0x03, 
    0x18, 0xC0, 0x03, 0xFF, 0xC0, 0x01, 0xE7, 0x80, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x34 ('4'): (width=10, offset=219) */
    0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x3E, 
    0x00, 0x00, 0x76, 0x00, 0x01, 0xC6, 0x00, 0x03, 
    0x06, 0x00, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 0xC0, 
    0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x35 ('5'): (width=10, offset=249) */
    0x00, 0x00, 0x00, 0x03, 0xF1, 0x80, 0x03, 0xF0, 
    0xC0, 0x03, 0x30, 0xC0, 0x03, 0x30, 0xC0, 0x03, 
    0x30, 0xC0, 0x03, 0x39, 0xC0, 0x03, 0x1F, 0x80, 
    0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x36 ('6'): (width=10, offset=279) */
    0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x01, 0xFF, 
    0x80, 0x01, 0x99, 0xC0, 0x03, 0x30, 0xC0, 0x03, 
    0x30, 0xC0, 0x03, 0x39, 0xC0, 0x03, 0x1F, 0x80, 
    0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x37 ('7'): (width=10, offset=309) */
    0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 
    0xC0, 0x03, 0x03, 0xC0, 0x03, 0x0F, 0x80, 0x03, 
    0x1E, 0x00, 0x03, 0x78, 0x00, 0x03, 0xE0, 0x00, 
    0x03, 0x80, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x38 ('8'): (width=10, offset=339) */
    0x00, 0x00, 0x00, 0x01, 0xE3, 0x80, 0x03, 0xF7, 
    0xC0, 0x03, 0x3C, 0xC0, 0x03, 0x18, 0xC0, 0x03, 
    0x18, 0xC0, 0x03, 0x3C, 0xC0, 0x03, 0xEF, 0xC0, 
    0x01, 0xC7, 0x80, 0x00, 0x00, 0x00, 
    
    /* character 0x39 ('9'): (width=10, offset=369) */
    0x00, 0x00, 0x00, 0x00, 0xF0, 0xC0, 0x01, 0xF8, 
    0xC0, 0x03, 0x9C, 0xC0, 0x03, 0x0C, 0xC0, 0x03, 
    0x0C, 0xC0, 0x03, 0x99, 0x80, 0x01, 0xFF, 0x80, 
    0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x3A (':'): (width=5, offset=399) */
    0x00, 0x00, 0x00, 0x00, 0x30, 0xC0, 0x00, 0x30, 
    0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x3B (';'): (width=5, offset=414) */
    0x00, 0x00, 0x18, 0x00, 0x30, 0xF8, 0x00, 0x30, 
    0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x3C ('<'): (width=9, offset=429) */
    0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x1C, 
    0x00, 0x00, 0x36, 0x00, 0x00, 0x36, 0x00, 0x00, 
    0x63, 0x00, 0x00, 0x63, 0x00, 0x00, 0xC1, 0x80, 
    0x00, 0x00, 0x00, 
    
    /* character 0x3D ('='): (width=9, offset=456) */
    0x00, 0x33, 0x00, 0x00, 0x33, 0x00, 0x00, 0x33, 
    0x00, 0x00, 0x33, 0x00, 0x00, 0x33, 0x00, 0x00, 
    0x33, 0x00, 0x00, 0x33, 0x00, 0x00, 0x33, 0x00, 
    0x00, 0x00, 0x00, 
    
    /* character 0x3E ('>'): (width=9, offset=483) */
    0x00, 0x00, 0x00, 0x00, 0xC1, 0x80, 0x00, 0x63, 
    0x00, 0x00, 0x63, 0x00, 0x00, 0x36, 0x00, 0x00, 
    0x36, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x1C, 0x00, 
    0x00, 0x00, 0x00, 
    
    /* character 0x3F ('?'): (width=9, offset=510) */
    0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x06, 0x00, 
    0x00, 0x06, 0x1D, 0xC0, 0x06, 0x1D, 0xC0, 0x07, 
    0x30, 0x00, 0x03, 0xF0, 0x00, 0x01, 0xE0, 0x00, 
    0x00, 0x00, 0x00, 
    
    /* character 0x40 ('@'): (width=17, offset=537) */
    0x00, 0x00, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x7F, 
    0xC0, 0x00, 0xE0, 0xE0, 0x01, 0xC0, 0x70, 0x01, 
    0x9E, 0x30, 0x03, 0x3F, 0x30, 0x03, 0x63, 0x30, 
    0x03, 0x63, 0x30, 0x03, 0x3E, 0x30, 0x03, 0x7F, 
    0x30, 0x03, 0x73, 0x60, 0x03, 0x03, 0x00, 0x01, 
    0x87, 0x00, 0x01, 0xFE, 0x00, 0x00, 0x7C, 0x00, 
    0x00, 0x00, 0x00, 
    
    /* character 0x41 ('A'): (width=12, offset=588) */
    0x00, 0x00, 0xC0, 0x00, 0x07, 0xC0, 0x00, 0x1F, 
    0x00, 0x00, 0xFE, 0x00, 0x03, 0xE6, 0x00, 0x03, 
    0x06, 0x00, 0x03, 0xE6, 0x00, 0x00, 0xFE, 0x00, 
    0x00, 0x1F, 0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, 
    0xC0, 0x00, 0x00, 0x00, 
    
    /* character 0x42 ('B'): (width=11, offset=624) */
    0x00, 0x00, 0x00, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 
    0xC0, 0x03, 0x18, 0xC0, 0x03, 0x18, 0xC0, 0x03, 
    0x18, 0xC0, 0x03, 0x18, 0xC0, 0x03, 0x18, 0xC0, 
    0x03, 0xFF, 0xC0, 0x01, 0xEF, 0x80, 0x00, 0x00, 
    0x00, 
    
    /* character 0x43 ('C'): (width=10, offset=657) */
    0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x01, 0xFF, 
    0x80, 0x01, 0x81, 0x80, 0x03, 0x00, 0xC0, 0x03, 
    0x00, 0xC0, 0x03, 0x00, 0xC0, 0x03, 0x00, 0xC0, 
    0x03, 0x00, 0xC0, 0x01, 0x81, 0x80, 
    
    /* character 0x44 ('D'): (width=12, offset=687) */
    0x00, 0x00, 0x00, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 
    0xC0, 0x03, 0x00, 0xC0, 0x03, 0x00, 0xC0, 0x03, 
    0x00, 0xC0, 0x03, 0x00, 0xC0, 0x03, 0x00, 0xC0, 
    0x01, 0x81, 0x80, 0x01, 0xFF, 0x80, 0x00, 0x7E, 
    0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x45 ('E'): (width=9, offset=723) */
    0x00, 0x00, 0x00, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 
    0xC0, 0x03, 0x18, 0xC0, 0x03, 0x18, 0xC0, 0x03, 
    0x18, 0xC0, 0x03, 0x18, 0xC0, 0x03, 0x00, 0xC0, 
    0x00, 0x00, 0x00, 
    
    /* character 0x46 ('F'): (width=9, offset=750) */
    0x00, 0x00, 0x00, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 
    0xC0, 0x03, 0x18, 0x00, 0x03, 0x18, 0x00, 0x03, 
    0x18, 0x00, 0x03, 0x18, 0x00, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0x00, 
    
    /* character 0x47 ('G'): (width=12, offset=777) */
    0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x01, 0xFF, 
    0x80, 0x01, 0x81, 0x80, 0x03, 0x00, 0xC0, 0x03, 
    0x00, 0xC0, 0x03, 0x18, 0xC0, 0x03, 0x18, 0xC0, 
    0x03, 0x18, 0xC0, 0x03, 0x1F, 0xC0, 0x01, 0x9F, 
    0x80, 0x00, 0x00, 0x00, 
    
    /* character 0x48 ('H'): (width=12, offset=813) */
    0x00, 0x00, 0x00, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 
    0xC0, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 
    0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 
    0x00, 0x18, 0x00, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 
    0xC0, 0x00, 0x00, 0x00, 
    
    /* character 0x49 ('I'): (width=5, offset=849) */
    0x00, 0x00, 0x00, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 
    0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x4A ('J'): (width=6, offset=864) */
    0x00, 0x01, 0x80, 0x00, 0x00, 0xC0, 0x00, 0x00, 
    0xC0, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 0x80, 0x00, 
    0x00, 0x00, 
    
    /* character 0x4B ('K'): (width=10, offset=882) */
    0x00, 0x00, 0x00, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 
    0xC0, 0x00, 0x18, 0x00, 0x00, 0x3C, 0x00, 0x00, 
    0x7F, 0x00, 0x00, 0xE7, 0x80, 0x01, 0xC3, 0xC0, 
    0x03, 0x80, 0xC0, 0x03, 0x00, 0x40, 
    
    /* character 0x4C ('L'): (width=8, offset=912) */
    0x00, 0x00, 0x00, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 
    0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 0xC0, 0x00, 
    0x00, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 0xC0, 
    
    /* character 0x4D ('M'): (width=17, offset=936) */
    0x00, 0x00, 0x00, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 
    0xC0, 0x03, 0xC0, 0x00, 0x00, 0xF0, 0x00, 0x00, 
    0x3C, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x03, 0xC0, 
    0x00, 0x03, 0xC0, 0x00, 0x0F, 0x00, 0x00, 0x3C, 
    0x00, 0x00, 0xF0, 0x00, 0x03, 0xC0, 0x00, 0x03, 
    0xFF, 0xC0, 0x03, 0xFF, 0xC0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 
    
    /* character 0x4E ('N'): (width=13, offset=987) */
    0x00, 0x00, 0x00, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 
    0xC0, 0x03, 0x80, 0x00, 0x01, 0xE0, 0x00, 0x00, 
    0x70, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x0E, 0x00, 
    0x00, 0x07, 0x80, 0x00, 0x01, 0xC0, 0x03, 0xFF, 
    0xC0, 0x03, 0xFF, 0xC0, 0x00, 0x00, 0x00, 
    
    /* character 0x4F ('O'): (width=13, offset=1026) */
    0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x01, 0xFF, 
    0x80, 0x01, 0x81, 0x80, 0x03, 0x00, 0xC0, 0x03, 
    0x00, 0xC0, 0x03, 0x00, 0xC0, 0x03, 0x00, 0xC0, 
    0x03, 0x00, 0xC0, 0x01, 0x81, 0x80, 0x01, 0xFF, 
    0x80, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x50 ('P'): (width=10, offset=1065) */
    0x00, 0x00, 0x00, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 
    0xC0, 0x03, 0x0C, 0x00, 0x03, 0x0C, 0x00, 0x03, 
    0x0C, 0x00, 0x03, 0x9C, 0x00, 0x01, 0xF8, 0x00, 
    0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x51 ('Q'): (width=14, offset=1095) */
    0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x01, 0xFF, 
    0x80, 0x01, 0x81, 0x80, 0x03, 0x00, 0xC0, 0x03, 
    0x00, 0xC0, 0x03, 0x00, 0xC0, 0x03, 0x00, 0xC0, 
    0x03, 0x00, 0xC0, 0x01, 0x81, 0xE0, 0x01, 0xFF, 
    0x60, 0x00, 0x7E, 0x30, 0x00, 0x00, 0x30, 0x00, 
    0x00, 0x00, 
    
    /* character 0x52 ('R'): (width=11, offset=1137) */
    0x00, 0x00, 0x00, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 
    0xC0, 0x03, 0x18, 0x00, 0x03, 0x18, 0x00, 0x03, 
    0x18, 0x00, 0x03, 0x1C, 0x00, 0x03, 0xF7, 0x00, 
    0x01, 0xE3, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 
    0x00, 
    
    /* character 0x53 ('S'): (width=9, offset=1170) */
    0x00, 0x00, 0x00, 0x00, 0xE1, 0x80, 0x01, 0xF0, 
    0xC0, 0x03, 0x38, 0xC0, 0x03, 0x18, 0xC0, 0x03, 
    0x1C, 0xC0, 0x03, 0x0F, 0x80, 0x01, 0x87, 0x00, 
    0x00, 0x00, 0x00, 
    
    /* character 0x54 ('T'): (width=10, offset=1197) */
    0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 
    0x00, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 0xC0, 0x03, 
    0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x55 ('U'): (width=12, offset=1227) */
    0x00, 0x00, 0x00, 0x03, 0xFF, 0x00, 0x03, 0xFF, 
    0x80, 0x00, 0x01, 0xC0, 0x00, 0x00, 0xC0, 0x00, 
    0x00, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 0xC0, 
    0x00, 0x01, 0xC0, 0x03, 0xFF, 0x80, 0x03, 0xFF, 
    0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x56 ('V'): (width=11, offset=1263) */
    0x03, 0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, 0xF8, 
    0x00, 0x00, 0x1F, 0x00, 0x00, 0x07, 0xC0, 0x00, 
    0x00, 0xC0, 0x00, 0x07, 0xC0, 0x00, 0x1F, 0x00, 
    0x00, 0xF8, 0x00, 0x03, 0xE0, 0x00, 0x03, 0x00, 
    0x00, 
    
    /* character 0x57 ('W'): (width=17, offset=1296) */
    0x00, 0x00, 0x00, 0x03, 0x80, 0x00, 0x03, 0xF0, 
    0x00, 0x00, 0x7E, 0x00, 0x00, 0x0F, 0xC0, 0x00, 
    0x07, 0xC0, 0x00, 0x3F, 0x00, 0x01, 0xF8, 0x00, 
    0x03, 0xC0, 0x00, 0x01, 0xF8, 0x00, 0x00, 0x3F, 
    0x00, 0x00, 0x07, 0xC0, 0x00, 0x0F, 0xC0, 0x00, 
    0x7E, 0x00, 0x03, 0xF0, 0x00, 0x03, 0x80, 0x00, 
    0x00, 0x00, 0x00, 
    
    /* character 0x58 ('X'): (width=10, offset=1347) */
    0x02, 0x00, 0x40, 0x03, 0x81, 0xC0, 0x01, 0xE7, 
    0x80, 0x00, 0x7E, 0x00, 0x00, 0x18, 0x00, 0x00, 
    0x7E, 0x00, 0x01, 0xE7, 0x80, 0x03, 0x81, 0xC0, 
    0x02, 0x00, 0x40, 0x00, 0x00, 0x00, 
    
    /* character 0x59 ('Y'): (width=10, offset=1377) */
    0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0xC0, 
    0x00, 0x00, 0xF0, 0x00, 0x00, 0x3F, 0xC0, 0x00, 
    0x3F, 0xC0, 0x00, 0xF0, 0x00, 0x03, 0xC0, 0x00, 
    0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x5A ('Z'): (width=9, offset=1407) */
    0x03, 0x01, 0xC0, 0x03, 0x03, 0xC0, 0x03, 0x07, 
    0xC0, 0x03, 0x1E, 0xC0, 0x03, 0x3C, 0xC0, 0x03, 
    0x70, 0xC0, 0x03, 0xE0, 0xC0, 0x03, 0xC0, 0xC0, 
    0x03, 0x80, 0xC0, 
    
    /* character 0x5B ('['): (width=6, offset=1434) */
    0x00, 0x00, 0x00, 0x07, 0xFF, 0xF8, 0x07, 0xFF, 
    0xF8, 0x06, 0x00, 0x18, 0x06, 0x00, 0x18, 0x00, 
    0x00, 0x00, 
    
    /* character 0x5C ('\'): (width=8, offset=1452) */
    0x0C, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x03, 0xE0, 
    0x00, 0x00, 0x7C, 0x00, 0x00, 0x1F, 0x00, 0x00, 
    0x03, 0xE0, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x18, 
    
    /* character 0x5D (']'): (width=6, offset=1476) */
    0x00, 0x00, 0x00, 0x06, 0x00, 0x18, 0x06, 0x00, 
    0x18, 0x07, 0xFF, 0xF8, 0x07, 0xFF, 0xF8, 0x00, 
    0x00, 0x00, 
    
    /* character 0x5E ('^'): (width=9, offset=1494) */
    0x00, 0x18, 0x00, 0x00, 0x78, 0x00, 0x01, 0xE0, 
    0x00, 0x03, 0x80, 0x00, 0x03, 0x00, 0x00, 0x03, 
    0x80, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x78, 0x00, 
    0x00, 0x18, 0x00, 
    
    /* character 0x5F ('_'): (width=10, offset=1521) */
    0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 
    0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 
    0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 
    0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 
    
    /* character 0x60 ('`'): (width=6, offset=1551) */
    0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x06, 0x00, 
    0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 
    
    /* character 0x61 ('a'): (width=9, offset=1569) */
    0x00, 0x00, 0x00, 0x00, 0x33, 0x80, 0x00, 0x67, 
    0xC0, 0x00, 0x64, 0xC0, 0x00, 0x64, 0xC0, 0x00, 
    0x64, 0x80, 0x00, 0x7F, 0xC0, 0x00, 0x3F, 0xC0, 
    0x00, 0x00, 0x00, 
    
    /* character 0x62 ('b'): (width=10, offset=1596) */
    0x00, 0x00, 0x00, 0x07, 0xFF, 0xC0, 0x07, 0xFF, 
    0xC0, 0x00, 0x31, 0x80, 0x00, 0x60, 0xC0, 0x00, 
    0x60, 0xC0, 0x00, 0x71, 0xC0, 0x00, 0x3F, 0x80, 
    0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x63 ('c'): (width=8, offset=1626) */
    0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x3F, 
    0x80, 0x00, 0x71, 0xC0, 0x00, 0x60, 0xC0, 0x00, 
    0x60, 0xC0, 0x00, 0x31, 0x80, 0x00, 0x00, 0x00, 
    
    /* character 0x64 ('d'): (width=10, offset=1650) */
    0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x3F, 
    0x80, 0x00, 0x71, 0xC0, 0x00, 0x60, 0xC0, 0x00, 
    0x60, 0xC0, 0x00, 0x31, 0x80, 0x07, 0xFF, 0xC0, 
    0x07, 0xFF, 0xC0, 0x00, 0x00, 0x00, 
    
    /* character 0x65 ('e'): (width=10, offset=1680) */
    0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x3F, 
    0x80, 0x00, 0x75, 0xC0, 0x00, 0x64, 0xC0, 0x00, 
    0x64, 0xC0, 0x00, 0x74, 0xC0, 0x00, 0x3C, 0xC0, 
    0x00, 0x1D, 0x80, 0x00, 0x00, 0x00, 
    
    /* character 0x66 ('f'): (width=7, offset=1710) */
    0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x03, 0xFF, 
    0xC0, 0x07, 0xFF, 0xC0, 0x06, 0x60, 0x00, 0x06, 
    0x60, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x67 ('g'): (width=9, offset=1731) */
    0x00, 0x00, 0x70, 0x00, 0x3D, 0xF8, 0x00, 0x7F, 
    0xD8, 0x00, 0x66, 0xD8, 0x00, 0x66, 0xD8, 0x00, 
    0x7E, 0xD8, 0x00, 0x7C, 0xF0, 0x00, 0x60, 0x70, 
    0x00, 0x00, 0x00, 
    
    /* character 0x68 ('h'): (width=10, offset=1758) */
    0x00, 0x00, 0x00, 0x07, 0xFF, 0xC0, 0x07, 0xFF, 
    0xC0, 0x00, 0x30, 0x00, 0x00, 0x60, 0x00, 0x00, 
    0x60, 0x00, 0x00, 0x60, 0x00, 0x00, 0x7F, 0xC0, 
    0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, 
    
    /* character 0x69 ('i'): (width=5, offset=1788) */
    0x00, 0x00, 0x00, 0x03, 0x7F, 0xC0, 0x03, 0x7F, 
    0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x6A ('j'): (width=7, offset=1803) */
    0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x03, 0x7F, 
    0xF8, 0x03, 0x7F, 0xF0, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x6B ('k'): (width=9, offset=1824) */
    0x00, 0x00, 0x00, 0x07, 0xFF, 0xC0, 0x07, 0xFF, 
    0xC0, 0x00, 0x0C, 0x00, 0x00, 0x1E, 0x00, 0x00, 
    0x3F, 0x00, 0x00, 0x73, 0x80, 0x00, 0x61, 0xC0, 
    0x00, 0x40, 0xC0, 
    
    /* character 0x6C ('l'): (width=5, offset=1851) */
    0x00, 0x00, 0x00, 0x07, 0xFF, 0xC0, 0x07, 0xFF, 
    0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x6D ('m'): (width=15, offset=1866) */
    0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x7F, 
    0xC0, 0x00, 0x30, 0x00, 0x00, 0x60, 0x00, 0x00, 
    0x60, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x3F, 0xC0, 
    0x00, 0x30, 0x00, 0x00, 0x60, 0x00, 0x00, 0x60, 
    0x00, 0x00, 0x7F, 0xC0, 0x00, 0x3F, 0xC0, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x6E ('n'): (width=10, offset=1911) */
    0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x7F, 
    0xC0, 0x00, 0x30, 0x00, 0x00, 0x60, 0x00, 0x00, 
    0x60, 0x00, 0x00, 0x60, 0x00, 0x00, 0x7F, 0xC0, 
    0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, 
    
    /* character 0x6F ('o'): (width=10, offset=1941) */
    0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x3F, 
    0x80, 0x00, 0x71, 0xC0, 0x00, 0x60, 0xC0, 0x00, 
    0x60, 0xC0, 0x00, 0x71, 0xC0, 0x00, 0x3F, 0x80, 
    0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x70 ('p'): (width=10, offset=1971) */
    0x00, 0x00, 0x00, 0x00, 0x7F, 0xF8, 0x00, 0x7F, 
    0xF8, 0x00, 0x31, 0x80, 0x00, 0x60, 0xC0, 0x00, 
    0x60, 0xC0, 0x00, 0x71, 0xC0, 0x00, 0x3F, 0x80, 
    0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x71 ('q'): (width=10, offset=2001) */
    0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x3F, 
    0x80, 0x00, 0x71, 0xC0, 0x00, 0x60, 0xC0, 0x00, 
    0x60, 0xC0, 0x00, 0x31, 0x80, 0x00, 0x7F, 0xF8, 
    0x00, 0x7F, 0xF8, 0x00, 0x00, 0x00, 
    
    /* character 0x72 ('r'): (width=7, offset=2031) */
    0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x7F, 
    0xC0, 0x00, 0x30, 0x00, 0x00, 0x60, 0x00, 0x00, 
    0x60, 0x00, 0x00, 0x00, 0x00, 
    
    /* character 0x73 ('s'): (width=8, offset=2052) */
    0x00, 0x00, 0x00, 0x00, 0x39, 0x80, 0x00, 0x7C, 
    0xC0, 0x00, 0x6C, 0xC0, 0x00, 0x66, 0xC0, 0x00, 
    0x67, 0xC0, 0x00, 0x33, 0x80, 0x00, 0x00, 0x00, 
    
    /* character 0x74 ('t'): (width=7, offset=2076) */
    0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x01, 0xFF, 
    0x80, 0x01, 0xFF, 0xC0, 0x00, 0x60, 0xC0, 0x00, 
    0x60, 0xC0, 0x00, 0x00, 0x00, 
    
    /* character 0x75 ('u'): (width=10, offset=2097) */
    0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, 0x7F, 
    0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 0xC0, 0x00, 
    0x00, 0xC0, 0x00, 0x01, 0x80, 0x00, 0x7F, 0xC0, 
    0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, 
    
    /* character 0x76 ('v'): (width=9, offset=2127) */
    0x00, 0x60, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x1F, 
    0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0xC0, 0x00, 
    0x03, 0xC0, 0x00, 0x1F, 0x00, 0x00, 0x7C, 0x00, 
    0x00, 0x60, 0x00, 
    
    /* character 0x77 ('w'): (width=14, offset=2154) */
    0x00, 0x60, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x1F, 
    0x00, 0x00, 0x03, 0xC0, 0x00, 0x03, 0xC0, 0x00, 
    0x1F, 0x00, 0x00, 0x78, 0x00, 0x00, 0x78, 0x00, 
    0x00, 0x1F, 0x00, 0x00, 0x03, 0xC0, 0x00, 0x03, 
    0xC0, 0x00, 0x1F, 0x00, 0x00, 0x7C, 0x00, 0x00, 
    0x60, 0x00, 
    
    /* character 0x78 ('x'): (width=9, offset=2196) */
    0x00, 0x00, 0x00, 0x00, 0x60, 0xC0, 0x00, 0x7B, 
    0xC0, 0x00, 0x1F, 0x00, 0x00, 0x0E, 0x00, 0x00, 
    0x1F, 0x00, 0x00, 0x7B, 0xC0, 0x00, 0x60, 0xC0, 
    0x00, 0x00, 0x00, 
    
    /* character 0x79 ('y'): (width=9, offset=2223) */
    0x00, 0x60, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x1F, 
    0x00, 0x00, 0x03, 0x98, 0x00, 0x00, 0xF8, 0x00, 
    0x03, 0xE0, 0x00, 0x1F, 0x00, 0x00, 0x7C, 0x00, 
    0x00, 0x60, 0x00, 
    
    /* character 0x7A ('z'): (width=8, offset=2250) */
    0x00, 0x00, 0x00, 0x00, 0x61, 0xC0, 0x00, 0x63, 
    0xC0, 0x00, 0x66, 0xC0, 0x00, 0x6C, 0xC0, 0x00, 
    0x78, 0xC0, 0x00, 0x70, 0xC0, 0x00, 0x00, 0x00, 
    
};

/*******************************************************************************************
 Offset table provides the starting offset of each character in the data table.
 
 To get the starting offset of character 'A', you can use the following expression:
 
 const unsigned char index = index_table['A'];
 const unsigned int offset = offset_table[index]
 
 *******************************************************************************************/
const unsigned int c14_offset_table[] = {
    /*        offset    char    hexcode */
    /*        ======    ====    ======= */
    0, /*   +      2B      */
    27, /*   ,      2C      */
    42, /*   -      2D      */
    60, /*   .      2E      */
    75, /*   /      2F      */
    99, /*   0      30      */
    129, /*   1      31      */
    159, /*   2      32      */
    189, /*   3      33      */
    219, /*   4      34      */
    249, /*   5      35      */
    279, /*   6      36      */
    309, /*   7      37      */
    339, /*   8      38      */
    369, /*   9      39      */
    399, /*   :      3A      */
    414, /*   ;      3B      */
    429, /*   <      3C      */
    456, /*   =      3D      */
    483, /*   >      3E      */
    510, /*   ?      3F      */
    537, /*   @      40      */
    588, /*   A      41      */
    624, /*   B      42      */
    657, /*   C      43      */
    687, /*   D      44      */
    723, /*   E      45      */
    750, /*   F      46      */
    777, /*   G      47      */
    813, /*   H      48      */
    849, /*   I      49      */
    864, /*   J      4A      */
    882, /*   K      4B      */
    912, /*   L      4C      */
    936, /*   M      4D      */
    987, /*   N      4E      */
    1026, /*   O      4F      */
    1065, /*   P      50      */
    1095, /*   Q      51      */
    1137, /*   R      52      */
    1170, /*   S      53      */
    1197, /*   T      54      */
    1227, /*   U      55      */
    1263, /*   V      56      */
    1296, /*   W      57      */
    1347, /*   X      58      */
    1377, /*   Y      59      */
    1407, /*   Z      5A      */
    1434, /*   [      5B      */
    1452, /*   \      5C      */
    1476, /*   ]      5D      */
    1494, /*   ^      5E      */
    1521, /*   _      5F      */
    1551, /*   `      60      */
    1569, /*   a      61      */
    1596, /*   b      62      */
    1626, /*   c      63      */
    1650, /*   d      64      */
    1680, /*   e      65      */
    1710, /*   f      66      */
    1731, /*   g      67      */
    1758, /*   h      68      */
    1788, /*   i      69      */
    1803, /*   j      6A      */
    1824, /*   k      6B      */
    1851, /*   l      6C      */
    1866, /*   m      6D      */
    1911, /*   n      6E      */
    1941, /*   o      6F      */
    1971, /*   p      70      */
    2001, /*   q      71      */
    2031, /*   r      72      */
    2052, /*   s      73      */
    2076, /*   t      74      */
    2097, /*   u      75      */
    2127, /*   v      76      */
    2154, /*   w      77      */
    2196, /*   x      78      */
    2223, /*   y      79      */
    2250, /*   z      7A      */
};

/*******************************************************************************************
 Index table is used to find the mapping index of a character.
 
 If you can find a simple mathematical expression for index mapping, you can use that.
 If you do not have such a mathematical expression, this index table is just for you.
 
 To get the index of character 'A', you can use the following expression:
 
 const unsigned char index = index_table['A'];
 
 *******************************************************************************************/
const unsigned char c14_index_table[] = {
    /*        index   hexcode   decimal  char */
    /*        =====   =======   =======  ==== */
    0, /*   00          0     .   */
    0, /*   01          1     .   */
    0, /*   02          2     .   */
    0, /*   03          3     .   */
    0, /*   04          4     .   */
    0, /*   05          5     .   */
    0, /*   06          6     .   */
    0, /*   07          7     .   */
    0, /*   08          8     .   */
    0, /*   09          9     .   */
    0, /*   0A         10     .   */
    0, /*   0B         11     .   */
    0, /*   0C         12     .   */
    0, /*   0D         13     .   */
    0, /*   0E         14     .   */
    0, /*   0F         15     .   */
    0, /*   10         16     .   */
    0, /*   11         17     .   */
    0, /*   12         18     .   */
    0, /*   13         19     .   */
    0, /*   14         20     .   */
    0, /*   15         21     .   */
    0, /*   16         22     .   */
    0, /*   17         23     .   */
    0, /*   18         24     .   */
    0, /*   19         25     .   */
    0, /*   1A         26     .   */
    0, /*   1B         27     .   */
    0, /*   1C         28     .   */
    0, /*   1D         29     .   */
    0, /*   1E         30     .   */
    0, /*   1F         31     .   */
    0, /*   20         32         */
    0, /*   21         33     !   */
    0, /*   22         34     "   */
    0, /*   23         35     #   */
    0, /*   24         36     $   */
    0, /*   25         37     %   */
    0, /*   26         38     &   */
    0, /*   27         39     '   */
    0, /*   28         40     (   */
    0, /*   29         41     )   */
    0, /*   2A         42     *   */
    0, /*   2B         43     +   */
    1, /*   2C         44     ,   */
    2, /*   2D         45     -   */
    3, /*   2E         46     .   */
    4, /*   2F         47     /   */
    5, /*   30         48     0   */
    6, /*   31         49     1   */
    7, /*   32         50     2   */
    8, /*   33         51     3   */
    9, /*   34         52     4   */
    10, /*   35         53     5   */
    11, /*   36         54     6   */
    12, /*   37         55     7   */
    13, /*   38         56     8   */
    14, /*   39         57     9   */
    15, /*   3A         58     :   */
    16, /*   3B         59     ;   */
    17, /*   3C         60     <   */
    18, /*   3D         61     =   */
    19, /*   3E         62     >   */
    20, /*   3F         63     ?   */
    21, /*   40         64     @   */
    22, /*   41         65     A   */
    23, /*   42         66     B   */
    24, /*   43         67     C   */
    25, /*   44         68     D   */
    26, /*   45         69     E   */
    27, /*   46         70     F   */
    28, /*   47         71     G   */
    29, /*   48         72     H   */
    30, /*   49         73     I   */
    31, /*   4A         74     J   */
    32, /*   4B         75     K   */
    33, /*   4C         76     L   */
    34, /*   4D         77     M   */
    35, /*   4E         78     N   */
    36, /*   4F         79     O   */
    37, /*   50         80     P   */
    38, /*   51         81     Q   */
    39, /*   52         82     R   */
    40, /*   53         83     S   */
    41, /*   54         84     T   */
    42, /*   55         85     U   */
    43, /*   56         86     V   */
    44, /*   57         87     W   */
    45, /*   58         88     X   */
    46, /*   59         89     Y   */
    47, /*   5A         90     Z   */
    48, /*   5B         91     [   */
    49, /*   5C         92     \   */
    50, /*   5D         93     ]   */
    51, /*   5E         94     ^   */
    52, /*   5F         95     _   */
    53, /*   60         96     `   */
    54, /*   61         97     a   */
    55, /*   62         98     b   */
    56, /*   63         99     c   */
    57, /*   64        100     d   */
    58, /*   65        101     e   */
    59, /*   66        102     f   */
    60, /*   67        103     g   */
    61, /*   68        104     h   */
    62, /*   69        105     i   */
    63, /*   6A        106     j   */
    64, /*   6B        107     k   */
    65, /*   6C        108     l   */
    66, /*   6D        109     m   */
    67, /*   6E        110     n   */
    68, /*   6F        111     o   */
    69, /*   70        112     p   */
    70, /*   71        113     q   */
    71, /*   72        114     r   */
    72, /*   73        115     s   */
    73, /*   74        116     t   */
    74, /*   75        117     u   */
    75, /*   76        118     v   */
    76, /*   77        119     w   */
    77, /*   78        120     x   */
    78, /*   79        121     y   */
    79, /*   7A        122     z   */
    0, /*   7B        123   { */
    0, /*   7C        124   | */
    0, /*   7D        125   } */
    0, /*   7E        126   ~ */
    0, /*   7F        127    */
    0, /*   80        128   ? */
    0, /*   81        129   &#65533; */
    0, /*   82        130   ? */
    0, /*   83        131   ? */
    0, /*   84        132   ? */
    0, /*   85        133   ? */
    0, /*   86        134   ? */
    0, /*   87        135   ? */
    0, /*   88        136   ? */
    0, /*   89        137   ? */
    0, /*   8A        138   ? */
    0, /*   8B        139   ? */
    0, /*   8C        140   ? */
    0, /*   8D        141   &#65533; */
    0, /*   8E        142   ? */
    0, /*   8F        143   &#65533; */
    0, /*   90        144   &#65533; */
    0, /*   91        145   ? */
    0, /*   92        146   ? */
    0, /*   93        147   ? */
    0, /*   94        148   ? */
    0, /*   95        149   ? */
    0, /*   96        150   ? */
    0, /*   97        151   ? */
    0, /*   98        152   ? */
    0, /*   99        153   ? */
    0, /*   9A        154   ? */
    0, /*   9B        155   ? */
    0, /*   9C        156   ? */
    0, /*   9D        157   &#65533; */
    0, /*   9E        158   ? */
    0, /*   9F        159   ? */
    0, /*   A0        160   &#65533; */
    0, /*   A1        161   &#65533; */
    0, /*   A2        162   &#65533; */
    0, /*   A3        163   &#65533; */
    0, /*   A4        164   &#65533; */
    0, /*   A5        165   &#65533; */
    0, /*   A6        166   &#65533; */
    0, /*   A7        167   &#65533; */
    0, /*   A8        168   &#65533; */
    0, /*   A9        169   &#65533; */
    0, /*   AA        170   &#65533; */
    0, /*   AB        171   &#65533; */
    0, /*   AC        172   &#65533; */
    0, /*   AD        173   &#65533; */
    0, /*   AE        174   &#65533; */
    0, /*   AF        175   &#65533; */
    0, /*   B0        176   &#65533; */
    0, /*   B1        177   &#65533; */
    0, /*   B2        178   &#65533; */
    0, /*   B3        179   &#65533; */
    0, /*   B4        180   &#65533; */
    0, /*   B5        181   &#65533; */
    0, /*   B6        182   &#65533; */
    0, /*   B7        183   &#65533; */
    0, /*   B8        184   &#65533; */
    0, /*   B9        185   &#65533; */
    0, /*   BA        186   &#65533; */
    0, /*   BB        187   &#65533; */
    0, /*   BC        188   &#65533; */
    0, /*   BD        189   &#65533; */
    0, /*   BE        190   &#65533; */
    0, /*   BF        191   &#65533; */
    0, /*   C0        192   &#65533; */
    0, /*   C1        193   &#65533; */
    0, /*   C2        194   &#65533; */
    0, /*   C3        195   &#65533; */
    0, /*   C4        196   &#65533; */
    0, /*   C5        197   &#65533; */
    0, /*   C6        198   &#65533; */
    0, /*   C7        199   &#65533; */
    0, /*   C8        200   &#65533; */
    0, /*   C9        201   &#65533; */
    0, /*   CA        202   &#65533; */
    0, /*   CB        203   &#65533; */
    0, /*   CC        204   &#65533; */
    0, /*   CD        205   &#65533; */
    0, /*   CE        206   &#65533; */
    0, /*   CF        207   &#65533; */
    0, /*   D0        208   &#65533; */
    0, /*   D1        209   &#65533; */
    0, /*   D2        210   &#65533; */
    0, /*   D3        211   &#65533; */
    0, /*   D4        212   &#65533; */
    0, /*   D5        213   &#65533; */
    0, /*   D6        214   &#65533; */
    0, /*   D7        215   &#65533; */
    0, /*   D8        216   &#65533; */
    0, /*   D9        217   &#65533; */
    0, /*   DA        218   &#65533; */
    0, /*   DB        219   &#65533; */
    0, /*   DC        220   &#65533; */
    0, /*   DD        221   &#65533; */
    0, /*   DE        222   &#65533; */
    0, /*   DF        223   &#65533; */
    0, /*   E0        224   &#65533; */
    0, /*   E1        225   &#65533; */
    0, /*   E2        226   &#65533; */
    0, /*   E3        227   &#65533; */
    0, /*   E4        228   &#65533; */
    0, /*   E5        229   &#65533; */
    0, /*   E6        230   &#65533; */
    0, /*   E7        231   &#65533; */
    0, /*   E8        232   &#65533; */
    0, /*   E9        233   &#65533; */
    0, /*   EA        234   &#65533; */
    0, /*   EB        235   &#65533; */
    0, /*   EC        236   &#65533; */
    0, /*   ED        237   &#65533; */
    0, /*   EE        238   &#65533; */
    0, /*   EF        239   &#65533; */
    0, /*   F0        240   &#65533; */
    0, /*   F1        241   &#65533; */
    0, /*   F2        242   &#65533; */
    0, /*   F3        243   &#65533; */
    0, /*   F4        244   &#65533; */
    0, /*   F5        245   &#65533; */
    0, /*   F6        246   &#65533; */
    0, /*   F7        247   &#65533; */
    0, /*   F8        248   &#65533; */
    0, /*   F9        249   &#65533; */
    0, /*   FA        250   &#65533; */
    0, /*   FB        251   &#65533; */
    0, /*   FC        252   &#65533; */
    0, /*   FD        253   &#65533; */
    0, /*   FE        254   &#65533; */
    0, /*   FF        255   &#65533; */
};

/*******************************************************************************************
 Width table provides the width of each character. It's useful for proportional font only.
 For monospaced font, the width of each character is the same.
 
 To get the width of character 'A', you can use the following expression:
 
 const unsigned char index = index_table['A'];
 const unsigned char width = width_table[index];
 
 *******************************************************************************************/

const unsigned char c14_width_table[] = {
    /*        width    char    hexcode */
    /*        =====    ====    ======= */
    9, /*   +      2B      */
    5, /*   ,      2C      */
    6, /*   -      2D      */
    5, /*   .      2E      */
    8, /*   /      2F      */
    10, /*   0      30      */
    10, /*   1      31      */
    10, /*   2      32      */
    10, /*   3      33      */
    10, /*   4      34      */
    10, /*   5      35      */
    10, /*   6      36      */
    10, /*   7      37      */
    10, /*   8      38      */
    10, /*   9      39      */
    5, /*   :      3A      */
    5, /*   ;      3B      */
    9, /*   <      3C      */
    9, /*   =      3D      */
    9, /*   >      3E      */
    9, /*   ?      3F      */
    17, /*   @      40      */
    12, /*   A      41      */
    11, /*   B      42      */
    10, /*   C      43      */
    12, /*   D      44      */
    9, /*   E      45      */
    9, /*   F      46      */
    12, /*   G      47      */
    12, /*   H      48      */
    5, /*   I      49      */
    6, /*   J      4A      */
    10, /*   K      4B      */
    8, /*   L      4C      */
    17, /*   M      4D      */
    13, /*   N      4E      */
    13, /*   O      4F      */
    10, /*   P      50      */
    14, /*   Q      51      */
    11, /*   R      52      */
    9, /*   S      53      */
    10, /*   T      54      */
    12, /*   U      55      */
    11, /*   V      56      */
    17, /*   W      57      */
    10, /*   X      58      */
    10, /*   Y      59      */
    9, /*   Z      5A      */
    6, /*   [      5B      */
    8, /*   \      5C      */
    6, /*   ]      5D      */
    9, /*   ^      5E      */
    10, /*   _      5F      */
    6, /*   `      60      */
    9, /*   a      61      */
    10, /*   b      62      */
            8, /*   c      63      */
           10, /*   d      64      */
           10, /*   e      65      */
            7, /*   f      66      */
            9, /*   g      67      */
           10, /*   h      68      */
            5, /*   i      69      */
            7, /*   j      6A      */
            9, /*   k      6B      */
            5, /*   l      6C      */
           15, /*   m      6D      */
           10, /*   n      6E      */
           10, /*   o      6F      */
           10, /*   p      70      */
           10, /*   q      71      */
            7, /*   r      72      */
            8, /*   s      73      */
            7, /*   t      74      */
           10, /*   u      75      */
            9, /*   v      76      */
           14, /*   w      77      */
            9, /*   x      78      */
            9, /*   y      79      */
            8, /*   z      7A      */
};
