//#include    "mbed.h"
#include    <stdio.h>

#include    "font_new.h"

#ifdef   TEST
extern unsigned char    screen[ SC_WIDTH * SC_HEIGHT ]    = { '.' };
#endif

void clear_screen( void );
void show_screen( int xs, int width, int ys, int height );


int main()
{
    FontDrawInit();
    
    printf( "\r\n<< font drawing test >>\r\n" );
#ifdef SMALL_TEST
    clear_screen();    

    FontDraw_SetInterCharSpace( 0 );
    FontDraw_SetForegroundColor( 'Må' );
    FontDraw_SetBackgroundColor( ' ' );
    FontDraw_SetFont( Calibri14 );
//    FontDraw_printf( 0, 0, "Test %d", 0, 9 );
    FontDraw_printf( 0, 0, "+012" );
    FontDraw_SetAlphaMode( 1 );
    FontDrawChar( 'W', 20, 5, '@', '.', &Calibri28 );

    FontDrawChar( '@', 0, 0, '*', '.', &Calibri72 );
    show_screen( 0, 100, 0, 40 );

#else
    
    FontDraw_SetInterCharSpace( 2 );
    FontDraw_SetForegroundColor( 'M' );
    FontDraw_SetBackgroundColor( ' ' );
    FontDraw_SetFont( Calibri14 );
    FontDraw_printf( 20, 23, "test %d W1", 9 );
    
    FontDraw_SetInterCharSpace( 10 );
    FontDrawString( "Test ABCD", 10, 0, '@', '-', &Calibri14 );    
    
    int start    = 0;
    start    += FontDrawChar( '@', start, 46, '@', '.', &Calibri28 );
    
    FontDraw_SetAlphaMode( 1 );
    start    += FontDrawChar( 'W', 50, 15, '@', '.', &Calibri72 );
#ifdef TEST
    show_screen( 0, 200, 0, 150 );
#endif
    
#endif
    return ( 0 );
}
#ifdef TEST

void clear_screen( void )
{
    for ( int i = 0; i < SC_WIDTH * SC_HEIGHT; i++ )
        *(screen + i)    = '.';
}


void show_screen( int xs, int width, int ys, int height )
{
    int        i;
    int        j;
    
    for ( j = (ys + height - 1); j >= 0; j-- )
    {
        printf( "%04d  ", j );
        
        for ( i = xs; i < xs + width; i++ )
        {
            printf( "%c", *(screen + (j * SC_WIDTH) + i) & 0xFF );
            //            printf( "%c", *(screen + (((SC_HEIGHT - 1) - j) * SC_HEIGHT) + i) & 0xFF );
        }
        printf( "\r\n" );
    }
}
#endif
