/*********************************** LPC1114 WDT ************************************/
// From: https://developer.mbed.org/users/ThatcherC/code/WatchDogTest/rev/1c1e04c41063

class Watchdog {
public:
// Load timeout value in watchdog timer and enable
    void kick(float s) {
        LPC_SYSCON->SYSAHBCLKCTRL = LPC_SYSCON->SYSAHBCLKCTRL|(1<<15);
        LPC_SYSCON->WDTCLKSEL = 0x1;            // Set CLK src to Main Clock
        LPC_SYSCON->WDTCLKUEN = 0x01;           // Update clock */
        LPC_SYSCON->WDTCLKUEN = 0x00;           // Toggle update register once */
        LPC_SYSCON->WDTCLKUEN = 0x01;
        LPC_SYSCON->WDTCLKDIV = 0x10;
        uint32_t clk = SystemCoreClock/16;      // WD has a fixed /4 prescaler, PCLK default is /4
        LPC_WDT->TC = s * (float)clk;
        LPC_WDT->MOD = 0x3;                     // Enabled and Reset
        kick();
    }
// reset the watchdog timer by writing this required bit pattern
    void kick() {
        LPC_WDT->FEED = 0xAA;
        LPC_WDT->FEED = 0x55;
    }
};
 
// how to use this WDT with the LPC1114

//Watchdog wdt;    This sets the WDT up per code above - call it just before main();
 
//int main() {      
    
//wdt.kick(XX);     // set XX to LONGER than the main processing loop worst case
// LOOP             // this is the main program loop
//  .
//  .
//  .
//  wdt.kick(); // reset the WDT here
// GOTO: LOOP
//}