#include    "mbed.h"
#include    <stdio.h>
#include    "font_new.h"

void Write_Command(unsigned char command);
void SendData(unsigned long color);
void WindowSet(int s_x, int e_x,int s_y,int e_y);

void put_pixcels( int xs, int width, int ys, int height, unsigned char *c, int f_color, int b_color );
void put_pixcels_alpha( int xs, int width, int ys, int height, unsigned char *c, int color, int key );

int FontDrawSpace( int width, int height, int xpos, int ypos, int f_color, int b_color );

typedef struct _draw_font_parameters    {
    font    *font_ptr;
    int     inter_char_space;
    int     alpha_mode;
    int     f_color;
    int     b_color;
}
draw_font_parameters;
draw_font_parameters    dfp;

font                    Calibri14;
font                    Calibri28;
font                    Calibri72;
font                    Calibri78_1;

void FontDrawInit( void )
{
    Calibri14.height        = 23;
    Calibri14.max_width     = 17;
    Calibri14.space_width   = 7;
    Calibri14.data_table    = c14_data_table;
    Calibri14.offset_table  = c14_offset_table;
    Calibri14.index_table   = c14_index_table;
    Calibri14.width_table   = c14_width_table;
    
    Calibri28.height        = 45;
    Calibri28.max_width     = 34;
    Calibri28.space_width   = 10;
    Calibri28.data_table    = c28_data_table;
    Calibri28.offset_table  = c28_offset_table;
    Calibri28.index_table   = c28_index_table;
    Calibri28.width_table   = c28_width_table;
    
    Calibri72.height        = 117;
    Calibri72.max_width     = 87;
    Calibri72.space_width   = 20;
    Calibri72.data_table    = c72_data_table;
    Calibri72.offset_table  = c72_offset_table;
    Calibri72.index_table   = c72_index_table;
    Calibri72.width_table   = c72_width_table;
    
    Calibri78_1.height        = 117;
    Calibri78_1.max_width     = 49;
    Calibri78_1.space_width   = 20;
    Calibri78_1.data_table    = c78_1_data_table;
    Calibri78_1.offset_table  = c78_1_offset_table;
    Calibri78_1.index_table   = c78_1_index_table;
    Calibri78_1.width_table   = c78_1_width_table;
    
    dfp.font_ptr            = &Calibri14;
    dfp.inter_char_space    = 0;
    dfp.alpha_mode          = 0;
    dfp.f_color             = 0x0000FF;
    dfp.b_color             = 0xFFFFFF;
    
#if 0
 //   printf( "c14_data_table   : %p\r\n", c14_data_table );
 //   printf( "c14_data_table   : %p\r\n", Calibri14.data_table );
 //   printf( "c14_offset_table : %p\r\n", Calibri14.offset_table );
 //   printf( "c14_index_table  : %p\r\n", Calibri14.index_table );
 //   printf( "c14_width_table  : %p\r\n", Calibri14.width_table );
    
 //   printf( "(dfp.font_ptr->)data_table  : %p\r\n", dfp.font_ptr->data_table );
#endif    
}

//#ifdef TEST    
//extern unsigned char    screen[ SC_WIDTH * SC_HEIGHT ];
//#endif

void put_pixcels( int xs, int width, int ys, int height, unsigned char *c, int f_color, int b_color )
{
    int        i;
    int        j;
    
#ifdef TEST    
    for ( j = 0; j < height; j++ )
        for ( i = 0; i < width; i++ )
            *(screen + ((((height - 1) - j) + ys) * SC_WIDTH) + i + xs)    = (unsigned char)((*c++ == 'F') ? f_color : b_color);
#else
    WindowSet( xs, (xs + width) - 1, ys, (ys + height) - 1 );
    
    Write_Command( 0x2c );
    
    for ( j = 0; j < height; j++ )
        for ( i = 0; i < width; i++ )
            SendData( (*c++ == 'F') ? f_color : b_color );
#endif
}


void put_pixcels_alpha( int xs, int width, int ys, int height, unsigned char *c, int color, int key )
{
    int        i;
    int        j;
    
#ifdef TEST    
    
    for ( j = 0; j < height; j++ )
    {
        for ( i = 0; i < width; i++ )
        {
            if ( *c == 'F' )
                *(screen + ((((height - 1) - j) + ys) * SC_WIDTH) + i + xs)    = color;
            c++;
        }
    }

#else
    
    for ( j = 0; j < height; j++ )
    {
        for ( i = 0; i < width; i++ )
        {
            if ( *c != key )
            {
                WindowSet( xs + i, xs + i, ys + j, ys + j );
                Write_Command( 0x2c );
                SendData( *c++ );
            }
        }
    }
    
#endif
    
}

int FontDrawStringWidth( char *s, font *font_ptr )
{
    int        str_width    = 0;
    char    c;
    
    while ( c    = *s++ )
    {
        if ( ' ' == c )
        {
            str_width    += font_ptr->space_width;
        }
        else
        {
            str_width    += font_ptr->width_table[ font_ptr->index_table[ c ] ];
            
            if ( dfp.inter_char_space )
                str_width    += dfp.inter_char_space;
        }
    }
    
    return ( str_width );
}


unsigned char    pad[ 90 * 120 ];


int FontDrawChar( char c, int xpos, int ypos, int f_color, int b_color, font *font_ptr )
{
    unsigned char    index;
    unsigned int     offset;
    int              width;
    int              height;
    unsigned char    *data;
    int              i;
    int              j;
    
    index    = font_ptr->index_table[ c ];    
    offset    = font_ptr->offset_table[ index ];
    
    height    = font_ptr->height;
    
    if ( ' ' == c )
        return ( FontDrawSpace( font_ptr->space_width, height, xpos, ypos, f_color, b_color ) );
    
    width    = font_ptr->width_table[ index ];

//#if 0    
//    printf( "char   = '%c' on %d / %d - %d / %d - %p\r\n", c, xpos, ypos, f_color, b_color, font_ptr );
//    printf( "c14_data_table   : %p\r\n", c14_data_table );
//    printf( "c14_offset_table : %p\r\n", c14_offset_table );
//    printf( "c14_index_table  : %p\r\n", c14_index_table );
//    printf( "c14_width_table  : %p\r\n", c14_width_table );
//    printf( "(dfp.font_ptr->)data_table  : %p\r\n", dfp.font_ptr->data_table );
//    printf( "font_ptr->height        : %p\r\n", font_ptr->height );
//    printf( "font_ptr->max_width     : %p\r\n", font_ptr->max_width );
//    printf( "font_ptr->space_width   : %p\r\n", font_ptr->space_width );
//    printf( "font_ptr->data_table   : %p\r\n", font_ptr->data_table );
//    printf( "font_ptr->offset_table : %p (%p)\r\n", font_ptr->offset_table, font_ptr->offset_table - (unsigned int *)font_ptr->data_table );
//    printf( "font_ptr->index_table  : %p (%p)\r\n", font_ptr->index_table, font_ptr->index_table - font_ptr->data_table );
//    printf( "font_ptr->width_table  : %p (%p)\r\n", font_ptr->width_table, font_ptr->width_table - font_ptr->data_table );
//    printf( "index  = %u\r\n", index );
//    printf( "offset = %u\r\n", offset );
//    printf( "width  = %u\r\n", width );
//    printf( "height = %u\r\n", height );
//    printf( "\r\n" );
//#endif    
    data    = (unsigned char *)(&(font_ptr->data_table[ offset ]));

//#define    CHAR_FLIP_NORMAL_HORIZONTAL

#define    CHAR_FLIP_NORMAL_VERTICAL

    for ( i = 0; i < width; i++ )
    {
        for ( j = 0; j < height; j++ )
        {
#if defined( CHAR_FLIP_NORMAL_HORIZONTAL ) && !defined( CHAR_FLIP_NORMAL_VERTICAL )
            *(pad + (j * width) + ((width - 1) - i))    =  (*(data + (i * ((height + 7) / 8)) + (j / 8)) << (j % 8)) & 0x80 ? 'F' : 'B';
#elif !defined( CHAR_FLIP_NORMAL_HORIZONTAL ) && defined( CHAR_FLIP_NORMAL_VERTICAL )
            *(pad + (((height - 1) - j) * width) + i)    =  (*(data + (i * ((height + 7) / 8)) + (j / 8)) << (j % 8)) & 0x80 ? 'F' : 'B';
#elif defined( CHAR_FLIP_NORMAL_HORIZONTAL ) && defined( CHAR_FLIP_NORMAL_VERTICAL )
            *(pad + (((height - 1) - j) * width) + ((width - 1) - i))    =  (*(data + (i * ((height + 7) / 8)) + (j / 8)) << (j % 8)) & 0x80 ? 'F' : 'B';
#else
            *(pad + (j * width) + i)    =  (*(data + (i * ((height + 7) / 8)) + (j / 8)) << (j % 8)) & 0x80 ? 'F' : 'B';
#endif



#if 0
#if 0
            *(pad + (j * width) + i)    = (*(data + (i * ((height + 7) / 8)) + (j / 8)) << (j % 8)) & 0x80 ? 'F' : 'B';
#else
            *(pad + (((height - 1) - j) * width) + i)    = (*(data + (i * ((height + 7) / 8)) + (j / 8)) << (j % 8)) & 0x80 ? 'F' : 'B';
#endif
#endif
        }
     }

    if ( dfp.alpha_mode )
        put_pixcels_alpha( xpos, width, ypos, height, pad, f_color, b_color );
    else
        put_pixcels( xpos, width, ypos, height, pad, f_color, b_color );
    
    if ( dfp.inter_char_space )
        width    += FontDrawSpace( dfp.inter_char_space, height, xpos + width, ypos, f_color, b_color );
    
    return ( width );
}


int FontDrawSpace( int width, int height, int xpos, int ypos, int f_color, int b_color )
{
    int                i;
    unsigned char    pad[ width * height ];
    
    if ( dfp.alpha_mode )
        return ( width );
    
    for ( i = 0; i < width * height; i++ )
        *(pad + i)    = b_color;
    
    put_pixcels( xpos, width, ypos, height, pad, f_color, b_color );
    
    return ( width );
}


void FontDrawString( char *s, int xpos, int ypos, int f_color, int b_color, font *font_ptr )
{
    char    c;
    
    while ( c    = *s++ )
        xpos    += FontDrawChar( c, xpos, ypos, f_color, b_color, font_ptr );
}

void FontDraw_SetInterCharSpace( int space )
{
    dfp.inter_char_space    = space;
}


void FontDraw_SetAlphaMode( int mode )
{
    dfp.alpha_mode    = mode;
}

void FontDraw_SetFont( font f )
{
    dfp.font_ptr    = &f;
}

void FontDraw_SetForegroundColor( int v )
{
    dfp.f_color    = v;
}

void FontDraw_SetBackgroundColor( int v )
{
    dfp.b_color    = v;
}

void FontDraw_puts( int x, int y, char *s )
{
    FontDrawString( s, x, y, dfp.f_color, dfp.b_color, dfp.font_ptr );
}


#include    <stdarg.h>

void FontDraw_printf( int x, int y, char *format, ... )
{
    char        s[ 80 ];
    va_list        args;
    
    va_start( args, format );
    vsnprintf( s, 32, format, args );
    va_end( args );
    
    FontDraw_puts( x, y, s );
}
