/***********************************************************************************/
/***** Newhaven NHD-5.7-640480WF-CTXL# Display Driver **********/
/***** for mbed (www.mbed,org) NXP LPC1768 32 bit ARM MCU ******/
/********* Adapted by Andrew C. Russell,  March 2011 ***********/

/************I hereby acknowledge and thank the following ******/
/***software authors whose code I have adapted and/or adopted***/
/*******************to create these drivers:- ******************/

//Curt Lagerstam - Newhaven Display International, LLC for the dispay initialization.
//James P Lynch - code adapted from his Nokia LCD display tutorial at
//http://www.sparkfun.com/tutorial/Nokia%206100%20LCD%20Display%20Driver.pdf
//Akifumi 'Tedd' Okano for assistance and adapting the .bmp display driver and writing
//the driver for the font display
/***********************************************************************************/

//#include "mbed.h"
//#include "font_1.h"
//#include "stdlib.h"
//#include "string.h"
//#include "math.h"
#include "font_new.h"
//#include "system_defines.h"

/***********************************************************************************/
/********************************** Colors *****************************************/
/********* taken directly from http://web.njit.edu/~kevin/rgb.txt.html**************/
#define BLACK       0x000000
#define WHITE       0xFFFFFF
#define BLACK       0x000000
#define RED         0xFF0000
#define GREEN       0x00FF00
#define LGREEN      0xCCFF00    //light green
#define BLUE        0x0000FF
#define GREY        0xBEBEBE
#define DEEPINK     0xFF1493
#define YELLOW      0xFFFF00
#define LORANGE     0xFFFF00    //light orange
#define DORANGE     0xFF9900    //dark orange
#define OLIVE       0x999900

#define PASET       0x2B
#define CASET       0x2A
#define DISON       0x29
#define DISOFF      0x28
#define DEEPSLEEP   0xE5
#define RAMWR       0x2C
#define RAMCT       0x3C
#define RESET       0x01
#define DISINV      0x21
#define DISNOR      0x20
#define NOP         0x00
#define XMAX        640         // x axis max pixels
#define YMAX        480         // y axis max pixels
#define TRUE        1
#define SPAN        460         //this is for the slider bar
#define ZERO        100
#define PI          3.14159265

// Font sizes
#define SMALL 0
#define MEDIUM 1
#define LARGE 2
#define LARGE1 3
/********************************************************************/
#ifdef   TEST
extern unsigned char    screen[ SC_WIDTH * SC_HEIGHT ]    = { '.' };
#endif
/********************************************************************/
//unsigned char FONT6x8[97][8];
//unsigned char FONT8x8[97][8];
//unsigned char FONT8x16[97][8];
/************ here the XY reference locations for the buttons ************/
int righttbutinc=80;
int xref2=590;  //right hand side button x reference
int xref1=16;   //left hand side button x reference
int leftbutinc=76;  //y axis increment for the left hand side buttons
int yref1=70;
int xbutsize1=60;  // x size of button
int ybutsize1=50;  // y size of button
/************************************************************************/
unsigned char command;
unsigned char data1;
int DOWN;
int RIGHT;
int color;
unsigned int fill;
unsigned int radius;
int z;
int color1;
int color2;
//float slider;
//float vol;

/**************************** forward references *******************************/
void LCDSetXY(int x, int y);
void LCDClearScreen(void);
void LCDSetPixel(int x, int y, int color);
void LCDSetLine(int x1, int y1, int x2, int y2, int color);
void LCDSetRect(int x0, int y0, int x1, int y1, int fill, int color);
void LCDSetCircle(int x0, int y0, int radius, int color);
void LCDPutChar(char c, int x, int y, int size, int fcolor, int bcolor);
void LCDPutString (char *lcd_string, const char *font_style, unsigned char x, unsigned char y,
                   unsigned char fcolor, unsigned char bcolor);
void trigcircle (int xtc, int ytc, int radius, int color);
void show_screen( int xs, int width, int ys, int height );
void volume_slider (int volume);
void mute (unsigned int onoff);
//************************************************************************************

void Write_Command(unsigned char command) {
    CS=1; /* just to make sure */
    nRD = 1; /* make sure the RD is HIGH just to be sure */
    DC=0;
    nWR = 0;
    CS=0;
    //data_bus_write(command);
    DB=command;
    CS = 1;
    nWR = 1;
}
//;******************************************************************************
//void Write_Data(unsigned char data1) {
void Write_Data(int data1) {
    CS=1; /* just to make sure */
    nRD = 1;
    DC=1;
    nWR = 0;
    CS=0;
    //data_bus_write(data1);
    DB=data1;//write(data1);
    CS = 1;
    nWR = 1;
}
//====================================================
void Command_Write(unsigned char REG,unsigned char VALUE) {
    Write_Command(REG);
    Write_Data(VALUE);
}
//======================================================
void SendData(unsigned long color) {
    Write_Data((color)>>16);        //red
    Write_Data((color)>>8);         //green
    Write_Data(color);              //blue
}
/********************************************************************************/
// initialize the SSD1963 controller
void Init_SSD1963 (void) {
    Write_Command(0x01);            //Software Reset
    wait_ms(10);
    Write_Command(0x01);            //Software Reset
    wait_ms(10);
    Write_Command(0x01);            //Software Reset
    wait_ms(10);
    Command_Write(0xe0,0x01);       //START PLL
    wait_us(1);
    Command_Write(0xe0,0x03);    //LOCK PLL
    Write_Command(0xb0);         //SET LCD MODE  SET TFT 18Bits MODE
    Write_Data(0x0c);            //SET TFT MODE & hsync+Vsync+DEN MODE
    Write_Data(0x80);            //SET TFT MODE & hsync+Vsync+DEN MODE
    Write_Data(0x02);            //SET horizontal size=640-1 HightByte
    Write_Data(0x7f);            //SET horizontal size=640-1 LowByte
    Write_Data(0x01);            //SET vertical size=480-1 HightByte
    Write_Data(0xdf);            //SET vertical size=480-1 LowByte
    Write_Data(0x00);            //SET even/odd line RGB seq.=RGB
    Command_Write(0xf0,0x00);    //SET pixel data I/F format=8bit
    Command_Write(0x3a,0x60);    // SET R G B format = 6 6 6
    Write_Command(0xe6);         //SET PCLK freq=4.94MHz  ; pixel clock frequency
    Write_Data(0x02);
    Write_Data(0xff);
    Write_Data(0xff);
    Write_Command(0xb4);         //SET HBP,
    Write_Data(0x02);            //SET HSYNC Total=760
    Write_Data(0xf8);
    Write_Data(0x00);            //SET HBP 68
    Write_Data(0x44);
    Write_Data(0x0f);            //SET VBP 16=15+1
    Write_Data(0x00);            //SET Hsync pulse start position
    Write_Data(0x00);
    Write_Data(0x00);            //SET Hsync pulse subpixel start position
    Write_Command(0xb6);         //SET VBP,
    Write_Data(0x01);            //SET Vsync total
    Write_Data(0xf8);
    Write_Data(0x00);            //SET VBP=19
    Write_Data(0x13);
    Write_Data(0x07);            //SET Vsync pulse 8=7+1
    Write_Data(0x00);            //SET Vsync pulse start position
    Write_Data(0x00);
    Write_Command(0x2a);         //SET column address
    Write_Data(0x00);            //SET start column address=0
    Write_Data(0x00);
    Write_Data(0x02);            //SET end column address=639
    Write_Data(0x7f);
    Write_Command(0x2b);         //SET page address
    Write_Data(0x00);            //SET start page address=0
    Write_Data(0x00);
    Write_Data(0x01);            //SET end page address=479
    Write_Data(0xdf);
    Write_Command(0x29);         //SET display on
}


/********************************************************************************/
void WindowSet( int s_x,int e_x,int s_y,int e_y) {
    Write_Command(CASET);           //SET page address
    Write_Data((s_x)>>8);           //SET start page address=0
    Write_Data(s_x);
    Write_Data((e_x)>>8);           //SET end page address=639
    Write_Data(e_x);
    Write_Command(PASET);           //SET column address
    Write_Data((s_y)>>8);           //SET start column address=0
    Write_Data(s_y);
    Write_Data((e_y)>>8);           //SET end column address=479
    Write_Data(e_y);
}
/***************************************************************************/
/* this routine locates the screen pointer at position XY in the frame buffer */
void LCDSetXY(int x, int y) {
    Write_Command(CASET);           //SET page address
    Write_Data((x)>>8);             //SET start page address=0
    Write_Data(x);
    Write_Data((XMAX)>>8);          //SET end page address=XMAX
    Write_Data(XMAX);
    Write_Command(PASET);           //SET column address
    Write_Data((y)>>8);             //SET start column address=0
    Write_Data(y);
    Write_Data((YMAX)>>8);          //SET end column address=YMAX
    Write_Data(YMAX);
    Write_Command(RAMWR);           //ready to now start writing the data
    //when returnung to the caller
}


/********************************************************************************/
void clear_to_color(int color) {
    int m,n;
    WindowSet(0,640,0,480); // 0-640 wide by 0-480 high
    Write_Command(RAMWR);
    for (m=0;m<481;m++) {
        for (n=0;n<641;n++) {
            SendData(color);
        }
    }
}
/**********************************************************************************/
/********** this routine lights up a single pixel to a specific colour ***********/
void LCDSetPixel(int x,int y, int color) {
    Write_Command(CASET);           //SET page address
    Write_Data((x)>>8);             //SET start page address=0
    Write_Data(x);
    Write_Data((XMAX)>>8);          //SET end page address=XMAX
    Write_Data(XMAX);
    Write_Command(PASET);           //SET column address
    Write_Data((y)>>8);             //SET start column address=0
    Write_Data(y);
    Write_Data((YMAX)>>8);          //SET end column address=YMAX
    Write_Data(YMAX);
    Write_Command(RAMWR);           //ready to now start writing the data
    //when returnung to the caller
    SendData(color);
    Write_Command(NOP);
}
/*********************************************************************************/
/************ This routine draws a line between 2 points on the screen ***********/
void LCDSetLine(int x0, int y0, int x1,int y1, int color) {
    int dy = y1 - y0;
    int dx = x1 - x0;
    int stepx, stepy;
    if (dy < 0) {
        dy = -dy;
        stepy = -1;
    } else {
        stepy = 1;
    }
    if (dx < 0) {
        dx = -dx;
        stepx = -1;
    } else {
        stepx = 1;
    }
    dy <<= 1; // dy is now 2*dy
    dx <<= 1; // dx is now 2*dx
    LCDSetPixel(x0, y0, color);
    if (dx > dy) {
        int fraction = dy - (dx >> 1); // same as 2*dy - dx
        while (x0 != x1) {
            if (fraction >= 0) {
                y0 += stepy;
                fraction -= dx; // same as fraction -= 2*dx
            }
            x0 += stepx;
            fraction += dy; // same as fraction -= 2*dy
            LCDSetPixel(x0, y0, color);
        }
    } else {
        int fraction = dx - (dy >> 1);
        while (y0 != y1) {
            if (fraction >= 0) {
                x0 += stepx;
                fraction -= dy;
            }
            y0 += stepy;
            fraction += dx;
            LCDSetPixel(x0, y0, color);
        }
    }
}
/*******************************************************************************/
/************** draw a rectangle, filled or not filled *************************/
void LCDSetRect(int x0, int y0, int x1,int y1, int fill,  int color) {
    int xmin, xmax, ymin, ymax;
    int i;
// check if the rectangle is to be filled
    if (fill == TRUE) {
// calculate the min and max for x and y directions
        xmin = (x0 <= x1) ? x0 : x1;
        xmax = (x0 > x1) ? x0 : x1;
        ymin = (y0 <= y1) ? y0 : y1;
        ymax = (y0 > y1) ? y0 : y1;
        Write_Command(CASET);           //SET page address
        Write_Data((x0)>>8);            //SET start page address=0
        Write_Data(x0);
        Write_Data((x1)>>8);            //SET end page address=XMAX
        Write_Data(x1);
        Write_Command(PASET);           //SET column address
        Write_Data((y0)>>8);            //SET start column address=0
        Write_Data(y0);
        Write_Data((y1)>>8);            //SET end column address=YMAX
        Write_Data(y1);
        Write_Command(RAMWR);           //ready to now start writing the data
        for (i = 0; i < ((((xmax - xmin + 1) * (ymax - ymin + 1))) + 1); i++) {
            SendData(color);
        }
    } else {
        LCDSetLine(x0, y0, x1, y0, color);
        LCDSetLine(x0, y1, x1, y1, color);
        LCDSetLine(x0, y0, x0, y1, color);
        LCDSetLine(x1, y0, x1, y1, color);
    }
}
/***************************************************************************/
void LCDSetCircle(int x0, int y0, int radius, int color) {
    int f = 1 - radius;
    int ddF_x = 0;
    int ddF_y = -2 * radius;
    int x = 0;
    int y = radius;
    LCDSetPixel(x0, y0 + radius, color);
    LCDSetPixel(x0, y0 - radius, color);
    LCDSetPixel(x0 + radius, y0, color);
    LCDSetPixel(x0 - radius, y0, color);
    while (x < y) {
        if (f >= 0) {
            y--;
            ddF_y += 2;
            f += ddF_y;
        }
        x++;
        ddF_x += 2;
        f += ddF_x + 1;
        LCDSetPixel(x0 + x, y0 + y, color);
        LCDSetPixel(x0 - x, y0 + y, color);
        LCDSetPixel(x0 + x, y0 - y, color);
        LCDSetPixel(x0 - x, y0 - y, color);
        LCDSetPixel(x0 + y, y0 + x, color);
        LCDSetPixel(x0 - y, y0 + x, color);
        LCDSetPixel(x0 + y, y0 - x, color);
        LCDSetPixel(x0 - y, y0 - x, color);
    }
}
/***************************************************************************/
/***************** this is the mini-font version ***************************/
void LCDPutChar(char c, int x, int y, int size, int fColor, int bColor) {
    extern const unsigned char FONT6x8[97][8];
    extern const unsigned char FONT8x8[97][8];
    extern const unsigned char FONT8x16[97][16];
    extern const unsigned char FONT24x59[1][177];

    int i,j;
    unsigned int nCols;
    unsigned int nRows;
    unsigned int nBytes;
    unsigned char PixelRow;
    unsigned char Mask;
    unsigned int Word0;
    unsigned char *pFont;
    unsigned char *pChar;
    unsigned char *FontTable[] = {
        (unsigned char *)FONT6x8,
        (unsigned char *)FONT8x8,
        (unsigned char *)FONT8x16,
        (unsigned char *)FONT24x59  // I added this - it is just for the zero
    };
    // get pointer to the beginning of the selected font table
    pFont = (unsigned char *)FontTable[size];
    // get the nColumns, nRows and nBytes in the font table
    nCols = *pFont;
    nRows = *(pFont + 1);
    nBytes = *(pFont + 2);
    // get pointer to the last byte of the desired character - i.e. last byte in the row
    pChar = pFont + (nBytes * (c - 0x1F)) + nBytes - 1;

    WindowSet( x, (x + nRows - 1), y, (y + nCols - 1) ); // set window (drawing rectangle) to font size
    Write_Command(RAMWR);

    for ( i = (nRows - 1); i >= 0; i-- ) {
        PixelRow = *pChar--;
        Mask = 0x80;

        for ( j = 0; j < nCols; j++ ) {

            Word0    = (PixelRow & Mask) ? fColor : bColor;
            Mask    = Mask >> 1;

            Write_Data( (Word0 >> 16) & 0xFF );
            Write_Data( (Word0 >>  8) & 0xFF );
            Write_Data( (Word0      ) & 0xFF );
        }
    }
    Write_Command(NOP);// this terminates the Write Memory command
}
/*****************************************************************************/
/***************** this is the mini-font version ***************************/
void LCDPutStr(char *pString, int x, int y, int Size, int fColor, int bColor) {
// loop until null-terminator is seen
    while (*pString != 0x00) {
// draw the character
        LCDPutChar(*pString++, y, x, Size, fColor, bColor);
// advance the y position
        if (Size == 0)// small
            y = y + 6;
        else if (Size == 1)  //medium
            y = y + 8;
        else if (Size == 2) //large
            y = y + 16;
        else if (Size == 3)
            y = y + 24;  //large1
        if (y > 640) break; //bail out if it exceeds screen width
    }
}
/******************************** square button ***********************/
void sqbutton1(unsigned int x0, unsigned int y0, unsigned int fill, unsigned int color) {
    unsigned int xmin, xmax, ymin, ymax;
    int i;

// check if the rectangle is to be filled
    if (fill == TRUE) {
// best way to create a filled rectangle is to define a drawing box
// and loop two pixels at a time
// calculate the min and max for x and y directions
        xmin = (x0 <= (x0 + xbutsize1)) ? x0 : (x0 + xbutsize1);
        xmax = (x0 > (x0 + xbutsize1)) ? x0 : (x0 + xbutsize1);
        ymin = (y0 <= (y0+ybutsize1)) ? y0 : (y0+ybutsize1);
        ymax = (y0 > (y0+ybutsize1)) ? y0 : (y0+ybutsize1);
        Write_Command(CASET);           //SET page address
        Write_Data((x0)>>8);             //SET start page address=0
        Write_Data(x0);
        Write_Data((x0 + xbutsize1)>>8);          //SET end page address=XMAX
        Write_Data (x0 + xbutsize1);
        Write_Command(PASET);           //SET column address
        Write_Data((y0)>>8);             //SET start column address=0
        Write_Data(y0);
        Write_Data((y0+ybutsize1)>>8);          //SET end column address=YMAX
        Write_Data (y0+ybutsize1);
        Write_Command(RAMWR);           //ready to now start writing the data
        for (i = 0; i < ((((xmax - xmin + 1) * (ymax - ymin + 1))) + 1); i++) {
            SendData(color);
        }
    } else {

        LCDSetLine(x0, y0, (x0 + xbutsize1), y0, color);
        LCDSetLine(x0, (y0+ybutsize1), (x0 + xbutsize1), (y0+ybutsize1), color);
        LCDSetLine(x0, y0, x0, (y0+ybutsize1), color);
        LCDSetLine((x0 + xbutsize1), y0, (x0 + xbutsize1), (y0+ybutsize1), color);
    }
}

/**************************************** volume slider ******************************************/
void volume_slider(int volume) {  //was float
    int slider;
    int pos;
    pos = (volume*450)/222;
    slider = ZERO+pos; //((volume/255)*SPAN);
    LCDSetRect((ZERO-10),37,(SPAN+ZERO+10),60,1,BLACK); //erase the previous slider button position
    LCDSetRect(slider,40,(slider+10),60,1,WHITE);

}
/*************************************************************************************************/
/***************************** this is the main central button ******************************/
void big_button(void) {
    int z;
    for (z=117;z<122;z++) {
        LCDSetCircle(320,240,z,WHITE);
    }
    for (z=130;z<133;z++) {
        LCDSetCircle(320,240,z,WHITE);
    }
}
/*************************************************************************************************/
void volume_display_window(void) {
    LCDSetRect(223,198,418,283,0,WHITE);
}
/*************************************************************************************************/
void slider_bar(void) {

    LCDSetRect(100, 20,560,30,0,WHITE);//slider scale volume bar
    LCDPutStr("0ff   -82     -65      -48      -30      -12 -6  0  +7  +16",10,100,MEDIUM, WHITE,BLACK);//slider scale

}
/*************************************************************************************************/
void input_sel_window(void) {
    LCDSetRect(180,380,460,460,0,WHITE);// input select window
}
/*************************************************************************************************/
void input_buttons(void) {
   
    LCDSetCircle(xref2,(1*righttbutinc),25,WHITE);
    FontDrawString("CD",(xref2-75),(righttbutinc-20),WHITE,BLACK,&Calibri28);

    LCDSetCircle(xref2,(2*righttbutinc),25,WHITE);
    FontDrawString("Aux2",(xref2-108),((2*righttbutinc)-20),WHITE,BLACK,&Calibri28);

    LCDSetCircle(xref2,(3*righttbutinc),25,WHITE);
    FontDrawString("Aux1",(xref2-108),((3*righttbutinc)-20),WHITE,BLACK,&Calibri28);

    LCDSetCircle(xref2,(4*righttbutinc),25,WHITE);
    FontDrawString("Recdr",(xref2-122),((4*righttbutinc)-20),WHITE,BLACK,&Calibri28);

    LCDSetCircle(xref2,(5*righttbutinc),25,WHITE);
    FontDrawString("Phono",(xref2-132),((5*righttbutinc)-20),WHITE,BLACK,&Calibri28);
}

/*************************************************************************************************/
void phono_d(int onoff) {
    int circinc;
    if (onoff==0) {
        for (circinc=1;circinc<27;circinc++) {
            LCDSetCircle(xref2,(5*righttbutinc),circinc,BLACK);
        } //first erase the button

        LCDSetCircle(xref2,(5*righttbutinc),25,WHITE);
    } //now draw it in outline = OFF

    else {
        for (circinc=1;circinc<26;circinc++) {     //so onoff must have been TRUE
            LCDSetCircle(xref2,(5*righttbutinc),circinc,GREEN);    //it on so draw it in GREEN
        }
    }
}
/*************************************************************************************************/
void AUX1(int onoff) {
    int circinc;
    if (onoff==0) {
        for (circinc=1;circinc<27;circinc++) {
            LCDSetCircle(xref2,(3*righttbutinc),circinc,BLACK);
        } //first erase the button

        LCDSetCircle(xref2,(3*righttbutinc),25,WHITE);
    } //now draw it in outline = OFF

    else {
        for (circinc=1;circinc<26;circinc++) {     //so onoff must have been TRUE
            LCDSetCircle(xref2,(3*righttbutinc),circinc,GREEN);    //it on so draw it in GREEN
        }
    }
}
/*************************************************************************************************/
void AUX2(int onoff) {
    int circinc;
    if (onoff==0) {
        for (circinc=1;circinc<27;circinc++) {
            LCDSetCircle(xref2,(2*righttbutinc),circinc,BLACK);
        } //first erase the button

        LCDSetCircle(xref2,(2*righttbutinc),25,WHITE);
    } //now draw it in outline = OFF

    else {
        for (circinc=1;circinc<26;circinc++) {     //so onoff must have been TRUE
            LCDSetCircle(xref2,(2*righttbutinc),circinc,GREEN);    //it on so draw it in GREEN
        }
    }
}
/*************************************************************************************************/
void CD_d(int onoff) {
    int circinc;
    if (onoff==0) {
        for (circinc=1;circinc<27;circinc++) {
            LCDSetCircle(xref2,(1*righttbutinc),circinc,BLACK);
        } //first erase the button

        LCDSetCircle(xref2,(1*righttbutinc),25,WHITE);
    } //now draw it in outline = OFF

    else {
        for (circinc=1;circinc<26;circinc++) {     //so onoff must have been TRUE
            LCDSetCircle(xref2,(1*righttbutinc),circinc,GREEN);    //it on so draw it in GREEN
        }
    }
}
/*************************************************************************************************/
void Recorder_d(int onoff) {
    int circinc;
    if (onoff==0) {
        for (circinc=1;circinc<27;circinc++) {
            LCDSetCircle(xref2,(4*righttbutinc),circinc,BLACK);
        } //first erase the button

        LCDSetCircle(xref2,(4*righttbutinc),25,WHITE);
    } //now draw it in outline = OFF

    else {
        for (circinc=1;circinc<26;circinc++) {     //so onoff must have been TRUE
            LCDSetCircle(xref2,(4*righttbutinc),circinc,GREEN);    //it on so draw it in GREEN
        }
    }
}

/*************************************************************************************************/
void Control_buttons(void) {

    sqbutton1(xref1,80,0,WHITE); //mute
    FontDrawString("Mute",82,87,WHITE,BLACK,&Calibri28);

    sqbutton1(xref1, 196,0,WHITE); //Rec
    FontDrawString("Rec",82,197,WHITE,BLACK,&Calibri28); //gap is 66

    //sqbutton1(xref1,202,0,WHITE); //stdby
    //FontDrawString("Stdby",82,203,WHITE,BLACK,&Calibri28);

    sqbutton1(xref1, 312,0,WHITE);//power amp
    FontDrawString("Amp",82,313,WHITE,BLACK,&Calibri28);

    //sqbutton1(xref1,400,0,RED);  //this is the IR indicator
    //FontDrawString("IR",82,400,WHITE,BLACK,&Calibri28);

}
/*************************************************************************************************/
void mute(unsigned int onoff) {     //this is the bottom button
    if (onoff==0) {
        sqbutton1(xref1,80,1,BLACK); //first erase the button
        sqbutton1(xref1,80,0,WHITE);
    } //now redraw it
    else {
        sqbutton1(16,80,1,WHITE);
    }
}
/*************************************************************************************************/
void record(unsigned int onoff) { //this is the second from bottom button
    if (onoff==0) {
        sqbutton1(xref1,196,1,BLACK); //first erase the button
        sqbutton1(16, 196,0,WHITE);
    } //now redraw it
    else {
        sqbutton1(16,196,1,WHITE);
    }
}
/*************************************************************************************************/
void stdby(unsigned int onoff) { //this is the 3rd from bottom button
    if (onoff==0) {
        sqbutton1(xref1,202,1,BLACK); //first erase the button
        sqbutton1(xref1, 202,0,WHITE);
    } //now redraw it
    else {
        sqbutton1(xref1,202,1,WHITE);
    }
}
/*************************************************************************************************/
void pwramp(unsigned int onoff) { //this is the top  lefthand side button
    if (onoff==0) {
        sqbutton1(xref1, 312,1,BLACK); //first erase the button
        sqbutton1(xref1,312,0,WHITE);
    } //now redraw it
    else {
        sqbutton1(xref1, 312,1,WHITE);
    }
}
/*************************************************************************************************/
void infra(unsigned int onoff) { //this is the top  lefthand side button
    if (onoff==0) {
        sqbutton1(xref1, 400,1,BLACK); //first erase the button
        sqbutton1(xref1,400,0,RED);
    } //now redraw it
    else {
        sqbutton1(xref1, 400,1,RED);
    }
}
/*************************************************************************************************/
void trigcircle (int xtc, int ytc, int radius, int color) {

    double circ;
    double cosnum;
    double sinum;
    for (circ=0;circ<=volume;circ++) {
        sinum=sin(circ)*radius;
        cosnum=cos(circ)*radius;
        LCDSetLine(xtc,ytc,(sinum+xtc),(cosnum+ytc),color);
    }
}

/**************************************************************************************/

void clear_input_select(void) {

    int circinc;
    for (circinc=1;circinc<24;circinc++) {

        LCDSetCircle(xref2,(5*righttbutinc),circinc,BLACK); //phono
        LCDSetCircle(xref2,(3*righttbutinc),circinc,BLACK); //aux1
        LCDSetCircle(xref2,(2*righttbutinc),circinc,BLACK); //aux2
        LCDSetCircle(xref2,(1*righttbutinc),circinc,BLACK); //CD
        LCDSetCircle(xref2,(4*righttbutinc),circinc,BLACK); //recorder
    }
}