/********************************* RC5 control codes ******************************/
// The Philips RC5 coce consists of 14 bits delivered in bi-phase Manchester encoding from
// an IR LED on the remote.  This is picked up by a detector (e.g. a Vishay TSOP3741) which
// outputs the demodulated bit stream as follows:-
// First 2 bits are start bits - allow the detector AGC to stabilize and trigger decoding process
// Third bit is the toggle bit - it remains at the same logic level as long as a key is depressed
// and will change to the alternate state when the key is un/re-depressed or when a different
// key is depressed
// Bits 4~8 are the address bits and determine which piece of equipment is being controlled
// Bits 9~14 are the command bits
// As long as a key is depressed, the 14 bits will be sent by the remote controller in sequential
// blocks with a 120ms delay between subsequent block transmissions
//  See http://en.wikipedia.org/wiki/RC-5 for the codes

// 0-9 NUMERIC KEYS 0 - 9 - not used in this implementation

// unused commands and addresses have been commented out - simply un-comment them to use them 
// but note that if you do this, you will have to decode them, otherwise they will just fall through
// and be ignored by the decoder.  Only the ones un-commented out below are active in V1.0
// Note you will also need to write the associated command processor functions 

#define STANDBY 378      // toggle  power ON and OFF
#define MUTE 442         // toggle output signal on and off
#define VUP 464         
#define VDOWN 432
#define SELECT_R 480      // rotates input through inputs - must depress and then release each time
#define SELECT_L 272      // rotates input through inputs - must depress and then release each time
#define PREAMP 479          // this is the system code identifying an Apple Remote












