#include "mbed.h"

BusOut LED_Disp(p7,p11,p9,p8,p5,p6,p10,p12);



DigitalOut col1 (p26);       // pin 4 on keypad
DigitalOut col2 (p28);       // pin 2
DigitalOut col3 (p24);       // pin 6 

DigitalIn row1 (p27);        // pin 3
DigitalIn row2 (p22);        // pin 8
DigitalIn row3 (p23);        // pin 7
DigitalIn row4 (p25);        // pin 5

char keypad(void);           // declare keypad function will return character pressed
void DisplayNumber(int);     // Declare functio  to display number on seven seg

int main()
{
    char kp_val = ' ';       // character that changes when the key is pressed, has initial value
    
    LED_Disp = 0xFF;
    
    while(1)
    {
        kp_val = keypad();
                             
        if(kp_val!= ' ')        // poll keypad and check if any value is pressed
        {
            if(kp_val=='*') LED_Disp = ~0x63;
            if(kp_val=='#') LED_Disp = ~0x5C;
            
            if(kp_val>='0' && kp_val<='9')
                DisplayNumber(kp_val-48);       // subtract 48 to change ASCII into number
                
            kp_val=' ';                         // reset keypad_char
        }
        wait(0.1);
    }
}


char keypad(void)
{
    col1=1;
    col2=0;
    col3=0;
    
    if(row1==1)
    {
        while(row1==1){}
        
        col1=0;
        col2=0;
        col3=0;
        return('1');
    }
    else if(row2==1)
    {
        while (row2==1){}
        
        col1=0;
        col2=0;
        col3=0;
        return('4');
    }
    else if(row3==1)
    {
        while (row3==1){}
        
        col1=0;
        col2=0;
        col3=0;
        return('7');
    }
    else if(row4==1)
    {
        while(row4==1){}
        
        col1=0;
        col2=0;
        col3=0;
        return('*');
    }
    
    col1=0;
    col2=1;
    col3=0;
    
    if(row1==1)
    {
        while(row1==1){}
        
        col1=0;
        col2=0;
        col3=0;
        return('2');
    }
    else if(row2==1)
    {
        while (row2==1){}
        
        col1=0;
        col2=0;
        col3=0;
        return('5');
    }
    else if(row3==1)
    {
        while (row3==1){}
        
        col1=0;
        col2=0;
        col3=0;
        return('8');
    }
    else if(row4==1)
    {
        while(row4==1){}
        
        col1=0;
        col2=0;
        col3=0;
        return('0');
    }
    
    col1=0;
    col2=0;
    col3=1;
    
    if(row1==1)
    {
        while(row1==1){}
        
        col1=0;
        col2=0;
        col3=0;
        return('3');
    }
    else if(row2==1)
    {
        while (row2==1){}
        
        col1=0;
        col2=0;
        col3=0;
        return('6');
    }
    else if(row3==1)
    {
        while (row3==1){}
        
        col1=0;
        col2=0;
        col3=0;
        return('9');
    }
    else if (row4==1)
    {
        while(row4==1){}
        
        col1=0;
        col2=0;
        col3=0;
        return('#');
    }
    
    col1=0;
    col2=0;
    col3=0;
    
    return(' ');
}

void DisplayNumber(int num)
{
     switch(num)
     {
        case 0:
            LED_Disp = ~0x3F;
            break;
        case 1:
            LED_Disp = ~0x06;
            break;
        case 2:
            LED_Disp = ~0x5B;
            break;
        case 3:
            LED_Disp = ~0x4F;
            break;
        case 4:
            LED_Disp = ~0x66;
            break;
        case 5:
            LED_Disp = ~0x6D;
            break;
        case 6:
            LED_Disp = ~0x7D;
            break; 
        case 7:
            LED_Disp = ~0x07;
            break;
        case 8:
            LED_Disp = ~0x7F;
            break;
        case 9:
            LED_Disp = ~0x67;
            break; 
        case 10: //#
            LED_Disp = ~0x5c;
            break;
        case 11:   //*
            LED_Disp = ~0x63;
            break;
    }
}
    
