#include "mbed.h"

Serial pc(USBTX, USBRX);    //create serail comms object
 
BusOut LED_Disp(p7,p11,p9,p8,p5,p6,p10,p12);

//digital inputs
DigitalIn slide_button(p17);    // set p17 high if buttons controls 7 seg
DigitalIn slide_putty(p18); 
 
// interrupts in
InterruptIn button_up(p14);             //assign interrupt to 14 and 15
InterruptIn button_down(p15);
 
 // digital outputs
 DigitalOut test_blink(LED1);
 
 // general global variable
int counter1;                 //global counter value
 
void Increment_up(void);        //ISR to be assigned to button_up interrupt
void Increment_down(void);      
void DisplayNumber(int);        //function to display number on seven segment
 
int main()
{
    int putty_char;       // charqacter read from putty as integer (ASCII)
    
    button_up.rise(&Increment_up);     //attach adress of ISR to interrupt
    button_down.rise(&Increment_down);
    
    counter1 = 0;                    // Initialise global counter variable
    putty_char = '0';                //initialize local putty character variable
    DisplayNumber(0);                // on start up the display is 0 
    
    while(1)
    {
        if(slide_putty == 1)
        {
            if(pc.readable()==1)      // check for character on serial port
            {
                putty_char = pc.getc();   // read character from putty
                
                pc.putc(putty_char);      // echo character back to putty
                
                // check if within number range
                if (putty_char >= '0' && putty_char <= '9')
                {
                    test_blink = 1;      // test sequence
                    wait(0.2);
                    test_blink = 0;
                    
                    DisplayNumber (putty_char-48);    // convert ASKII character to number
                }
            }
        }
    }
}
            
 
// Interrupt function to increment counter
void Increment_up(void)
{
    if(slide_putty)       // Return to main if slide switch is in putty position
        return;
    
    counter1++;    //increment counter
    
    if(counter1 <0)   // check for min value
        counter1 = 0;
        
    if(counter1 >9)    //check for max value
        counter1 = 9;
        
    DisplayNumber(counter1);        //display counter1 number on seven segment
    wait(0.3);                         //debounce timer
    
}
 
void Increment_down(void)
{
    if(slide_putty)
        return;
    
    counter1--;
    
    if(counter1 <0)   
        counter1 = 0;
        
    if(counter1 >9)    
        counter1 = 9;
        
    DisplayNumber(counter1);        
    wait(0.3); 
}
 
//funtion to display counter1 on seven segment
void DisplayNumber(int num)
{
    switch(num)
    {
        case 0:
            LED_Disp = ~0x3F;
            break;
        case 1:
            LED_Disp = ~0x06;
            break;
        case 2:
            LED_Disp = ~0x5B;
            break;
        case 3:
            LED_Disp = ~0x4F;
            break;
        case 4:
            LED_Disp = ~0x66;
            break;
        case 5:
            LED_Disp = ~0x6D;
            break;
        case 6:
            LED_Disp = ~0x7D;
            break; 
        case 7:
            LED_Disp = ~0x07;
            break;
        case 8:
            LED_Disp = ~0x7F;
            break;
        case 9:
            LED_Disp = ~0x67;
            break; 
    }
}