#include "mbed.h"
#include <string>
#include <iostream>
using namespace std; 

BusOut LED_Disp(p7,p11,p9,p8,p5,p6,p10,p12);

InterruptIn button1(p14);
InterruptIn button2(p15);
volatile bool button1Up = true;
volatile bool button2Up = true;
volatile unsigned int counter = 0;

void DisplayNumber(int num, BusOut &Bus)
{
    num = num % 10;

    switch(num)
    {
        case 0:
            LED_Disp = ~0x3F;
            break;
        case 1:
            LED_Disp = ~0x06;
            break;
        case 2:
            LED_Disp = ~0x5B;
            break;
        case 3:
            LED_Disp = ~0x4F;
            break;
        case 4:
            LED_Disp = ~0x66;
            break;
        case 5:
            LED_Disp = ~0x6D;
            break;
        case 6:
            LED_Disp = ~0x7D;
            break; 
        case 7:
            LED_Disp = ~0x07;
            break;
        case 8:
            LED_Disp = ~0x7F;
            break;
        case 9:
            LED_Disp = ~0x67;
            break; 
    }
}

void up1(){
    button1Up = true;
}

void down1(){
    button1Up = false;
}

void up2(){
    button2Up = true;
}

void down2(){
    button2Up = false;
}

int main()
{
    button1.rise(&down1);
    button1.fall(&up1);
    button2.rise(&down2);
    button2.fall(&up2);
          
    while(1){
        LED_Disp = -1;
        while(!button1Up)
        {
            DisplayNumber(counter, LED_Disp);
            counter++;
            
        }
        while(!button2Up)
        {
            DisplayNumber(counter, LED_Disp);
            counter--;
            
        }
    }
    
    
}
            
                
    


    
        
                
            
            
        