#include "mbed.h"
BusOut LED_Disp (p7,p11,p9,p8,p5,p6,p10,p12);
InterruptIn plusbutton(p14); 
InterruptIn minusbutton(p15);
DigitalOut led1 (LED1);
DigitalOut led2 (LED2);
 

void DisplayNumber(int);
void flip()
{
    LED_Disp = !LED_Disp;    // toggle state of LED
}

int main()
{
    plusbutton.rise(&flip);
    int i = 0;
    while(1)
    {
        if (plusbutton == 1)
        {
            led1 = 1;
            wait(0.5);
            i++;
            while(plusbutton)
            {
                DisplayNumber(i);
            }
        }
        
        if (minusbutton == 1)
        {
            led2 = 1;
            wait(0.5);
            i--;
            while(minusbutton)
            {
                DisplayNumber(i);
            }
        }
    }
}
     

void DisplayNumber(int num)
{
    switch(num)    
    {
        case 0: 
        LED_Disp = ~0x3F;             // bit pattern for 0 
        break; 
            
        case 1:
        LED_Disp = ~0x06;
        break;
        
        case 2:
        LED_Disp = ~0x5B;
        break;  
        
        case 3:
        LED_Disp = ~0x4F;
        break;
        
        case 4:
        LED_Disp = ~0x66;
        break;
        
        case 5:
        LED_Disp = ~0x6D;
        break;
        
        case 6:
        LED_Disp = ~0x7C;
        break;
        
        case 7:
        LED_Disp = ~0x07;
        break;
        
        case 8:
        LED_Disp = ~0x7F;
        break; 
        
        case 9:
        LED_Disp = ~0x67;
        break;   
    }
}
    
