// Lab 9 Task 2-4

#include "mbed.h"
#include "C12832_lcd.h"
#include "LM75B.h"


//  C12832 LCD display library by Peter Drescher 
//  https://os.mbed.com/users/dreschpe/code/C12832_lcd/
//
//  LM75B temperature sensor library by Neil Thiessen
//  https://os.mbed.com/users/neilt6/code/LM75B/ 


// **** Global Variables *****
C12832_LCD lcd;           // Create LCD display object  128 x 32 
LM75B t_sensor(p28,p27);  // Create temp sensor object Addr 0x90

DigitalOut led_1(LED1);   // Onboard LED used for debugging
AnalogIn wheel_1(p19);    // Pot 1 on pin 19 (range 0.0 to 1.0)

DigitalIn pb_centre(p14);   // joystick centre push button

Serial pc(USBTX,USBRX);   // Serial comms object

int state;  // Store program state - Display temp in 1=Celsius 2=Fahrenheit

char welcome_str[] ="Lab Number 9";   // Welcome string


// ***** Function prototypes *****
// Just specify the data types that are used by each function
//
void pulse_LCD(DigitalOut, int);  // Pulse the LED a number of times



int main() 
{
    // local variables
    float temp_c = 0;  // Initialse variable for current temperature in Celsius
    float temp_f = 0;  // Current temperature in Fahrenheit
    
    int serial_char = 0;  // Character buffer from serial port
    
    // Initialise global variables
    state = 1;   // Display temperature in Celsius
    
  
    
    if (t_sensor.open()) // Initialise temp sensor by calling .open()
    {
        //pc.printf("LM75B Device detected!\n"); // Debug message
    }
    else
    {
        //pc.error("LM75B Device not detected!\n"); // Debug message
    }
    
    while(1) 
    {
        if(pb_centre==1) // Center push button pressed
        {
            // pulse_LCD(led_1);  // Pulse LED 1 to help debug
            
            if(state==1) // Toggle program state from (1 to 2) or (2 to 1)
                state=2;  
            else if(state==2) 
                state=1;
            
            while(pb_centre) // loop while centr push button is held down
            {}
        }
        
        
        // Check if data waiting in serial port buffer
        if(pc.readable())
        {
            serial_char = pc.getc();  // Display chararacter on 7 segment
                
            if(serial_char=='C' || serial_char=='c')
            {               
                pc.printf("Temp = %.2f C \n", temp_c ); 
            }
            else if(serial_char=='F' || serial_char=='f')
            {               
                pc.printf("Temp = %.2f F \n", temp_f ); 
            }
            else if(serial_char>='0' && serial_char<='9')
            {               
                int pulse_cnt = serial_char-48; // Convert ASCII char to number
                
                pulse_LCD(led_1, pulse_cnt);  // Pulse the LED x times
            }
        }
        
        
        
        
       
        
        lcd.cls();   // Clear the LCD Display
        
        lcd.locate(35,1);  //  Locate cursor to text row 1 on LCD (col, row)       
        lcd.printf("Lab Number: 9");  //
        
        lcd.locate(35,10);  //  Locate cursor to test row 2 on LCD (col, row)
             
        // Read temperature from sensor in Celsius
        temp_c = t_sensor.temp(); 
        
        temp_f = (temp_c * 1.8)+32;  // Calculate Fahrenheit
        
        if(state==1)
        {
            lcd.printf("Temp = %.2f C ", temp_c ); 
        }
        else if(state==2)
        {
            lcd.printf("Temp = %.2f F ", temp_f ); 
        }
        
        
        
        wait(0.1);  // Pause
        
    }
}


// Pulse the specified LED on and off a fixed number of times (count)
//
void pulse_LCD(DigitalOut led_pin, int count)
{
    for( int i = 0; i< count; i++)
    {
        led_pin = 1;
        wait(0.2);
        led_pin = 0;
        wait(0.2);
    }
}
