#include "mbed.h"

// Global variables

int mode;  // mode=1 on startup 
           // mode=2 for keypad
           // mode=3 for serial

//Assign 8 pins digital bus object LED_Disp
BusOut LED_Disp(p7,p11,p9,p8,p5,p6,p10,p12); 

// Pin assignment for 4x3 or 12 key Hex keypad
// Looking at keyboard front, the left most pin is pin1 
// keypad pin numbers
//   pin 1 = not connected
//   pin 2 = col 2
//   pin 3 = row 1
//   pin 4 = col 1
//   pin 5 = row 4
//   pin 6 = col 3
//   pin 7 = row 3
//   pin 8 = row 2
//   pin 9 = not connected
//

Serial pc(USBTX, USBRX); // Create serial comms object

// mbed pin assignment for keypad
DigitalIn row1(p27);
DigitalIn row2(p22);
DigitalIn row3(p23);
DigitalIn row4(p25);
DigitalOut col1(p26);
DigitalOut col2(p28);
DigitalOut col3(p24);

DigitalOut debug_led (LED1);  // Debug LED for flashing

Serial s_port(USBTX, USBRX);


// Interrupts
InterruptIn cal_button(p14); // Assign interrupt input object to pin 14

// Prototypes for ISRs
void cal_isr(void);  // Declare ISR for cal button on p14
 
// Function Prototypes
char Keypad(void); // Declare Keypad function will return character pressed
void DisplayChar(char);  // Declare function to display character on 7 segment
void Flash_char(char);  // Declare function to flash character on 7 segment 





// ************ MAIN ************
int main() 
{
    mode=1;  // On startup set mode=1
    
    cal_button.rise(&cal_isr); //Attach address of ISR to interrupt
    
    int counter=0;  // General program or character counter
        
    int kp_char = ' ';   // Character read from keypad (ASCII)
    
    
    while(1) 
    {
        if(mode==1)  // Check if startup mode is set
        {
            if(counter>=5)  
                counter=0;  // Reset counter
            
            if (counter==0) 
                Flash_char('H'); // Flash 'H' 
            else if (counter==1) 
                Flash_char('E'); // Flash 'E'
            else if (counter==2) 
                Flash_char('L'); // Flash 'L'
            else if (counter==3) 
                Flash_char('L'); // Flash 'L' 
            else if (counter==4) 
                Flash_char('0'); // Flash '0'

            
            counter++;  //Increment message counter
        }
        
        
       
        else if(mode==2)  // Check if keypad mode
        {
            
            counter=0;  // reset message counter
            
            kp_char = Keypad(); // Poll keypad and check if key pressed
            
            if(kp_char!=' ')  // If keypad char == ' ' then no key pressed
            {
                
                if(kp_char>='0' && kp_char<='9')
                {
                    DisplayChar(kp_char);  // Display character on 7 segment
                    pc.printf("%c\n\r",kp_char);   // Send character to serial port

                }
            }
         }   
                
                
        else if(mode==3)  // Check if serial mode
        {            
            kp_char = Keypad(); // Poll keypad and check if key pressed
            
            if(s_port.readable())
            {

                kp_char = s_port.getc();  // Display character on 7 segment
                
 
                if(kp_char>='0' && kp_char<='9')
                {
                    DisplayChar(kp_char);  // Display character on 7 segment
                    pc.printf("%c\n\r",kp_char);   // Send character to serial port

                }               
                                               
            }
        }
    }
}


// ISR function called by interrupt on push button
void cal_isr(void)
{
    // Switch modes
    if(mode==1)
    {
        mode=2; // Set mode to keypad mode
        DisplayChar(' ');  // Turn off all segments
        //wait(0.1);  //Debounce timer
    }
    else if(mode==2)
    {
        mode=3;    // Set mode to serial mode
        DisplayChar(' ');  // Turn off all segments
        //wait(0.1);  //Debounce timer
    }
    else if(mode==3)
    {
        mode=1;    // Set mode to startup mode
        DisplayChar(' ');  // Turn off all segments
        //wait(0.1);  //Debounce timer
    }
}


// Function to flash character on 7 segment 
void Flash_char(char new_char)  
{
    DisplayChar(' ');  // Turn off all segments
    wait(0.1);  
    DisplayChar(new_char);  // Display chararacter on 7 segment
    wait(0.6);   
}
    
    
    

char Keypad(void)
{   
    
    // Test for any key pressed on column 1
    // Pull col1 high and keep columns 2 and 3 low
    col1=1;
    col2=0;
    col3=0;

    
    if(row1==1) // While col1 is high, if row 1 is high then '1' is pressed
    {
        while(row1==1){}  // Loop while button is pressed down
        // On releasing the button return the button character and exit function
        
        // Pull all colums low to end
        col1=0;
        col2=0;
        col3=0;   
        return('1');  // return character 1 and exit function
    }
    else if(row2==1) // While col1 is high, if row 2 is high then '4' is pressed
    {
        while(row2==1){}
        // Pull all colums low to end
        col1=0;
        col2=0;
        col3=0;   
        return('4');  // Exit function and return
    }
    else if(row3==1) // While col1 is high, if row 3 is high then '7' is pressed
    {
        while(row3==1){}
        // Pull all colums low to end
        col1=0;
        col2=0;
        col3=0;   
        return('7');
    }
    else if(row4==1) // While col1 is high, if row 4 is high then '*' is pressed
    {
        while(row4==1){}
        // Pull all colums low to end
        col1=0;
        col2=0;
        col3=0;   
        return('*');
    }
    
    
    
    // Test for any key pressed on column 2
    // Pull col2 high and keep columns 1 and 3 low
    col1=0;
    col2=1;
    col3=0;   
    
    if(row1==1) // While col2 is high, if row 1 is high then '2' is pressed
    {
        while(row1==1){}  // Loop 
        // Pull all colums low to end
        col1=0;
        col2=0;
        col3=0;   
        return('2');
    }
    else if(row2==1) // While col2 is high, if row 2 is high then '5' is pressed
    {
        while(row2==1){}  // Loop
        // Pull all colums low to end
        col1=0;
        col2=0;
        col3=0;   
        return('5');
    }
    else if(row3==1) // While col2 is high, if row 3 is high then '8' is pressed
    {
        while(row3==1){}  // Loop
        // Pull all colums low to end
        col1=0;
        col2=0;
        col3=0;   
        return('8');
    }
    else if(row4==1) // While col2 is high, if row 4 is high then '0' is pressed
    {
        while(row4==1){}  // Loop
        // Pull all colums low to end
        col1=0;
        col2=0;
        col3=0;   
        return('0');
    }
    
    
    // Test for any key pressed on column 3
    // Pull col3 high and keep columns 1 and 2 low
    col1=0;
    col2=0;
    col3=1;   
    
    if(row1==1) // While col3 is high, if row 1 is high then '3' is pressed
    {
        while(row1==1){}  // Loop
        // Pull all colums low to end
        col1=0;
        col2=0;
        col3=0;   
        return('3');
    }
    else if(row2==1) // While col3 is high, if row 2 is high then '6' is pressed
    {
        while(row2==1){}  // Loop
        // Pull all colums low to end
        col1=0;
        col2=0;
        col3=0;   
        return('6');
    }
    else if(row3==1) // While col3 is high, if row 3 is high then '9' is pressed
    {
        while(row3==1){}  // Loop
        // Pull all colums low to end
        col1=0;
        col2=0;
        col3=0;   
        return('9');
    }
    else if(row4==1) // While col3 is high, if row 4 is high then '#' is pressed
    {
        while(row4==1){}  // Loop
        // Pull all colums low to end
        col1=0;
        col2=0;
        col3=0;   
        return('#');
    }
    
    // Pull all colums low to end
    col1=0;
    col2=0;
    col3=0;   
    
    
    // ***** Return value ******
    return(' ');  // If no key is pressed then return ' ' a space character.

} // Keypad Function End




// Function to display a character on 7 segment LED display
void DisplayChar(char disp_char)
{
    switch(disp_char)
    {
        case '0':
            LED_Disp = ~0x3F; // Bit pattern for '0' = ~0xC0
            break;        
        case '1':
            LED_Disp = ~0x06; // Bit pattern for '1' = ~0xF9
            break;
        case '2':
            LED_Disp = ~0x5B; // Bit pattern for '2' = ~0xA4
            break;
        case '3':
            LED_Disp = ~0x4F; // Bit pattern for '3' = ~0xB0
            break;
        case '4':
            LED_Disp = ~0x66; // Bit pattern for '4' = ~0x99
            break;
        case '5':
            LED_Disp = ~0x6D; // Bit pattern for '5' = ~0x92
            break;
        case '6':
            LED_Disp = ~0x7D; // Bit pattern for '6' = ~0x82
            break;
        case '7':
            LED_Disp = ~0x07; // Bit pattern for '7' = ~0xF8
            break;
        case '8':
            LED_Disp = ~0x7F; // Bit pattern for '8' = ~0x80
            break;
        case '9':
            LED_Disp = ~0x67; // Bit pattern for '9' = ~0x98
            break;
        case 'A':
            LED_Disp = ~0x77; // Bit pattern for 'A' = ~0x77
            break;
        case 'B':
            LED_Disp = ~0x7F; // Bit pattern for 'B' = ~0x7F
            break;
        case 'C':
            LED_Disp = ~0x39; // Bit pattern for 'C' = ~0x39
            break;
        case 'D':
            LED_Disp = ~0x3F; // Bit pattern for 'D' = ~0x3F
            break;
        case 'E':
            LED_Disp = ~0x79; // Bit pattern for 'E' = ~0x79
            break;
        case 'F':
            LED_Disp = ~0x71; // Bit pattern for 'F' = ~0x71
            break;
        case 'G':
            LED_Disp = ~0x7D; // Bit pattern for 'G' = ~0x7D
            break;
        case 'H':    // Display character 'H' = ~0x77
            LED_Disp = ~0x76; 
            break;
        case 'I':    // Display character 'I' = ~0x06
            LED_Disp = ~0x06; 
            break;
        case 'L':    // Display character 'L' = ~0x38
            LED_Disp = ~0x38; 
            break;
        case 'S':
            LED_Disp = ~0x6D; // Bit pattern for 'S' = ~0x92
            break;
        case ' ':    // Display character ' ' = ~0x00
            LED_Disp = ~0x00; 
            break;
        case '*':     // keypad '*' character
            LED_Disp = ~0x63; // Top 4 segments 
            break;
        case '#':    // keypad '#' character
            LED_Disp = ~0x5C; // Bottom 4 segments 
            break;
   }
}
