#include "mbed.h"

BusOut LED_Disp(p7,p11,p9,p8,p5,p6,p10,p12);

InterruptIn button_up(p14);             //assign interrupt to 14 and 15
InterruptIn button_down(p17);

int counter1;                 //global counter value

void Increment_up(void);        //ISR to be assigned to button_up interrupt
void Increment_down(void);      
void DisplayNumber(int);        //function to display number on seven segment

int main()
{
    button_up.rise(&Increment_up);     //attach adress of ISR to interrupt
    button_down.rise(&Increment_down);
    
    while(1)
    {
        wait(0.2);
    }
}

// Interrupt function to increment counter
void Increment_up(void)
{
    counter1++;    //increment counter
    
    if(counter1 <0)   // check for min value
        counter1 = 0;
        
    if(counter1 >9)    //check for max value
        counter1 = 9;
        
    DisplayNumber(counter1);        //display counter1 number on seven segment
    wait(0.3);                         //debounce timer
    
}

void Increment_down(void)
{
    counter1--;
    if(counter1 <0)   
        counter1 = 0;
        
    if(counter1 >9)    
        counter1 = 9;
        
    DisplayNumber(counter1);        
    wait(0.3); 
}

//funtion to display counter1 on seven segment
void DisplayNumber(int num)
{
    switch(num)
    {
        case 0:
            LED_Disp = ~0x3F;
            break;
        case 1:
            LED_Disp = ~0x06;
            break;
        case 2:
            LED_Disp = ~0x5B;
            break;
        case 3:
            LED_Disp = ~0x4F;
            break;
        case 4:
            LED_Disp = ~0x66;
            break;
        case 5:
            LED_Disp = ~0x6D;
            break;
        case 6:
            LED_Disp = ~0x7D;
            break; 
        case 7:
            LED_Disp = ~0x07;
            break;
        case 8:
            LED_Disp = ~0x7F;
            break;
        case 9:
            LED_Disp = ~0x67;
            break; 
    }
}
         
                        
    
    

