"'use strict';\n"
"\n"
"var file;\n"
"var xhr;\n"
"\n"
"function logUpload(text)\n"
"{\n"
"    document.getElementById('uploadresult').textContent = text;\n"
"}\n"
"function xhrUploadResponse()\n"
"{\n"
"    document.getElementById('restartbutton').disabled = false;\n"
"    var topics = xhr.responseText.split('\\f');\n"
"    logUpload(topics[0]);\n"
"    if (topics.length > 1) document.getElementById('list').textContent = topics[1];\n"
"}\n"
"function xhrUploadOnLoad()\n"
"{\n"
"    if (xhr.status == 200) xhrUploadResponse();\n"
"    else                   logUpload('Upload failed');\n"
"}\n"
"function xhrUploadOnError()\n"
"{\n"
"    logUpload('Upload error');\n"
"}\n"
"function xhrUploadProgress(e)\n"
"{\n"
"    logUpload('Uploading ' + e.total + ' bytes ' + '(' + Math.round(e.loaded/e.total * 100) + '%)...\\r\\n');\n"
"}\n"
"function xhrUploadComplete(e)\n"
"{\n"
"    logUpload('Saving ' + e.loaded  + ' bytes...');\n"
"}\n"
"function xhrUploadStart()\n"
"{\n"
"    document.getElementById('restartbutton').disabled = true;\n"
"    logUpload('Upload starting...');\n"
"    \n"
"    xhr = new XMLHttpRequest();\n"
"\n"
"    xhr.onload  = xhrUploadOnLoad;\n"
"    xhr.onerror = xhrUploadOnError;\n"
"    xhr.upload.onprogress = xhrUploadProgress;\n"
"    xhr.upload.onload     = xhrUploadComplete;\n"
"\n"
"    xhr.open('POST', '/firmware-ajax'); //Defaults to async=true\n"
"    xhr.send(file);\n"
"}\n"
"function startUpload()\n"
"{\n"
"    var fileInput = document.getElementById('fileInput');\n"
"\n"
"    if (fileInput.files.length == 0)\n"
"    {\n"
"        logUpload('Please choose a file');\n"
"        return;\n"
"    }\n"
"\n"
"    if (fileInput.files.length > 1)\n"
"    {\n"
"        logUpload('Please choose just one file');\n"
"        return;\n"
"    }\n"
"    \n"
"    file = fileInput.files[0];\n"
"    \n"
"    xhrUploadStart();\n"
"}\n"
"function logRestart(text)\n"
"{\n"
"    document.getElementById('restartresult').textContent = text;\n"
"}\n"
"function redirect()\n"
"{\n"
"    location.href = '/firmware';\n"
"}\n"
"function xhrRestartOnLoad()\n"
"{\n"
"    if (xhr.status == 200) logRestart('Restart should never have returned');\n"
"    else                   logRestart('Restart failed');\n"
"}\n"
"function xhrRestartStart()\n"
"{\n"
"    logRestart('Restarting...');\n"
"    \n"
"    xhr = new XMLHttpRequest();\n"
"\n"
"    xhr.onload  = xhrRestartOnLoad;\n"
"\n"
"    xhr.open('GET', '/firmware-ajax?restart='); //Defaults to async=true\n"
"    xhr.send();\n"
"    \n"
"    setTimeout(redirect, 2000);\n"
"}\n"
"function restart()\n"
"{\n"
"    xhrRestartStart();\n"
"}\n"
"\n"
""