"//Clock script\n"
"'use strict';\n"
"\n"
"let pseudo          = new Clock();\n"
"let rtc             = new Clock();\n"
"\n"
"let pseudoDisplay   = false;\n"
"let pseudoStartMs   = 0;\n"
"\n"
"let diffMs          = 0;\n"
"let rtcIsSet        = false;\n"
"let clockIsSet      = false;\n"
"let sourceIsOk      = false;\n"
"let rateIsLocked    = false;\n"
"let timeIsLocked    = false;\n"
"\n"
"let ppb             = 0;\n"
"let ppbdivisor      = 0;\n"
"let ppbmaxchange    = 0;\n"
"let syncedlimitppb  = 0;\n"
"let syncedhysppb    = 0;\n"
"let slewdivisor     = 0;\n"
"let slewmax         = 0;\n"
"let syncedlimitns   = 0;\n"
"let syncedhysns     = 0;\n"
"let maxoffsetsecs   = 0;\n"
"let govTrace        = false;\n"
"\n"
"let ntpserver       = '';\n"
"let ntpinitial      = 0;\n"
"let ntpnormal       = 0;\n"
"let ntpretry        = 0;\n"
"let ntpoffset       = 0;\n"
"let ntpmaxdelay     = 0;\n"
"\n"
"let scanavg         = 0;\n"
"let scanmax         = 0;\n"
"let scanmin         = 0;\n"
"\n"
"const DISPLAY_LEAP_MS = 10000;\n"
"\n"
"function parseLinesTime(text)\n"
"{\n"
"    let lines = text.split('\\n');\n"
"    rtc.ms          = Ajax.date.getTime();\n"
"    rtc.ms         += parseInt(lines[0], 16);\n"
"    rtc.ms         -= Ajax.ms;\n"
"    diffMs          = rtc.ms + Ajax.ms - Date.now();\n"
"    rtcIsSet        = Ajax.hexToBit(lines[1], 0);\n"
"    clockIsSet      = Ajax.hexToBit(lines[1], 1);\n"
"    sourceIsOk      = Ajax.hexToBit(lines[1], 2);\n"
"    rateIsLocked    = Ajax.hexToBit(lines[1], 3);\n"
"    timeIsLocked    = Ajax.hexToBit(lines[1], 4);\n"
"    rtc.leapEnable  = Ajax.hexToBit(lines[1], 5);\n"
"    rtc.leapForward = Ajax.hexToBit(lines[1], 6);\n"
"    govTrace        = Ajax.hexToBit(lines[1], 7);\n"
"    rtc.months1970  = parseInt(lines[2], 16);\n"
"    rtc.leaps       = parseInt(lines[3], 16);\n"
"}\n"
"function parseLinesGov(text)\n"
"{\n"
"    let lines = text.split('\\n');\n"
"    ppb             = parseInt(lines[0], 16);\n"
"    ppbdivisor      = parseInt(lines[1], 16);\n"
"    ppbmaxchange    = parseInt(lines[2], 16);\n"
"    syncedlimitppb  = parseInt(lines[3], 16);\n"
"    syncedhysppb    = parseInt(lines[4], 16);\n"
"    slewdivisor     = parseInt(lines[5], 16);\n"
"    slewmax         = parseInt(lines[6], 16);\n"
"    syncedlimitns   = parseInt(lines[7], 16);\n"
"    syncedhysns     = parseInt(lines[8], 16);\n"
"    maxoffsetsecs   = parseInt(lines[9], 16);\n"
"}\n"
"function parseLinesNtp(text)\n"
"{\n"
"    let lines = text.split('\\n');\n"
"    ntpserver       =          lines[0];\n"
"    ntpinitial      = parseInt(lines[1], 16);\n"
"    ntpnormal       = parseInt(lines[2], 16);\n"
"    ntpretry        = parseInt(lines[3], 16);\n"
"    ntpoffset       = parseInt(lines[4], 16);\n"
"    ntpmaxdelay     = parseInt(lines[5], 16);\n"
"}\n"
"function parseLinesScan(text)\n"
"{\n"
"    let lines = text.split('\\n');\n"
"    scanavg         = parseInt(lines[0], 16);\n"
"    scanmax         = parseInt(lines[1], 16);\n"
"    scanmin         = parseInt(lines[2], 16);\n"
"}\n"
"function parse()\n"
"{\n"
"    let topics = Ajax.response.split('\\f');\n"
"    parseLinesTime(topics[0]);\n"
"    parseLinesGov (topics[1]);\n"
"    parseLinesNtp (topics[2]);\n"
"    parseLinesScan(topics[3]);\n"
"}\n"
"function display()\n"
"{\n"
"    let elem;\n"
"    elem = Ajax.getElementOrNull('ajax-rtc-set'      ); if (elem) elem.setAttribute('dir', rtcIsSet     ? 'rtl' : 'ltr');\n"
"    elem = Ajax.getElementOrNull('ajax-clock-set'    ); if (elem) elem.setAttribute('dir', clockIsSet   ? 'rtl' : 'ltr');\n"
"    elem = Ajax.getElementOrNull('ajax-source-ok'    ); if (elem) elem.setAttribute('dir', sourceIsOk   ? 'rtl' : 'ltr');\n"
"    elem = Ajax.getElementOrNull('ajax-rate-locked'  ); if (elem) elem.setAttribute('dir', rateIsLocked ? 'rtl' : 'ltr');\n"
"    elem = Ajax.getElementOrNull('ajax-time-locked'  ); if (elem) elem.setAttribute('dir', timeIsLocked ? 'rtl' : 'ltr');\n"
"    \n"
"    elem = Ajax.getElementOrNull('ajax-leap-enable'  ); if (elem) elem.setAttribute('dir', rtc.leapEnable   ? 'rtl' : 'ltr');\n"
"    elem = Ajax.getElementOrNull('ajax-leap-forward' ); if (elem) elem.setAttribute('dir', rtc.leapForward  ? 'rtl' : 'ltr');\n"
"    \n"
"    elem = Ajax.getElementOrNull('ajax-leap-year'    ); if (elem) elem.value = rtc.months1970 ? rtc.leapYear  : '';\n"
"    elem = Ajax.getElementOrNull('ajax-leap-month'   ); if (elem) elem.value = rtc.months1970 ? rtc.leapMonth : '';\n"
"    \n"
"    elem = Ajax.getElementOrNull('ajax-leap-count'   ); if (elem) elem.value = rtc.leaps;\n"
"    \n"
"    elem = Ajax.getElementOrNull('ajax-ppb'          ); if (elem) elem.value = ppb;\n"
"    elem = Ajax.getElementOrNull('ajax-ppb-divisor'  ); if (elem) elem.value = ppbdivisor;\n"
"    elem = Ajax.getElementOrNull('ajax-ppb-max-chg'  ); if (elem) elem.value = ppbmaxchange;\n"
"    elem = Ajax.getElementOrNull('ajax-ppb-syn-lim'  ); if (elem) elem.value = syncedlimitppb;\n"
"    elem = Ajax.getElementOrNull('ajax-ppb-syn-hys'  ); if (elem) elem.value = syncedhysppb;\n"
"    elem = Ajax.getElementOrNull('ajax-off-divisor'  ); if (elem) elem.value = slewdivisor;\n"
"    elem = Ajax.getElementOrNull('ajax-off-max'      ); if (elem) elem.value = slewmax;\n"
"    elem = Ajax.getElementOrNull('ajax-off-syn-lim'  ); if (elem) elem.value = syncedlimitns / 1000000;\n"
"    elem = Ajax.getElementOrNull('ajax-off-syn-hys'  ); if (elem) elem.value = syncedhysns   / 1000000;\n"
"    elem = Ajax.getElementOrNull('ajax-off-rst-lim'  ); if (elem) elem.value = maxoffsetsecs;\n"
"    elem = Ajax.getElementOrNull('ajax-gov-trace'    ); if (elem) elem.setAttribute('dir', govTrace     ? 'rtl' : 'ltr');\n"
"    \n"
"    elem = Ajax.getElementOrNull('ajax-ntp-server'   ); if (elem) elem.value = ntpserver;\n"
"    elem = Ajax.getElementOrNull('ajax-ntp-initial'  ); if (elem) elem.value = ntpinitial;\n"
"    elem = Ajax.getElementOrNull('ajax-ntp-normal'   ); if (elem) elem.value = ntpnormal / 60;\n"
"    elem = Ajax.getElementOrNull('ajax-ntp-retry'    ); if (elem) elem.value = ntpretry;\n"
"    elem = Ajax.getElementOrNull('ajax-ntp-offset'   ); if (elem) elem.value = ntpoffset;\n"
"    elem = Ajax.getElementOrNull('ajax-ntp-max-delay'); if (elem) elem.value = ntpmaxdelay;\n"
"    \n"
"    elem = Ajax.getElementOrNull('ajax-scan-avg'     ); if (elem) elem.textContent = scanavg;\n"
"    elem = Ajax.getElementOrNull('ajax-scan-max'     ); if (elem) elem.textContent = scanmax;\n"
"    elem = Ajax.getElementOrNull('ajax-scan-min'     ); if (elem) elem.textContent = scanmin;\n"
"    \n"
"    elem = Ajax.getElementOrNull('ajax-date-diff'    ); if (elem) elem.textContent = diffMs;\n"
"}\n"
"\n"
"function handleTick() //This typically called every 100ms\n"
"{\n"
"    if (pseudoDisplay)\n"
"    {\n"
"        pseudo.adjustLeap (Ajax.ms);\n"
"        pseudo.displayTime(Ajax.ms);\n"
"        if (Ajax.ms >= pseudoStartMs + DISPLAY_LEAP_MS + 500) pseudoDisplay = false;\n"
"    }\n"
"    else\n"
"    {\n"
"        rtc.adjustLeap (Ajax.ms);\n"
"        rtc.displayTime(Ajax.ms);\n"
"    }\n"
"}\n"
"\n"
"function displayLeap() //Called by display leap button in HTML\n"
"{\n"
"   pseudoDisplay = true;\n"
"   pseudoStartMs = Ajax.ms;\n"
"   \n"
"   pseudo.leapEnable  = true;\n"
"   pseudo.leapForward = rtc.leapForward;\n"
"   pseudo.leaps       = rtc.leaps;\n"
"   pseudo.leapMonth   = rtc.leapMonth;\n"
"   pseudo.leapYear    = rtc.leapYear;\n"
"   pseudo.ms          = Date.UTC(rtc.leapYear, rtc.leapMonth - 1, 1) - DISPLAY_LEAP_MS / 2 - Ajax.ms;\n"
"}\n"
"Ajax.server     = '/clock-ajax';\n"
"Ajax.onResponse = function() { parse(); display(); };\n"
"Ajax.onTick     = handleTick;\n"
"Ajax.init();"