"//Net6 script\n"
"'use strict';\n"
"\n"
"let arp             = '';\n"
"\n"
"let hopLimit        = '';\n"
"let mtu             = '';\n"
"let managed         = false;\n"
"let other           = false;\n"
"let routerMac       = '';\n"
"let dnsLife         = '';\n"
"let dnsIp           = '';\n"
"let ndpLease        = '';\n"
"let ndpElapsed      = '';\n"
"let slaac           = '';\n"
"\n"
"let uniquePrefixLength    = '';\n"
"let uniquePrefixL         = false;\n"
"let uniquePrefixA         = false;\n"
"let uniquePrefixLimit     = '';\n"
"let uniquePrefixPreferred = '';\n"
"let uniquePrefix          = '';\n"
"let globalPrefixLength    = '';\n"
"let globalPrefixL         = false;\n"
"let globalPrefixA         = false;\n"
"let globalPrefixLimit     = '';\n"
"let globalPrefixPreferred = '';\n"
"let globalPrefix          = '';\n"
"\n"
"function parseArpLine(line)\n"
"{\n"
"    if (line.length == 0) return;\n"
"    let fields = line.split('\\t');\n"
"    \n"
"    arp += parseInt(fields[0], 16).toString().padStart(2, ' ');\n"
"    \n"
"    let minutes  = parseInt(fields[1], 16) / 1000 / 60;\n"
"    arp += Math.floor(minutes).toString().padStart(4, ' ');\n"
"    \n"
"    arp += ' ';\n"
"    arp += Net.makeIp6(fields[2]).padEnd(40, ' ');\n"
"    \n"
"    arp += ' ';\n"
"    let mac = Net.makeMac(fields[3]);\n"
"    arp += mac;\n"
"    \n"
"    let vendor = Net.getVendorFromLocalStorage(mac);\n"
"    if (vendor)\n"
"    {\n"
"        arp += ' ';\n"
"        arp += vendor;\n"
"    }\n"
"    else\n"
"    {\n"
"        Net.addVendorToLocalStorage(mac);\n"
"    }\n"
"    \n"
"    arp += '\\r\\n';\n"
"}\n"
"function parseArpLines(text)\n"
"{\n"
"    arp = '';\n"
"    text.split('\\n').forEach(parseArpLine);\n"
"}\n"
"function parseGenLines(text)\n"
"{\n"
"    let lines = text.split('\\n');\n"
"    \n"
"    slaac                 = Net.makeIp6 (lines[ 0]    );\n"
"    \n"
"    hopLimit              =     parseInt(lines[ 1], 16);\n"
"    mtu                   =     parseInt(lines[ 2], 16);\n"
"    managed               = Net.hexToBit(lines[ 3],  0);\n"
"    other                 = Net.hexToBit(lines[ 3],  1);\n"
"    routerMac             = Net.makeMac (lines[ 4], 16);\n"
"    ndpLease              =     parseInt(lines[ 5], 16);\n"
"    ndpElapsed            =     parseInt(lines[ 6], 16);\n"
"    \n"
"    dnsIp                 = Net.makeIp6 (lines[ 7]    );\n"
"    dnsLife               =     parseInt(lines[ 8], 16);\n"
"    \n"
"    uniquePrefixL         = Net.hexToBit(lines[ 9],  0);\n"
"    uniquePrefixA         = Net.hexToBit(lines[ 9],  1);\n"
"    uniquePrefixLength    =     parseInt(lines[10], 16);\n"
"    uniquePrefix          = Net.makeIp6 (lines[11]    );\n"
"    uniquePrefixLimit     =     parseInt(lines[12], 16);\n"
"    uniquePrefixPreferred =     parseInt(lines[13], 16);\n"
"    \n"
"    globalPrefixL         = Net.hexToBit(lines[14],  0);\n"
"    globalPrefixA         = Net.hexToBit(lines[14],  1);\n"
"    globalPrefixLength    =     parseInt(lines[15], 16);\n"
"    globalPrefix          = Net.makeIp6 (lines[16]    );\n"
"    globalPrefixLimit     =     parseInt(lines[17], 16);\n"
"    globalPrefixPreferred =     parseInt(lines[18], 16);\n"
"}\n"
"function parse()\n"
"{\n"
"    let topics = Ajax.response.split('\\f');\n"
"    parseGenLines(topics[0]);\n"
"    parseArpLines(topics[1]);\n"
"}\n"
"function display()\n"
"{\n"
"    let elem;\n"
"    \n"
"    elem = Ajax.getElementOrNull('ajax-arp'             ); if (elem) elem.textContent = arp;\n"
"    elem = Ajax.getElementOrNull('ajax-slaac'           ); if (elem) elem.textContent = slaac;\n"
"    elem = Ajax.getElementOrNull('ajax-hop-limit'       ); if (elem) elem.textContent = hopLimit;\n"
"    elem = Ajax.getElementOrNull('ajax-mtu'             ); if (elem) elem.textContent = mtu;\n"
"    elem = Ajax.getElementOrNull('ajax-managed'         ); if (elem) elem.setAttribute('dir', managed ? 'rtl' : 'ltr');\n"
"    elem = Ajax.getElementOrNull('ajax-other'           ); if (elem) elem.setAttribute('dir', other   ? 'rtl' : 'ltr');\n"
"    elem = Ajax.getElementOrNull('ajax-router-mac'      ); if (elem) elem.textContent = routerMac;\n"
"    elem = Ajax.getElementOrNull('ajax-ndp-lease'       ); if (elem) elem.textContent = ndpLease;\n"
"    elem = Ajax.getElementOrNull('ajax-ndp-elapsed'     ); if (elem) elem.textContent = ndpElapsed;\n"
"    elem = Ajax.getElementOrNull('ajax-dns-life'        ); if (elem) elem.textContent = dnsLife;\n"
"    elem = Ajax.getElementOrNull('ajax-dns-ip'          ); if (elem) elem.textContent = dnsIp;\n"
"    \n"
"    elem = Ajax.getElementOrNull('ajax-unique-prefix-l'        ); if (elem) elem.setAttribute('dir', uniquePrefixL ? 'rtl' : 'ltr');\n"
"    elem = Ajax.getElementOrNull('ajax-unique-prefix-a'        ); if (elem) elem.setAttribute('dir', uniquePrefixA ? 'rtl' : 'ltr');\n"
"    elem = Ajax.getElementOrNull('ajax-unique-prefix-length'   ); if (elem) elem.textContent = uniquePrefixLength;\n"
"    elem = Ajax.getElementOrNull('ajax-unique-prefix'          ); if (elem) elem.textContent = uniquePrefix;\n"
"    elem = Ajax.getElementOrNull('ajax-unique-prefix-limit'    ); if (elem) elem.textContent = uniquePrefixLimit;\n"
"    elem = Ajax.getElementOrNull('ajax-unique-prefix-preferred'); if (elem) elem.textContent = uniquePrefixPreferred;\n"
"    \n"
"    elem = Ajax.getElementOrNull('ajax-global-prefix-l'        ); if (elem) elem.setAttribute('dir', globalPrefixL ? 'rtl' : 'ltr');\n"
"    elem = Ajax.getElementOrNull('ajax-global-prefix-a'        ); if (elem) elem.setAttribute('dir', globalPrefixA ? 'rtl' : 'ltr');\n"
"    elem = Ajax.getElementOrNull('ajax-global-prefix-length'   ); if (elem) elem.textContent = globalPrefixLength;\n"
"    elem = Ajax.getElementOrNull('ajax-global-prefix'          ); if (elem) elem.textContent = globalPrefix;\n"
"    elem = Ajax.getElementOrNull('ajax-global-prefix-limit'    ); if (elem) elem.textContent = globalPrefixLimit;\n"
"    elem = Ajax.getElementOrNull('ajax-global-prefix-preferred'); if (elem) elem.textContent = globalPrefixPreferred;\n"
"}\n"
"\n"
"Ajax.server     = '/net6-ajax';\n"
"Ajax.onResponse = function() { parse(); display(); };\n"
"Ajax.init();"