"//Clock class\n"
"'use strict';\n"
"\n"
"class Clock\n"
"{\n"
"    constructor()\n"
"    {\n"
"        this.leapEnable  = false;\n"
"        this.leapForward = false;\n"
"        this.leapMonth   = 0;\n"
"        this.leapYear    = 0;\n"
"        this.leaps       = 0;\n"
"        this.ms          = 0;\n"
"    }\n"
"    \n"
"    set months1970(value)\n"
"    {\n"
"        this.leapMonth   =  value                   % 12;\n"
"        this.leapYear    = (value - this.leapMonth) / 12;\n"
"        this.leapMonth  += 1;\n"
"        this.leapYear   += 1970;\n"
"    }\n"
"    get months1970()\n"
"    {\n"
"        if (this.leapYear  <= 0) return 0;\n"
"        if (this.leapMonth <= 0) return 0;\n"
"        return (this.leapYear - 1970) * 12 + this.leapMonth - 1;\n"
"    }\n"
"    \n"
"    formatNumbers00(i)\n"
"    {\n"
"       if (i < 10) return '0' + i;\n"
"       return i;\n"
"    }\n"
"    formatDayOfWeek(wday)\n"
"    {\n"
"        switch(wday)\n"
"        {\n"
"            case  0: return 'Sun';\n"
"            case  1: return 'Mon';\n"
"            case  2: return 'Tue';\n"
"            case  3: return 'Wed';\n"
"            case  4: return 'Thu';\n"
"            case  5: return 'Fri';\n"
"            case  6: return 'Sat';\n"
"            default: return '---';\n"
"        }\n"
"    }\n"
"    adjustLeap(baseMs)\n"
"    {\n"
"        if (this.ms == 0) return; //Don't attempt to adjust an invalid time\n"
"        \n"
"        if (!this.leapEnable) return; // Adjustment disabled\n"
"        \n"
"        //Get the calander date and time from the ms\n"
"        let now       = this.ms + baseMs;\n"
"        let leapStart = Date.UTC(this.leapYear, this.leapMonth - 1, 1, 0, 0, this.leapForward ? 0: -1);\n"
"        \n"
"        if (now < leapStart) return; //Do nothing until reached the leap start\n"
"        \n"
"        if (this.leapForward) { this.ms -= 1000; this.leaps += 1; } //repeat 59\n"
"        else                  { this.ms += 1000; this.leaps -= 1; } //skip   59\n"
"        \n"
"        this.leapEnable = false;\n"
"    }\n"
"    displayTime(baseMs)\n"
"    {\n"
"        if (this.ms == 0) return; //Don't attempt to display an invalid time\n"
"        \n"
"        //Get the calander date and time from the ms\n"
"        let now = new Date(this.ms + baseMs);\n"
"        let   y = now.getUTCFullYear();\n"
"        let   n = now.getUTCMonth   () + 1;\n"
"        let   d = now.getUTCDate    ();\n"
"        let   w = now.getUTCDay     (); // 0 == Sunday\n"
"        let   h = now.getUTCHours   ();\n"
"        let   m = now.getUTCMinutes ();\n"
"        let   s = now.getUTCSeconds ();\n"
"        \n"
"        //Format time\n"
"        n = this.formatNumbers00(n);\n"
"        d = this.formatNumbers00(d);\n"
"        h = this.formatNumbers00(h);\n"
"        m = this.formatNumbers00(m);\n"
"        s = this.formatNumbers00(s);\n"
"        w = this.formatDayOfWeek(w);\n"
"        \n"
"        //Display time\n"
"        let elem;\n"
"        elem = document.getElementById('ajax-date-utc');\n"
"        if (elem) elem.textContent = y + '-' + n + '-' + d + ' ' + w + ' ' + h + ':' + m + ':' + s + ' TAI-UTC=' + this.leaps;\n"
"    \n"
"        elem = document.getElementById('ajax-date-pc');\n"
"        let options = \n"
"        {\n"
"            year:         'numeric',\n"
"            month:        'short',\n"
"            day:          '2-digit',\n"
"            weekday:      'short',\n"
"            hour:         '2-digit',\n"
"            minute:       '2-digit',\n"
"            second:       '2-digit',\n"
"            timeZoneName: 'short'\n"
"        };\n"
"        if (elem) elem.textContent = now.toLocaleString(undefined, options);\n"
"    }\n"
"}\n"
""