"//Ajax class\n"
"'use strict';\n"
"\n"
"//Exposed properties\n"
"let ajaxResponse_   = '';\n"
"let ajaxHeaders_    = '';\n"
"let ajaxDate_       = null;\n"
"let ajaxMs_         =  0;\n"
"let ajaxOnResponse_ = null;\n"
"let ajaxOnTick_     = null;\n"
"let ajaxServer_     = '';\n"
"\n"
"//Private variables\n"
"let   ajaxOverrideBlockUpdateOnFocus_ = false;\n"
"let   ajaxXhr_                        =  null;\n"
"let   ajaxMsCountAtAjaxSend_          =     0;\n"
"const ajaxTickMs_                     =   100;\n"
"const ajaxQuickUpdateMs_              =  1000;\n"
"const ajaxUpdateMs_                   = 10000;\n"
"let   ajaxDoQuickUpdate_              = false;\n"
"\n"
"//Private utilities\n"
"function ajaxGetElementOrNull_(elementName) //Returns the element if it: exists; block is overidden; does not have focus\n"
"{\n"
"    let elem = document.getElementById(elementName);\n"
"    if (!elem) return null;\n"
"    if (ajaxOverrideBlockUpdateOnFocus_) return elem;\n"
"    if (elem !== document.activeElement) return elem;\n"
"    return null;\n"
"}\n"
"function ajaxHexToBit_(text, iBit)\n"
"{\n"
"   let value = parseInt(text, 16);\n"
"   value >>= iBit;\n"
"   return value & 1;\n"
"}\n"
"function ajaxHexToSignedInt8_(text)\n"
"{\n"
"    let value = parseInt(text, 16);\n"
"    if (value < 0x80) return value;\n"
"    return value - 0x100;\n"
"}\n"
"function ajaxHexToSignedInt16_(text)\n"
"{\n"
"    let value = parseInt(text, 16);\n"
"    if (value < 0x8000) return value;\n"
"    return value - 0x10000;\n"
"}\n"
"function ajaxHexToSignedInt32_(text)\n"
"{\n"
"    let value = parseInt(text, 16);\n"
"    if (value < 0x80000000) return value;\n"
"    return value - 0x100000000;\n"
"}\n"
"\n"
"\n"
"//Private ajax functions\n"
"function ajaxHandleAjaxResponse_()\n"
"{\n"
"   if (ajaxXhr_.readyState == 4 && ajaxXhr_.status == 200)\n"
"   {\n"
"        ajaxResponse_ = ajaxXhr_.responseText;\n"
"        ajaxHeaders_  = ajaxXhr_.getAllResponseHeaders();\n"
"        let iDateStart = Ajax.headers.toLowerCase().indexOf('date:');\n"
"        let iDateEnd   = Ajax.headers.indexOf('\\r', iDateStart);\n"
"        ajaxDate_      = new Date(Ajax.headers.slice(iDateStart + 5, iDateEnd));\n"
"\n"
"        let elem;\n"
"        elem = ajaxGetElementOrNull_('ajax-response'   ); if (elem) elem.textContent = ajaxResponse_;\n"
"        elem = ajaxGetElementOrNull_('ajax-headers'    ); if (elem) elem.textContent = ajaxHeaders_;\n"
"        elem = ajaxGetElementOrNull_('ajax-date-local' );\n"
"        if (elem)\n"
"        {\n"
"            elem.textContent = ajaxDate_.toLocaleString(    undefined, {  weekday     : 'short'  ,\n"
"                                                                          day         : '2-digit',\n"
"                                                                          month       : 'short'  ,\n"
"                                                                          year        : 'numeric',\n"
"                                                                          hour        : '2-digit',\n"
"                                                                          minute      : '2-digit',\n"
"                                                                          timeZoneName: 'short'\n"
"                                                                       }\n"
"                                                       );\n"
"        }\n"
"        if (ajaxOnResponse_) ajaxOnResponse_();\n"
"        ajaxOverrideBlockUpdateOnFocus_ = false; //Received response so reset override after display\n"
"   }\n"
"}\n"
"function ajaxSendNameValue_(name, value) //Used by this script and from HTML page\n"
"{\n"
"    ajaxXhr_ = new XMLHttpRequest();\n"
"    ajaxXhr_.onreadystatechange = ajaxHandleAjaxResponse_;\n"
"    if (name)\n"
"    {\n"
"        if (value)\n"
"        {\n"
"            ajaxXhr_.open('GET', ajaxServer_ + '?' + name + '=' + encodeURIComponent(value), true);\n"
"        }\n"
"        else\n"
"        {\n"
"            ajaxXhr_.open('GET', ajaxServer_ + '?' + name, true);\n"
"        }\n"
"    }\n"
"    else\n"
"    {\n"
"        ajaxXhr_.open('GET', ajaxServer_, true);\n"
"    }\n"
"    ajaxXhr_.send();\n"
"    ajaxDoQuickUpdate_     = false;\n"
"    ajaxMsCountAtAjaxSend_ = ajaxMs_;\n"
"}\n"
"function AjaxSendNameValue(name, value) //From html\n"
"{\n"
"    ajaxOverrideBlockUpdateOnFocus_ = true; //Request has come from an update\n"
"    ajaxSendNameValue_(name, value);\n"
"    ajaxDoQuickUpdate_              = true;\n"
"}\n"
"\n"
"//Private functions\n"
"function ajaxTick_() //Called about every 100ms\n"
"{\n"
"    ajaxMs_ += ajaxTickMs_; //Don't use Date.now() as we don't know when the PC's clock will be updated around a leap second\n"
"    if (ajaxMs_ >= ajaxMsCountAtAjaxSend_ + ajaxUpdateMs_) ajaxSendNameValue_('', '');\n"
"    if (ajaxDoQuickUpdate_)\n"
"    {\n"
"        if (ajaxMs_ >= ajaxMsCountAtAjaxSend_ + ajaxQuickUpdateMs_) ajaxSendNameValue_('', '');\n"
"    }\n"
"    if (ajaxOnTick_) ajaxOnTick_();\n"
"}\n"
"function ajaxInit_()\n"
"{\n"
"    setInterval(ajaxTick_, ajaxTickMs_);\n"
"    ajaxSendNameValue_('', '');\n"
"}\n"
"\n"
"//Exposed public\n"
"class Ajax\n"
"{\n"
"    static get ms        ()  { return ajaxMs_         ; }\n"
"    static get response  ()  { return ajaxResponse_   ; }\n"
"    static get headers   ()  { return ajaxHeaders_    ; }\n"
"    static get date      ()  { return ajaxDate_       ; }\n"
"    \n"
"    static set tickMs    (v) { ajaxTickMs_     = v; }\n"
"    static set updateMs  (v) { ajaxUpdateMs_   = v; }\n"
"    static set server    (v) { ajaxServer_     = v; }\n"
"    static set onResponse(v) { ajaxOnResponse_ = v; }\n"
"    static set onTick    (v) { ajaxOnTick_     = v; }\n"
"\n"
"    static getElementOrNull(elementName) { return ajaxGetElementOrNull_(elementName) ; }\n"
"    static hexToBit        (text, iBit ) { return ajaxHexToBit_        (text, iBit ) ; }\n"
"    static hexToSignedInt8 (text       ) { return ajaxHexToSignedInt8_ (text       ) ; }\n"
"    static hexToSignedInt16(text       ) { return ajaxHexToSignedInt16_(text       ) ; }\n"
"    static hexToSignedInt32(text       ) { return ajaxHexToSignedInt32_(text       ) ; }\n"
"    \n"
"    static init()\n"
"    {\n"
"        if (document.readyState === 'loading') document.addEventListener('DOMContentLoaded', ajaxInit_ ); // Loading hasn't finished yet\n"
"        else                                                                                 ajaxInit_(); //`DOMContentLoaded` has already fired\n"
"    }\n"
"}"