"//Net4 script\n"
"'use strict';\n"
"\n"
"let localIp     = '';\n"
"let domainName  = '';\n"
"let hostName    = '';\n"
"let ntpIp       = '';\n"
"let dnsIp       = '';\n"
"let dhcpIp      = '';\n"
"let routerIp    = '';\n"
"let subnetMask  = '';\n"
"let broadcastIp = '';\n"
"let leaseTime   = '';\n"
"let renewalT1   = '';\n"
"let renewalt2   = '';\n"
"let elapsed     = '';\n"
"let arp         = '';\n"
"\n"
"function parseArpLine(line)\n"
"{\n"
"    if (line.length == 0) return;\n"
"    let fields = line.split('\\t');\n"
"    \n"
"    arp += parseInt(fields[0], 16).toString().padStart(2, ' ');\n"
"    \n"
"    let minutes  = parseInt(fields[1], 16) / 1000 / 60;\n"
"    arp += Math.floor(minutes).toString().padStart(4, ' ');\n"
"    \n"
"    arp += ' ';\n"
"    arp += Net.makeIp4(fields[2]).padEnd(15, ' ');\n"
"    \n"
"    arp += ' ';\n"
"    let mac = Net.makeMac(fields[3]);\n"
"    arp += mac;\n"
"    \n"
"    let vendor = Net.getVendorFromLocalStorage(mac);\n"
"    if (vendor)\n"
"    {\n"
"        arp += ' ';\n"
"        arp += vendor;\n"
"    }\n"
"    else\n"
"    {\n"
"        Net.addVendorToLocalStorage(mac);\n"
"    }\n"
"    \n"
"    arp += '\\r\\n';\n"
"}\n"
"function parseArpLines(text)\n"
"{\n"
"    arp = '';\n"
"    text.split('\\n').forEach(parseArpLine);\n"
"}\n"
"function parseGenLines(text)\n"
"{\n"
"    let lines = text.split('\\n');\n"
"    localIp     = Net.makeIp4(lines[ 0])    ;\n"
"    domainName  =             lines[ 1]     ;\n"
"    hostName    =             lines[ 2]     ;\n"
"    ntpIp       = Net.makeIp4(lines[ 3])    ;\n"
"    dnsIp       = Net.makeIp4(lines[ 4])    ;\n"
"    dhcpIp      = Net.makeIp4(lines[ 5])    ;\n"
"    routerIp    = Net.makeIp4(lines[ 6])    ;\n"
"    subnetMask  = Net.makeIp4(lines[ 7])    ;\n"
"    broadcastIp = Net.makeIp4(lines[ 8])    ;\n"
"    leaseTime   =    parseInt(lines[ 9], 16);\n"
"    renewalT1   =    parseInt(lines[10], 16);\n"
"    renewalt2   =    parseInt(lines[11], 16);\n"
"    elapsed     =    parseInt(lines[12], 16);\n"
"}\n"
"function parse()\n"
"{\n"
"    let topics = Ajax.response.split('\\f');\n"
"    parseGenLines(topics[0]);\n"
"    parseArpLines(topics[1]);\n"
"}\n"
"function display()\n"
"{\n"
"    let elem;\n"
"\n"
"    elem = Ajax.getElementOrNull('ajax-local-ip'    ); if (elem) elem.textContent = localIp;\n"
"    elem = Ajax.getElementOrNull('ajax-domain-name' ); if (elem) elem.textContent = domainName;\n"
"    elem = Ajax.getElementOrNull('ajax-host-name'   ); if (elem) elem.textContent = hostName;\n"
"    elem = Ajax.getElementOrNull('ajax-ntp-ip'      ); if (elem) elem.textContent = ntpIp;\n"
"    elem = Ajax.getElementOrNull('ajax-dns-ip'      ); if (elem) elem.textContent = dnsIp;\n"
"    elem = Ajax.getElementOrNull('ajax-dhcp-ip'     ); if (elem) elem.textContent = dhcpIp;\n"
"    elem = Ajax.getElementOrNull('ajax-router-ip'   ); if (elem) elem.textContent = routerIp;\n"
"    elem = Ajax.getElementOrNull('ajax-subnet-mask' ); if (elem) elem.textContent = subnetMask;\n"
"    elem = Ajax.getElementOrNull('ajax-broadcast-ip'); if (elem) elem.textContent = broadcastIp;\n"
"    elem = Ajax.getElementOrNull('ajax-lease-time'  ); if (elem) elem.textContent = leaseTime;\n"
"    elem = Ajax.getElementOrNull('ajax-renewal-t1'  ); if (elem) elem.textContent = renewalT1;\n"
"    elem = Ajax.getElementOrNull('ajax-renewal-t2'  ); if (elem) elem.textContent = renewalt2;\n"
"    elem = Ajax.getElementOrNull('ajax-elapsed'     ); if (elem) elem.textContent = elapsed;\n"
"    elem = Ajax.getElementOrNull('ajax-arp'         ); if (elem) elem.textContent = arp;\n"
"}\n"
"\n"
"Ajax.server     = '/net4-ajax';\n"
"Ajax.onResponse = function() { parse(); display(); };\n"
"Ajax.init();"