"//Net script\n"
"'use strict';\n"
"\n"
"let mac = '';\n"
"let nr  = '';\n"
"let tcp = '';\n"
"let dns = '';\n"
"let a4s = null;\n"
"let a6s = null;\n"
"\n"
"function parseTcpLine(line)\n"
"{\n"
"    if (line.length == 0) return;\n"
"    let fields = line.split('\\t');\n"
"    let state      = parseInt(fields[0], 16);\n"
"    let idleMs     = parseInt(fields[1], 16);\n"
"    let ipType     = parseInt(fields[2], 16);\n"
"    let arIndex    = parseInt(fields[3], 16);\n"
"    let locPort    = parseInt(fields[4], 16);\n"
"    let remPort    = parseInt(fields[5], 16);\n"
"    let bytesRcvd  = parseInt(fields[6], 16);\n"
"    let bytesSent  = parseInt(fields[7], 16);\n"
"    \n"
"    switch (state)\n"
"    {\n"
"        case 1:  tcp += \"  Syn\";                           break;\n"
"        case 2:  tcp += \"  Est\";                           break;\n"
"        case 3:  tcp += \" Wait\";                           break;\n"
"        default: tcp += state.toString().padStart(5, ' '); break;\n"
"    }\n"
"    \n"
"    let idleMinutes = Math.floor(idleMs / 1000 / 60);\n"
"    tcp += idleMinutes.toString().padStart(4, ' ');\n"
"    tcp += \"     \";\n"
"    \n"
"    if      (ipType == 0x0800) tcp += \"IPv4\";\n"
"    else if (ipType == 0x86DD) tcp += \"IPv6\";\n"
"    else                       tcp += fields[1];\n"
"    \n"
"    tcp +=   arIndex.toString().padStart(4, ' ');\n"
"    tcp +=   locPort.toString().padStart(9, ' ');\n"
"    tcp +=   remPort.toString().padStart(9, ' ');\n"
"    tcp += bytesRcvd.toString().padStart(6, ' ');\n"
"    tcp += bytesSent.toString().padStart(6, ' ');\n"
"    tcp += '\\r\\n';\n"
"}\n"
"function parseDnsLine(line)\n"
"{\n"
"    if (line.length == 0) return;\n"
"    let fields = line.split('\\t');\n"
"    \n"
"    dns += parseInt(fields[0], 16).toString().padStart(2, ' ');\n"
"    let minutes  = parseInt(fields[1], 16) / 1000 / 60;\n"
"    dns += Math.floor(minutes).toString().padStart(4, ' ');\n"
"    dns += ' ';\n"
"    let addrType = fields[2];\n"
"    switch (addrType)\n"
"    {\n"
"        case '4': dns += '   A'; break;\n"
"        case '6': dns += 'AAAA'; break;\n"
"        default:  dns += addrType; break;\n"
"    }\n"
"    dns += ' ';\n"
"    let addr = '';\n"
"    let mac = '';\n"
"    switch (addrType)\n"
"    {\n"
"        case '4':\n"
"            if (fields[3] === '00000000') break;\n"
"            addr = Net.makeIp4(fields[3]);\n"
"            if (a4s.has(addr)) mac = a4s.get(addr);\n"
"            break;\n"
"        case '6':\n"
"            if (fields[3].substr(0, 2) === '00') break;\n"
"            addr = Net.makeIp6(fields[3]);\n"
"            if (a6s.has(addr)) mac = a6s.get(addr);\n"
"            break;\n"
"    }\n"
"    dns += addr.padEnd(40, ' ');\n"
"    \n"
"    dns += ' ';\n"
"    dns += fields[4]; //DNS protocol used\n"
"    dns += ' ';\n"
"    dns += fields[5].padEnd(32, ' '); //Resolved name\n"
"    \n"
"    if (mac != '')\n"
"    {\n"
"        dns += ' ';\n"
"        dns += mac;\n"
"        dns += ' ';\n"
"        \n"
"        let vendor = Net.getVendorFromLocalStorage(mac);\n"
"        if (vendor)\n"
"        {\n"
"            dns += ' ';\n"
"            dns += vendor;\n"
"        }\n"
"        else\n"
"        {\n"
"            Net.addVendorToLocalStorage(mac);\n"
"        }\n"
"    }\n"
"    dns += '\\r\\n';\n"
"}\n"
"function parseAr4Line(line)\n"
"{\n"
"    if (line.length == 0) return;\n"
"    let fields = line.split('\\t');\n"
"    \n"
"    let index =    parseInt(fields[0], 16);\n"
"    let ms    =    parseInt(fields[1], 16);\n"
"    let addr  = Net.makeIp4(fields[2]);\n"
"    let mac   = Net.makeMac(fields[3]);\n"
"    \n"
"    a4s.set(addr, mac);\n"
"}\n"
"function parseAr6Line(line)\n"
"{\n"
"    if (line.length == 0) return;\n"
"    let fields = line.split('\\t');\n"
"    \n"
"    let index =    parseInt(fields[0], 16);\n"
"    let ms    =    parseInt(fields[1], 16);\n"
"    let addr  = Net.makeIp6(fields[2]);\n"
"    let mac   = Net.makeMac(fields[3]);\n"
"    \n"
"    a6s.set(addr, mac);\n"
"}\n"
"function parseGenLines(text)\n"
"{\n"
"    let lines = text.split('\\n');\n"
"    mac = Net.makeMac(lines[ 0]);\n"
"    nr  =             lines[ 1] ;\n"
"}\n"
"function parseTcpLines(text)\n"
"{\n"
"    tcp = \"State Idle Protocol ARI Port-Loc Port-Rem  Rcvd  Sent\\n\";\n"
"    text.split('\\n').forEach(parseTcpLine);\n"
"}\n"
"function parseDnsLines(text)\n"
"{\n"
"    dns = '';\n"
"    text.split('\\n').forEach(parseDnsLine);\n"
"}\n"
"function parseAr4Lines(text)\n"
"{\n"
"    a4s = new Map();\n"
"    text.split('\\n').forEach(parseAr4Line);\n"
"}\n"
"function parseAr6Lines(text)\n"
"{\n"
"    a6s = new Map();\n"
"    text.split('\\n').forEach(parseAr6Line);\n"
"}\n"
"function parse()\n"
"{\n"
"    let topics = Ajax.response.split('\\f');\n"
"    parseGenLines(topics[0]);\n"
"    parseTcpLines(topics[1]);\n"
"    parseAr4Lines(topics[3]);\n"
"    parseAr6Lines(topics[4]);\n"
"    parseDnsLines(topics[2]);\n"
"}\n"
"function display()\n"
"{\n"
"    let elem;\n"
"\n"
"    elem = Ajax.getElementOrNull('ajax-tcp'         ); if (elem) elem.textContent = tcp;\n"
"    elem = Ajax.getElementOrNull('ajax-mac'         ); if (elem) elem.textContent = mac;\n"
"    elem = Ajax.getElementOrNull('ajax-nr'          ); if (elem) elem.value       = nr;\n"
"    elem = Ajax.getElementOrNull('ajax-dns'         ); if (elem) elem.textContent = dns;\n"
"}\n"
"\n"
"Ajax.server     = '/net-ajax';\n"
"Ajax.onResponse = function() { parse(); display(); };\n"
"Ajax.init();\n"
""