#include "lpc1768.h"
#include "periphs.h"
#include "led.h"
#include "clk.h"
#include "log.h"
#include "fram.h"
#include "net.h"
#include "1-wire.h"
#include "1-wire-device.h"
#include "heating.h"
#include "settings.h"
#include "web.h"
#include "settings.h"
#include "values.h"
#include "restart.h"
#include "restart-this.h"
#include "crypto.h"

int main()
{
    RestartZone = RESTART_ZONE_INIT;
            PeriphsInit();
                LedInit();
            Lpc1768Init();
                ClkInit();
                LogInit(ClkNowTmUtc, 115200);
    if (       FramInit()) goto end; //Reserves 1 FRAM byte to detect if empty
           FramAllocate(4);          //Reserves 4 FRAM bytes where the watchdog used to hold the last program position
             CryptoInit();           //Uses log
                NetInit();
    if (SettingsNtpInit()) goto end; //Loads of FRAM
                WebInit();           //No FRAM
            OneWireInit();           //No FRAM
             DeviceInit();           //No FRAM
            HeatingInit();           //Loads of FRAM
    if (   SettingsInit()) goto end;
    if (     ValuesInit()) goto end;
    while (1)
    {   
        RestartZone = RESTART_ZONE_LOG;              LogMain();
        RestartZone = RESTART_ZONE_CLOCK;            ClkMain();
        RestartZone = RESTART_ZONE_NET;              NetMain();
        RestartZone = RESTART_ZONE_VALUES;        ValuesMain();
        RestartZone = RESTART_ZONE_ONE_WIRE; if (OneWireMain()) break;
        RestartZone = RESTART_ZONE_DEVICE;   if ( DeviceMain()) break;
        RestartZone = RESTART_ZONE_HEATING;      HeatingMain();
        RestartZone = RESTART_ZONE_LPC1768;      Lpc1768Main();
        RestartZone = RESTART_ZONE_CRYPTO;        CryptoMain();
    }

end:
    Led1Set(1); Led2Set(1); Led3Set(1); Led4Set(1);
    return 0;
}