#include <string.h>
#include <stdlib.h>

#include "http.h"
#include "watchdog.h"
#include "1-wire-device.h"
#include "boiler.h"
#include "radiator.h"
#include "values.h"
#include "ip4.h"
#include "settings.h"
#include "clktime.h"

void WebSystemQuery(char* pQuery)
{
    while (pQuery)
    {
        char* pName;
        char* pValue;
        pQuery = HttpQuerySplit(pQuery, &pName, &pValue);
        
        HttpQueryUnencode(pValue);

        int value = HttpQueryValueAsInt(pValue);

        if (HttpSameStr(pName, "tftpserver"    )) ValuesSetServerName        (pValue          );
        if (HttpSameStr(pName, "tftpfilename"  )) ValuesSetFileName          (pValue          );
        if (HttpSameStr(pName, "tftpwriteint"  )) ValuesSetWriteSize         (value           );
        if (HttpSameStr(pName, "tftpreadint"   )) ValuesSetReadInterval      (value           );        
    }
}
