#include "http.h"
#include "web-nav-this.h"
#include "web-add.h"

void WebRadiatorHtml()
{
    HttpOk("text/html; charset=UTF-8", "no-cache", NULL, NULL);
    WebAddHeader("Radiator", "settings.css", "radiator.js");
    WebAddNav(RADIATOR_PAGE);
    WebAddH1("Radiator");

    WebAddH2("Output");
    WebAddAjaxLed           ("Radiator pump",     "ajax-radiator-toggle");
    
    WebAddH2("Inputs");
    WebAddAjaxLabelledSuffix("Hall temperature",  "ajax-hall-html", "&deg;C");
    WebAddAjaxLed           ("Programmer output", "ajax-program-toggle");
    
    WebAddH2("Parameters");
    WebAddAjaxInputToggle   ("Mode Summer|Winter",       "ajax-mode-toggle"          , "htg-chg-mode" );
    WebAddAjaxInput         ("Winter (night)",        2, "ajax-night-set-point"      , "nighttemp");
    WebAddAjaxInput         ("Summer (frost)",        2, "ajax-frost-set-point"      , "frosttemp");
    WebAddAjaxInputToggle   ("Override",                 "ajax-override-toggle"      , "htg-chg-override");
    WebAddAjaxInput         ("Override cancel time",  4, "ajax-overide-cancel-minute", "overridecancelminute");
    
    WebAddEnd();

}
