#include  <stdint.h>
#include   <stdio.h>

#include "http.h"
#include "boiler.h"
#include "radiator.h"
#include "ds18b20.h"
#include "program.h"
#include "1-wire-device.h"

void WebRadiatorAjax()
{
    HttpOk("text/plain; charset=UTF-8", "no-cache", NULL, NULL);
                        
    HttpAddInt16AsHex(RadiatorGetHallDS18B20Value()); HttpAddChar('\n');
    
    int nibble = 0;
    if (ProgramTimerOutput   ) nibble |= 0x01;
    if (RadiatorGetWinter()  ) nibble |= 0x02;
    if (RadiatorGetOverride()) nibble |= 0x04;
    if (RadiatorPump         ) nibble |= 0x08;
    HttpAddNibbleAsHex (nibble); HttpAddChar('\n');
    
    HttpAddByteAsHex (RadiatorGetOverrideCancelHour()  ); HttpAddChar('\n');
    HttpAddByteAsHex (RadiatorGetOverrideCancelMinute()); HttpAddChar('\n');
    HttpAddInt16AsHex(RadiatorGetNightTemperature()    ); HttpAddChar('\n');
    HttpAddInt16AsHex(RadiatorGetFrostTemperature()    ); HttpAddChar('\n');
}

