"//Boiler script\n"
"'use strict';\n"
"\n"
"let dateTime           = '';\n"
"let   tankTemperature  = '';\n"
"let blrOutTemperature  = '';\n"
"let blrRtnTemperature  = '';\n"
"let blrAlnTemperature  = '';\n"
"let blrDeltaT          = '';\n"
"let boilerEnable       = false;\n"
"let boilerCall         = false;\n"
"let boilerPump         = false;\n"
"let fullSpeedSecs      = '';\n"
"let tankSetPoint       = '';\n"
"let tankHysteresis     = '';\n"
"let blrRunOnDeg        = '';\n"
"let blrRunOnTime       = '';\n"
"let blrPumpSpeed       = '';\n"
"let blrPumpPwm         = '';\n"
"let pumpSpeedCalling   = '';\n"
"let pumpSpeedRunOn     = '';\n"
"let blrOutputTarget    = '';\n"
"let minSpeed           = '';\n"
"let riseAt50           = '';\n"
"let riseAt100          = '';\n"
"\n"
"function parse()\n"
"{\n"
"    let lines = Ajax.response.split('\\n');\n"
"      tankTemperature = Ajax.hexToSignedInt16(lines[ 0]);\n"
"    blrOutTemperature = Ajax.hexToSignedInt16(lines[ 1]);\n"
"    blrRtnTemperature = Ajax.hexToSignedInt16(lines[ 2]);\n"
"    blrAlnTemperature = Ajax.hexToSignedInt16(lines[ 3]);\n"
"    blrDeltaT         = Ajax.hexToSignedInt16(lines[ 4]);\n"
"    boilerCall        = Ajax.hexToBit        (lines[ 5], 0);\n"
"    boilerPump        = Ajax.hexToBit        (lines[ 5], 1);\n"
"    boilerEnable      = Ajax.hexToBit        (lines[ 5], 2);\n"
"    fullSpeedSecs     = Ajax.hexToSignedInt16(lines[ 6]);\n"
"    tankSetPoint      = Ajax.hexToSignedInt16(lines[ 7]);\n"
"    tankHysteresis    = Ajax.hexToSignedInt16(lines[ 8]);\n"
"    blrRunOnDeg       = Ajax.hexToSignedInt16(lines[ 9]);\n"
"    blrRunOnTime      = Ajax.hexToSignedInt16(lines[10]);\n"
"    blrPumpSpeed      = Ajax.hexToSignedInt16(lines[11]);\n"
"    blrPumpPwm        = Ajax.hexToSignedInt16(lines[12]);\n"
"    pumpSpeedCalling  = Ajax.hexToSignedInt16(lines[13]);\n"
"    if (pumpSpeedCalling == -1) pumpSpeedCalling = 'A';\n"
"    if (pumpSpeedCalling == -2) pumpSpeedCalling = 'T';\n"
"    pumpSpeedRunOn    = Ajax.hexToSignedInt16(lines[14]);\n"
"    blrOutputTarget   = Ajax.hexToSignedInt16(lines[15]);\n"
"    minSpeed          = Ajax.hexToSignedInt16(lines[16]);\n"
"    riseAt50          = Ajax.hexToSignedInt16(lines[17]);\n"
"    riseAt100         = Ajax.hexToSignedInt16(lines[18]);\n"
"}\n"
"function display()\n"
"{\n"
"    let elem;\n"
"    elem = Ajax.getElementOrNull('ajax-tank-html'      ); if (elem) elem.textContent = OneWire.DS18B20ToString(tankTemperature);\n"
"    elem = Ajax.getElementOrNull('ajax-blr-out-html'   ); if (elem) elem.textContent = OneWire.DS18B20ToString(blrOutTemperature);\n"
"    elem = Ajax.getElementOrNull('ajax-blr-rtn-html'   ); if (elem) elem.textContent = OneWire.DS18B20ToString(blrRtnTemperature);\n"
"    elem = Ajax.getElementOrNull('ajax-blr-aln-html'   ); if (elem) elem.textContent = OneWire.DS18B20ToString(blrAlnTemperature);\n"
"    elem = Ajax.getElementOrNull('ajax-blr-rise-html'  ); if (elem) elem.textContent = OneWire.DS18B20ToString(blrDeltaT);\n"
"    \n"
"    elem = Ajax.getElementOrNull('ajax-blr-pump-speed-html'); if (elem) elem.textContent = blrPumpSpeed;\n"
"    elem = Ajax.getElementOrNull('ajax-blr-pump-pwm-html'  ); if (elem) elem.textContent = blrPumpPwm;\n"
"    \n"
"    elem = Ajax.getElementOrNull('ajax-blr-call-toggle'   ); if (elem) elem.setAttribute('dir', boilerCall   ? 'rtl' : 'ltr');\n"
"    elem = Ajax.getElementOrNull('ajax-blr-pump-toggle'   ); if (elem) elem.setAttribute('dir', boilerPump   ? 'rtl' : 'ltr');\n"
"    elem = Ajax.getElementOrNull('ajax-blr-enable-toggle' ); if (elem) elem.setAttribute('dir', boilerEnable ? 'rtl' : 'ltr');\n"
"    elem = Ajax.getElementOrNull('ajax-full-speed-secs'   ); if (elem) elem.value = fullSpeedSecs;\n"
"    elem = Ajax.getElementOrNull('ajax-tank-set-point'    ); if (elem) elem.value = tankSetPoint;\n"
"    elem = Ajax.getElementOrNull('ajax-tank-hysteresis'   ); if (elem) elem.value = tankHysteresis;\n"
"    elem = Ajax.getElementOrNull('ajax-blr-run-on-deg'    ); if (elem) elem.value = OneWire.DS18B20ToString(blrRunOnDeg);\n"
"    elem = Ajax.getElementOrNull('ajax-blr-run-on-time'   ); if (elem) elem.value = blrRunOnTime;\n"
"    \n"
"    elem = Ajax.getElementOrNull('ajax-pump-speed-calling'); if (elem) elem.value = pumpSpeedCalling;\n"
"    elem = Ajax.getElementOrNull('ajax-pump-speed-run-on' ); if (elem) elem.value = pumpSpeedRunOn;\n"
"    elem = Ajax.getElementOrNull('ajax-blr-output-target' ); if (elem) elem.value = blrOutputTarget;\n"
"    \n"
"    elem = Ajax.getElementOrNull('ajax-min-speed-value'   ); if (elem) elem.value = minSpeed;\n"
"    elem = Ajax.getElementOrNull('ajax-min-speed-text'    ); if (elem) elem.textContent = minSpeed;\n"
"    elem = Ajax.getElementOrNull('ajax-pump-rise-at-50'   ); if (elem) elem.value = riseAt50;\n"
"    elem = Ajax.getElementOrNull('ajax-pump-rise-at-100'  ); if (elem) elem.value = OneWire.DS18B20ToString(riseAt100);\n"
"}\n"
"\n"
"Ajax.server     = '/boiler-ajax';\n"
"Ajax.onResponse = function() { parse(); display(); };\n"
"Ajax.init();\n"
""