#include <stdint.h>
#include <string.h>
#include <stdbool.h>
#include <stdint.h>

#include "ds18b20.h"
#include "fram.h"

static char*    hotWaterRom;         static int iHotWaterRom;

uint16_t HotWaterGetDS18B20Value(){ return DS18B20ValueFromRom(hotWaterRom); }

static void  setHotWaterRom          (char* value) { memcpy(hotWaterRom,  value, 8);        FramWrite(iHotWaterRom,          8,  hotWaterRom         ); }

int HotWaterInit()
{
    hotWaterRom = DS18B20Roms + 8 * DS18B20RomCount;
    DS18B20RomSetters[DS18B20RomCount] = setHotWaterRom;
    DS18B20RomNames[DS18B20RomCount] = "HotWater";
    DS18B20RomCount++;

    int  address;
    char    def1;
    int32_t def4;
               address = FramLoad( 8,  hotWaterRom,              0); if (address < 0) return -1; iHotWaterRom          = address;
    return 0;
}