//Radiator script
'use strict';

let   hallTemperature    = '';
let programTimerOutput   = false;
let radiatorMode         = false;
let radiatorOverride     = false;
let radiatorPump         = false;
let overrideCancelHour = '';
let overrideCancelMinute = '';
let nightSetPoint        = '';
let frostSetPoint        = '';

function parse()
{
    let lines = Ajax.response.split('\n');
    hallTemperature      = Ajax.hexToSignedInt16(lines[0]);
    programTimerOutput   = Ajax.hexToBit        (lines[1],  0);
    radiatorMode         = Ajax.hexToBit        (lines[1],  1);
    radiatorOverride     = Ajax.hexToBit        (lines[1],  2);
    radiatorPump         = Ajax.hexToBit        (lines[1],  3);
    overrideCancelHour   = Ajax.hexToSignedInt8 (lines[2]);
    overrideCancelMinute = Ajax.hexToSignedInt8 (lines[3]);
    nightSetPoint        = Ajax.hexToSignedInt16(lines[4]);
    frostSetPoint        = Ajax.hexToSignedInt16(lines[5]);
}
function display()
{
    let elem;
    elem = Ajax.getElementOrNull('ajax-hall-html'            ); if (elem) elem.textContent =  OneWire.DS18B20ToString(hallTemperature);
    elem = Ajax.getElementOrNull('ajax-program-toggle'       ); if (elem) elem.setAttribute('dir', programTimerOutput ? 'rtl' : 'ltr');
    elem = Ajax.getElementOrNull('ajax-mode-toggle'          ); if (elem) elem.setAttribute('dir', radiatorMode       ? 'rtl' : 'ltr');
    elem = Ajax.getElementOrNull('ajax-override-toggle'      ); if (elem) elem.setAttribute('dir', radiatorOverride   ? 'rtl' : 'ltr');
    elem = Ajax.getElementOrNull('ajax-radiator-toggle'      ); if (elem) elem.setAttribute('dir', radiatorPump       ? 'rtl' : 'ltr');
    elem = Ajax.getElementOrNull('ajax-overide-cancel-minute'); if (elem)
    {
        elem.value = String(overrideCancelHour*100 + overrideCancelMinute).padStart(4, '0');
    }
    elem = Ajax.getElementOrNull('ajax-night-set-point'      ); if (elem) elem.value = nightSetPoint;
    elem = Ajax.getElementOrNull('ajax-frost-set-point'      ); if (elem) elem.value = frostSetPoint;
}

Ajax.server     = '/radiator-ajax';
Ajax.onResponse = function() { parse(); display(); };
Ajax.init();
