#include <stdbool.h>

#include   "gpio.h"
#include    "log.h"
#include    "eth.h"
#include "action.h"
#include    "mac.h"
#include    "net.h"
#include   "link.h"
#include    "nic.h"
#include    "led.h"
#include "restart.h"
#include   "jack.h"

#define  LINK_PIN FIO1PIN(25)
#define SPEED_PIN FIO1PIN(26)

bool LinkTrace = false;

void LinkMain()
{
    int lastRestartPoint = RestartPoint;
    RestartPoint = FAULT_POINT_LinkMain;
    
    //Wait until the network is up
    if (!NicLinkIsUp())
    {
        RestartPoint = lastRestartPoint;
        return;
    }
    
    //Reset the trace of host at the very start
    NetTraceHostResetMatched();
    
    //Handle packets
    int sizeRx;
    int sizeTx;
    char* pRx = NicGetReceivedPacketOrNull(&sizeRx);
    char* pTx = NicGetTransmitPacketOrNull(&sizeTx);
    
    int  action   = DO_NOTHING;
    bool activity = false;
    if (pRx)
    {
        activity = true;
        
        if (pTx) action = EthHandlePacket(pRx, sizeRx, pTx, &sizeTx);
        
        NicReleaseReceivedPacket();
    }
    
    if (pTx)
    {
        if (!action) action = EthPollForPacketToSend(pTx, &sizeTx);
    
        if ( action)
        {
            activity = true;
            NicSendTransmitPacket(sizeTx);
        }
    }
    
    //Flash lights
    JackLeds(!LINK_PIN, !SPEED_PIN, activity);
    
    //Finish
    RestartPoint = lastRestartPoint;
}

void LinkInit()
{
    JackInit();
    NicInit();
    NicLinkAddress(MacLocal);
    if (LinkTrace)
    {
        LogTime("MAC ");
        MacLog(MacLocal);
        Log("\r\n");
    }
}