#include "http.h"
#include "web-pages-this.h"
#include "web.h"

#define DO_HOME_HTML       DO_THIS + 0
#define DO_BATTERY_HTML    DO_THIS + 1
#define DO_BATTERY_AJAX    DO_THIS + 2
#define DO_BATTERY_SCRIPT  DO_THIS + 3
#define DO_SYSTEM_HTML     DO_THIS + 4
#define DO_SYSTEM_AJAX     DO_THIS + 5
#define DO_SYSTEM_SCRIPT   DO_THIS + 6

int WebServerThisDecideWhatToDo(char *pPath, char* pLastModified)
{
    if (HttpSameStr(pPath, "/"             )) return DO_HOME_HTML;
    if (HttpSameStr(pPath, "/battery"      )) return DO_BATTERY_HTML;
    if (HttpSameStr(pPath, "/battery-ajax" )) return DO_BATTERY_AJAX;
    if (HttpSameStr(pPath, "/system"       )) return DO_SYSTEM_HTML;
    if (HttpSameStr(pPath, "/system-ajax"  )) return DO_SYSTEM_AJAX;
    
    if (HttpSameStr(pPath, "/battery.js"   )) return HttpSameDate(WebBatteryScriptDate,  WebBatteryScriptTime,  pLastModified) ? DO_NOT_MODIFIED : DO_BATTERY_SCRIPT;
    if (HttpSameStr(pPath, "/system.js"    )) return HttpSameDate(WebSystemScriptDate,   WebSystemScriptTime,   pLastModified) ? DO_NOT_MODIFIED : DO_SYSTEM_SCRIPT;

    return DO_NOT_FOUND;
}

bool WebServerThisHandleQuery(int todo, char* pQuery)
{
    switch (todo)
    {
        case DO_BATTERY_AJAX:  WebBatteryQuery (pQuery); return true;
        case DO_BATTERY_HTML:  WebBatteryQuery (pQuery); return true;
        case DO_SYSTEM_HTML:   WebSystemQuery  (pQuery); return true;
        case DO_SYSTEM_AJAX:   WebSystemQuery  (pQuery); return true;
    }
    return false;
}
bool WebServerThisPost(int todo, int contentLength, int contentStart, int size, char* pRequestStream, uint32_t positionInRequestStream, bool* pComplete)
{
    return false;
}
bool WebServerThisReply(int todo)
{
    switch (todo)
    {
        case DO_HOME_HTML:       WebHomeHtml      (); return true;
        case DO_BATTERY_HTML:    WebBatteryHtml   (); return true;
        case DO_BATTERY_AJAX:    WebBatteryAjax   (); return true;
        case DO_BATTERY_SCRIPT:  WebBatteryScript (); return true;
        case DO_SYSTEM_HTML:     WebSystemHtml    (); return true;
        case DO_SYSTEM_AJAX:     WebSystemAjax    (); return true;
        case DO_SYSTEM_SCRIPT:   WebSystemScript  (); return true;
    }
    return false;
}
