#include <stdlib.h>
#include <string.h>
#include "http.h"
#include "comms.h"

void WebBatteryQuery(char* pQuery)
{
    while (pQuery)
    {
        char* pName;
        char* pValue;
        pQuery = HttpQuerySplit(pQuery, &pName, &pValue);
                    
        if (HttpSameStr(pName, "set-battery-counted-capacity"))
        {
            int value = HttpQueryValueAsInt(pValue);
            BatterySetCountedCapacity(value);
            return;
        }
        if (HttpSameStr(pName, "set-battery-counted-capacity-amp-hours"))
        {
            int value = HttpQueryValueAsInt(pValue);
            BatterySetCountedCapacity(value * 3600);
            return;
        }
        if (HttpSameStr(pName, "set-battery-counted-capacity-percent"))
        {
            int value = HttpQueryValueAsInt(pValue);
            BatterySetCountedCapacity(value * 36 * 280);
            return;
        }
        if (HttpSameStr(pName, "set-battery-counted-error"))
        {
            int value = HttpQueryValueAsInt(pValue);
            BatterySetCountedError(value);
            return;
        }
        if (HttpSameStr(pName, "set-battery-capacity-setpoint-percent"))
        {
            int value = HttpQueryValueAsInt(pValue);
            BatterySetCapacitySetPointPercent(value);
            return;
        }
        if (HttpSameStr(pName, "chg-battery-charge-enabled"))
        {
            BatterySetChargeEnabled(!BatteryGetChargeEnabled());
            return;
        }
        if (HttpSameStr(pName, "chg-battery-discharge-enabled"))
        {
            BatterySetDischargeEnabled(!BatteryGetDischargeEnabled());
            return;
        }
        if (HttpSameStr(pName, "set-battery-temperature-setpoint"))
        {
            int value = HttpQueryValueAsDouble(pValue)*10;
            BatterySetTemperatureSetPoint(value);
            return;
        }
        if (HttpSameStr(pName, "chg-battery-auto-update"))
        {
            BatterySetCapacityAutoUpdate(!BatteryGetCapacityAutoUpdate());
            return;
        }
    }
}
