#include <stdint.h>

#include "can.h"
#include "mstimer.h"
#include "log.h"
#include "comms.h"

#define CAN_ID_BATTERY                   0x100
#define CAN_ID_COUNTED_AMP_SECONDS        0x00
#define CAN_ID_COUNTED_ERROR_PERCENT      0x01
#define CAN_ID_MA                         0x02
#define CAN_ID_OUTPUT_SETPOINT            0x03
#define CAN_ID_OUTPUT_STATE               0x04
#define CAN_ID_CHARGE_ENABLED             0x05
#define CAN_ID_DISCHARGE_ENABLED          0x06
#define CAN_ID_TEMPERATURE_TENTHS         0x07
#define CAN_ID_HEATER_SET_POINT           0x08
#define CAN_ID_HEATER_OUTPUT              0x09
#define CAN_ID_VOLTAGE                    0x0A
#define CAN_ID_MEASURED_SOC_PERCENT       0x0B
#define CAN_ID_MEASURED_SOC_ERROR         0x0C
#define CAN_ID_CAPACITY_AUTO_UPDATE       0x0D


static uint32_t _batteryCountedCapacity         = 0;
static uint8_t  _batteryCountedError            = 0;
static int32_t  _batteryCurrentMa               = 0;
static uint8_t  _batteryCapacitySetPointPercent = 0;
static char     _batteryOutputState             = ' ';
static char     _batteryChargeEnabled           = 0;
static char     _batteryDischargeEnabled        = 0;
static int16_t  _batteryTemperatureTenths       = 0;
static int16_t  _batteryTemperatureSetPoint     = 0;
static uint8_t  _batteryHeaterOutputPercent     = 0;
static int16_t  _batteryVoltageMv               = 0;
static uint8_t  _batteryMeasuredPercent         = 0;
static uint8_t  _batteryMeasuredError           = 0;
static char     _batteryCapacityAutoUpdate      = 0;
 
uint32_t BatteryGetCountedCapacity         (){ return _batteryCountedCapacity;         }
 uint8_t BatteryGetCountedError            (){ return _batteryCountedError;            }
 int32_t BatteryGetCurrentMa               (){ return _batteryCurrentMa;               }
 uint8_t BatteryGetCapacitySetPointPercent (){ return _batteryCapacitySetPointPercent; }
 char    BatteryGetOutputState             (){ return _batteryOutputState;             }
 char    BatteryGetChargeEnabled           (){ return _batteryChargeEnabled;           }
 char    BatteryGetDischargeEnabled        (){ return _batteryDischargeEnabled;        }
 int16_t BatteryGetTemperatureTenths       (){ return _batteryTemperatureTenths;       }
 int16_t BatteryGetTemperatureSetPoint     (){ return _batteryTemperatureSetPoint;     }
 uint8_t BatteryGetHeaterOutputPercent     (){ return _batteryHeaterOutputPercent;     }
 int16_t BatteryGetVoltageMv               (){ return _batteryVoltageMv;               }
 uint8_t BatteryGetMeasuredPercent         (){ return _batteryMeasuredPercent;         }
 uint8_t BatteryGetMeasuredError           (){ return _batteryMeasuredError;           }
 char    BatteryGetCapacityAutoUpdate      (){ return _batteryCapacityAutoUpdate;      }
 
void BatterySetCountedCapacity        (uint32_t value){ _batteryCountedCapacity         = value; CanSend(CAN_ID_BATTERY + CAN_ID_COUNTED_AMP_SECONDS  , 4, value, 0);}
void BatterySetCountedError           (uint8_t  value){ _batteryCountedError            = value; CanSend(CAN_ID_BATTERY + CAN_ID_COUNTED_ERROR_PERCENT, 1, value, 0);}
void BatterySetCurrentMa              (int32_t  value){ _batteryCurrentMa               = value; CanSend(CAN_ID_BATTERY + CAN_ID_MA                   , 4, value, 0);}
void BatterySetCapacitySetPointPercent(uint8_t  value){ _batteryCapacitySetPointPercent = value; CanSend(CAN_ID_BATTERY + CAN_ID_OUTPUT_SETPOINT      , 1, value, 0);}
void BatterySetOutputState            (char     value){ _batteryOutputState             = value; CanSend(CAN_ID_BATTERY + CAN_ID_OUTPUT_STATE         , 1, value, 0);}
void BatterySetChargeEnabled          (char     value){ _batteryChargeEnabled           = value; CanSend(CAN_ID_BATTERY + CAN_ID_CHARGE_ENABLED       , 1, value, 0);}
void BatterySetDischargeEnabled       (char     value){ _batteryDischargeEnabled        = value; CanSend(CAN_ID_BATTERY + CAN_ID_DISCHARGE_ENABLED    , 1, value, 0);}
void BatterySetTemperatureSetPoint    (int16_t  value){ _batteryTemperatureSetPoint     = value; CanSend(CAN_ID_BATTERY + CAN_ID_HEATER_SET_POINT     , 2, value, 0);}
void BatterySetCapacityAutoUpdate     (char     value){ _batteryCapacityAutoUpdate      = value; CanSend(CAN_ID_BATTERY + CAN_ID_CAPACITY_AUTO_UPDATE , 1, value, 0);}

static void receive(uint16_t id, int length, uint32_t dataA, uint32_t dataB)
{
    switch(id)
    {
        case CAN_ID_BATTERY + CAN_ID_COUNTED_AMP_SECONDS:   _batteryCountedCapacity         = (uint32_t)dataA; break;
        case CAN_ID_BATTERY + CAN_ID_COUNTED_ERROR_PERCENT: _batteryCountedError            = ( uint8_t)dataA; break;
        case CAN_ID_BATTERY + CAN_ID_MA:                    _batteryCurrentMa               = ( int32_t)dataA; break;
        case CAN_ID_BATTERY + CAN_ID_OUTPUT_SETPOINT:       _batteryCapacitySetPointPercent = ( uint8_t)dataA; break;
        case CAN_ID_BATTERY + CAN_ID_OUTPUT_STATE:          _batteryOutputState             = (    char)dataA; break;
        case CAN_ID_BATTERY + CAN_ID_CHARGE_ENABLED:        _batteryChargeEnabled           = (    char)dataA; break;
        case CAN_ID_BATTERY + CAN_ID_DISCHARGE_ENABLED:     _batteryDischargeEnabled        = (    char)dataA; break;
        case CAN_ID_BATTERY + CAN_ID_TEMPERATURE_TENTHS:    _batteryTemperatureTenths       = ( int16_t)dataA; break;
        case CAN_ID_BATTERY + CAN_ID_HEATER_SET_POINT:      _batteryTemperatureSetPoint     = ( int16_t)dataA; break;
        case CAN_ID_BATTERY + CAN_ID_HEATER_OUTPUT:         _batteryHeaterOutputPercent     = ( uint8_t)dataA; break;
        case CAN_ID_BATTERY + CAN_ID_VOLTAGE:               _batteryVoltageMv               = ( int16_t)dataA; break;
        case CAN_ID_BATTERY + CAN_ID_MEASURED_SOC_PERCENT:  _batteryMeasuredPercent         = ( uint8_t)dataA; break;
        case CAN_ID_BATTERY + CAN_ID_MEASURED_SOC_ERROR:    _batteryMeasuredError           = ( uint8_t)dataA; break;
        case CAN_ID_BATTERY + CAN_ID_CAPACITY_AUTO_UPDATE:  _batteryCapacityAutoUpdate      = (    char)dataA; break;
        default:
            LogTimeF("Unknown CAN message id %03X received containing %d bytes: %0*X\r\n", id, length, length*2, dataA);
            break;
    }
}
void CommsInit()
{
    CanReceive = &receive;
}
void CommsMain()
{
}