#include "lpc1768.h"
#include "periphs.h"
#include "led.h"
#include "clk.h"
#include "log.h"
#include "fram.h"
#include "net.h"
#include "settings.h"
#include "web.h"
#include "settings.h"
#include "values.h"
#include "restart.h"
#include "restart-this.h"
#include "crypto.h"
#include "i2c1.h"
#include "lcd.h"
#include "can.h"
#include "comms.h"

int main()
{
    RestartZone = RESTART_ZONE_INIT;
            PeriphsInit();
                LedInit();
            Lpc1768Init();
                ClkInit();
                LogInit(ClkNowTmUtc, 115200);
    if (       FramInit()) goto end; //Reserves 1 FRAM byte to detect if empty
           FramAllocate(4);          //Reserves 4 FRAM bytes where the watchdog used to hold the last program position
             CryptoInit();           //Uses log
                NetInit();
    if (SettingsNtpInit()) goto end; //Loads of FRAM
                WebInit();           //No FRAM
    if (   SettingsInit()) goto end;
    if (     ValuesInit()) goto end;
               I2C1Init();
                LcdInit();
                CanInit();
              CommsInit();
    while (1)
    {   
        RestartZone = RESTART_ZONE_LOG;              LogMain();
        RestartZone = RESTART_ZONE_CLOCK;            ClkMain();
        RestartZone = RESTART_ZONE_NET;              NetMain();
        RestartZone = RESTART_ZONE_VALUES;        ValuesMain();
        RestartZone = RESTART_ZONE_LPC1768;      Lpc1768Main();
        RestartZone = RESTART_ZONE_CRYPTO;        CryptoMain();
        I2C1Main();
         LcdMain();
         CanMain();
       CommsMain();
    }

end:
    Led1Set(1); Led2Set(1); Led3Set(1); Led4Set(1);
    return 0;
}