//Battery script
'use strict';

let batteryCountedCapacity     = '';
let batteryCountedError        = '';
let batteryCurrentMa           = '';
let batteryCapacitySetpoint    = '';
let batteryOutputState         = '';
let batteryChargeEnabled       = false;
let batteryDischargeEnabled    = false;
let batteryTemperatureTenths   = '';
let batteryTemperatureSetPoint = '';
let batteryHeaterPercent       = '';
let batteryVoltageMv           = '';
let batteryMeasuredPercent     = '';
let batteryMeasuredError       = '';
let batteryMeasuredAutoUpdate  = false;

function parse()
{
    let lines = Ajax.response.split('\n');
    batteryCountedCapacity     = Ajax.hexToSignedInt32(lines[ 0]);
    batteryCountedError        = Ajax.hexToSignedInt8 (lines[ 1]);
    batteryCurrentMa           = Ajax.hexToSignedInt32(lines[ 2]);
    batteryCapacitySetpoint    = Ajax.hexToSignedInt8 (lines[ 3]);
    batteryOutputState         =                       lines[ 4];
    batteryChargeEnabled       = Ajax.hexToBit        (lines[ 5], 0);
    batteryDischargeEnabled    = Ajax.hexToBit        (lines[ 5], 1);
    batteryTemperatureTenths   = Ajax.hexToSignedInt16(lines[ 6]);
    batteryTemperatureSetPoint = Ajax.hexToSignedInt16(lines[ 7]);
    batteryHeaterPercent       = Ajax.hexToSignedInt8 (lines[ 8]);
    batteryVoltageMv           = Ajax.hexToSignedInt16(lines[ 9]);
    batteryMeasuredPercent     = Ajax.hexToSignedInt8 (lines[10]);
    batteryMeasuredError       = Ajax.hexToSignedInt8 (lines[11]);
    batteryMeasuredAutoUpdate  = Ajax.hexToSignedInt8 (lines[12]);
}
function display()
{
    let elem;
    elem = Ajax.getElementOrNull('txt-battery-counted-capacity-amp-seconds' ); if (elem) elem.textContent = batteryCountedCapacity;
    elem = Ajax.getElementOrNull('val-battery-counted-error'                ); if (elem) elem.value       = batteryCountedError;
    elem = Ajax.getElementOrNull('txt-battery-counted-capacity-amp-hours'   ); if (elem) elem.textContent = Math.round(batteryCountedCapacity/3600);
    elem = Ajax.getElementOrNull('txt-battery-counted-capacity-percent'     ); if (elem) elem.textContent = Math.round(batteryCountedCapacity/36/280);
    elem = Ajax.getElementOrNull('val-battery-counted-capacity-percent'     ); if (elem) elem.value       = Math.round(batteryCountedCapacity/36/280);
    elem = Ajax.getElementOrNull('txt-battery-current-ma'                   ); if (elem) elem.textContent = batteryCurrentMa;
    elem = Ajax.getElementOrNull('val-battery-capacity-setpoint-percent'    ); if (elem) elem.value       = batteryCapacitySetpoint;
    elem = Ajax.getElementOrNull('txt-battery-output-state'                 ); if (elem) elem.textContent = batteryOutputState;
    elem = Ajax.getElementOrNull('att-battery-charge-enabled'               ); if (elem) elem.setAttribute('dir', batteryChargeEnabled    ? 'rtl' : 'ltr');
    elem = Ajax.getElementOrNull('att-battery-discharge-enabled'            ); if (elem) elem.setAttribute('dir', batteryDischargeEnabled ? 'rtl' : 'ltr');
    elem = Ajax.getElementOrNull('txt-battery-temperature-tenths'           ); if (elem) elem.textContent = (batteryTemperatureTenths/10).toFixed(1);
    elem = Ajax.getElementOrNull('val-battery-temperature-setpoint'         ); if (elem) elem.value       = (batteryTemperatureSetPoint/10).toFixed(1);
    elem = Ajax.getElementOrNull('txt-battery-heater-output-percent'        ); if (elem) elem.textContent = batteryHeaterPercent;
    elem = Ajax.getElementOrNull('txt-battery-voltage-mv'                   ); if (elem) elem.textContent = batteryVoltageMv;
    elem = Ajax.getElementOrNull('txt-battery-measured-percent'             ); if (elem) elem.textContent = batteryMeasuredPercent;
    elem = Ajax.getElementOrNull('txt-battery-measured-error'               ); if (elem) elem.textContent = batteryMeasuredError;
    elem = Ajax.getElementOrNull('att-battery-auto-update'                  ); if (elem) elem.setAttribute('dir', batteryMeasuredAutoUpdate ? 'rtl' : 'ltr');
}

Ajax.server     = '/battery-ajax';
Ajax.onResponse = function() { parse(); display(); };
Ajax.init();
