"//Battery script\n"
"'use strict';\n"
"\n"
"let batteryCountedCapacity     = '';\n"
"let batteryCountedError        = '';\n"
"let batteryCurrentMa           = '';\n"
"let batteryCapacitySetpoint    = '';\n"
"let batteryOutputState         = '';\n"
"let batteryChargeEnabled       = false;\n"
"let batteryDischargeEnabled    = false;\n"
"let batteryTemperatureTenths   = '';\n"
"let batteryTemperatureSetPoint = '';\n"
"let batteryHeaterPercent       = '';\n"
"let batteryVoltageMv           = '';\n"
"let batteryMeasuredPercent     = '';\n"
"let batteryMeasuredError       = '';\n"
"let batteryMeasuredAutoUpdate  = false;\n"
"\n"
"function parse()\n"
"{\n"
"    let lines = Ajax.response.split('\\n');\n"
"    batteryCountedCapacity     = Ajax.hexToSignedInt32(lines[ 0]);\n"
"    batteryCountedError        = Ajax.hexToSignedInt8 (lines[ 1]);\n"
"    batteryCurrentMa           = Ajax.hexToSignedInt32(lines[ 2]);\n"
"    batteryCapacitySetpoint    = Ajax.hexToSignedInt8 (lines[ 3]);\n"
"    batteryOutputState         =                       lines[ 4];\n"
"    batteryChargeEnabled       = Ajax.hexToBit        (lines[ 5], 0);\n"
"    batteryDischargeEnabled    = Ajax.hexToBit        (lines[ 5], 1);\n"
"    batteryTemperatureTenths   = Ajax.hexToSignedInt16(lines[ 6]);\n"
"    batteryTemperatureSetPoint = Ajax.hexToSignedInt16(lines[ 7]);\n"
"    batteryHeaterPercent       = Ajax.hexToSignedInt8 (lines[ 8]);\n"
"    batteryVoltageMv           = Ajax.hexToSignedInt16(lines[ 9]);\n"
"    batteryMeasuredPercent     = Ajax.hexToSignedInt8 (lines[10]);\n"
"    batteryMeasuredError       = Ajax.hexToSignedInt8 (lines[11]);\n"
"    batteryMeasuredAutoUpdate  = Ajax.hexToSignedInt8 (lines[12]);\n"
"}\n"
"function display()\n"
"{\n"
"    let elem;\n"
"    elem = Ajax.getElementOrNull('txt-battery-counted-capacity-amp-seconds' ); if (elem) elem.textContent = batteryCountedCapacity;\n"
"    elem = Ajax.getElementOrNull('val-battery-counted-error'                ); if (elem) elem.value       = batteryCountedError;\n"
"    elem = Ajax.getElementOrNull('txt-battery-counted-capacity-amp-hours'   ); if (elem) elem.textContent = Math.round(batteryCountedCapacity/3600);\n"
"    elem = Ajax.getElementOrNull('txt-battery-counted-capacity-percent'     ); if (elem) elem.textContent = Math.round(batteryCountedCapacity/36/280);\n"
"    elem = Ajax.getElementOrNull('val-battery-counted-capacity-percent'     ); if (elem) elem.value       = Math.round(batteryCountedCapacity/36/280);\n"
"    elem = Ajax.getElementOrNull('txt-battery-current-ma'                   ); if (elem) elem.textContent = batteryCurrentMa;\n"
"    elem = Ajax.getElementOrNull('val-battery-capacity-setpoint-percent'    ); if (elem) elem.value       = batteryCapacitySetpoint;\n"
"    elem = Ajax.getElementOrNull('txt-battery-output-state'                 ); if (elem) elem.textContent = batteryOutputState;\n"
"    elem = Ajax.getElementOrNull('att-battery-charge-enabled'               ); if (elem) elem.setAttribute('dir', batteryChargeEnabled    ? 'rtl' : 'ltr');\n"
"    elem = Ajax.getElementOrNull('att-battery-discharge-enabled'            ); if (elem) elem.setAttribute('dir', batteryDischargeEnabled ? 'rtl' : 'ltr');\n"
"    elem = Ajax.getElementOrNull('txt-battery-temperature-tenths'           ); if (elem) elem.textContent = (batteryTemperatureTenths/10).toFixed(1);\n"
"    elem = Ajax.getElementOrNull('val-battery-temperature-setpoint'         ); if (elem) elem.value       = (batteryTemperatureSetPoint/10).toFixed(1);\n"
"    elem = Ajax.getElementOrNull('txt-battery-heater-output-percent'        ); if (elem) elem.textContent = batteryHeaterPercent;\n"
"    elem = Ajax.getElementOrNull('txt-battery-voltage-mv'                   ); if (elem) elem.textContent = batteryVoltageMv;\n"
"    elem = Ajax.getElementOrNull('txt-battery-measured-percent'             ); if (elem) elem.textContent = batteryMeasuredPercent;\n"
"    elem = Ajax.getElementOrNull('txt-battery-measured-error'               ); if (elem) elem.textContent = batteryMeasuredError;\n"
"    elem = Ajax.getElementOrNull('att-battery-auto-update'                  ); if (elem) elem.setAttribute('dir', batteryMeasuredAutoUpdate ? 'rtl' : 'ltr');\n"
"}\n"
"\n"
"Ajax.server     = '/battery-ajax';\n"
"Ajax.onResponse = function() { parse(); display(); };\n"
"Ajax.init();\n"
""