#include "http.h"
#include "web-nav-this.h"
#include "web-add.h"

void WebBatteryHtml()
{
    HttpOk("text/html; charset=UTF-8", "no-cache", NULL, NULL);
    WebAddHeader("Battery", "settings.css", "battery.js");
    WebAddNav(BATTERY_PAGE);
    WebAddH1("Battery");
    
    WebAddH2("Counted capacity");
    WebAddAjaxLabelled   ("Battery capacity Ah"                   , "txt-battery-counted-capacity-amp-hours"                                         );
    WebAddAjaxInput      ("Battery capacity  %"                , 2, "val-battery-counted-capacity-percent", "set-battery-counted-capacity-percent"   );
    WebAddAjaxInput      ("Battery error  %"                   , 2, "val-battery-counted-error"           , "set-battery-counted-error"              );
    WebAddAjaxLabelled   ("Battery current  mA"                   , "txt-battery-current-ma"                                                         );
    
    WebAddH2("Measured capacity");
    WebAddAjaxLabelled   ("Battery voltage mV"                    , "txt-battery-voltage-mv"                                                          );
    WebAddAjaxLabelled   ("Battery measured capacity"             , "txt-battery-measured-percent"                                                    );
    WebAddAjaxLabelled   ("Battery measured error"                , "txt-battery-measured-error"                                                      );
    WebAddAjaxInputToggle("Battery capacity auto update"          , "att-battery-auto-update"             , "chg-battery-auto-update"                 );
    
    WebAddH2("Temperature");
    WebAddAjaxLabelled   ("Battery temperature &deg;C"            , "txt-battery-temperature-tenths"                                                 );
    WebAddAjaxInput      ("Battery heater setpoint &deg;C",      3, "val-battery-temperature-setpoint"     , "set-battery-temperature-setpoint"      );
    WebAddAjaxLabelled   ("Battery heater output %"               , "txt-battery-heater-output-percent"                                              );

    WebAddH2("Mode");
    WebAddAjaxInput      ("Battery capacity setpoint (%)"      , 2, "val-battery-capacity-setpoint-percent", "set-battery-capacity-setpoint-percent" );
    WebAddAjaxLabelled   ("Battery mode"                          , "txt-battery-output-state"                                                       );
    WebAddAjaxInputToggle("Battery charge enable"                 , "att-battery-charge-enabled"           , "chg-battery-charge-enabled"            );
    WebAddAjaxInputToggle("Battery discharge enable"              , "att-battery-discharge-enabled"        , "chg-battery-discharge-enabled"         );

    WebAddEnd();
    
}